/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.assetstudio;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.assetstudiolib.ActionBarIconGenerator;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.assetstudiolib.LauncherIconGenerator;
import com.android.assetstudiolib.MenuIconGenerator;
import com.android.assetstudiolib.NotificationIconGenerator;
import com.android.assetstudiolib.TabIconGenerator;
import com.android.assetstudiolib.TextRenderUtil;
import com.android.assetstudiolib.Util;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.assetstudio.AssetType;
import com.android.ide.eclipse.adt.internal.assetstudio.CreateAssetSetWizardState;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageControl;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SwtUtils;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.utils.Pair;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;

public class ConfigureAssetSetPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private final CreateAssetSetWizardState mValues;
    private static final int PREVIEW_AREA_WIDTH = 144;
    private boolean mShown;
    private Composite mConfigurationArea;
    private Button mImageRadio;
    private Button mClipartRadio;
    private Button mTextRadio;
    private Button mPickImageButton;
    private Button mTrimCheckBox;
    private Slider mPaddingSlider;
    private Label mPercentLabel;
    private Button mCropRadio;
    private Button mCenterRadio;
    private Button mNoShapeRadio;
    private Button mSquareRadio;
    private Button mCircleButton;
    private Button mBgButton;
    private Button mFgButton;
    private Composite mPreviewArea;
    private Button mFontButton;
    private Composite mForegroundArea;
    private Composite mImageForm;
    private Composite mClipartForm;
    private Composite mTextForm;
    private Text mImagePathText;
    private boolean mTimerPending;
    private RGB mBgColor;
    private RGB mFgColor;
    private Text mText;
    private static String sImagePath;
    private Button mChooseClipart;
    private Composite mClipartPreviewPanel;
    private Label mThemeLabel;
    private Composite mThemeComposite;
    private Button mHoloLightRadio;
    private Button mHoloDarkRadio;
    private Label mScalingLabel;
    private Composite mScalingComposite;
    private Label mShapeLabel;
    private Composite mShapeComposite;
    private Label mBgColorLabel;
    private Label mFgColorLabel;
    private boolean mIgnore;
    private CreateAssetSetWizardState.SourceType mShowingType;

    public ConfigureAssetSetPage(CreateAssetSetWizardState values) {
        super("configureAssetPage");
        this.mValues = values;
        this.setTitle("Configure Icon Set");
        this.setDescription("Configure the attributes of the icon set");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.marginWidth = 0;
        glContainer.horizontalSpacing = 0;
        glContainer.marginHeight = 0;
        glContainer.verticalSpacing = 0;
        container.setLayout((Layout)glContainer);
        ScrolledComposite configurationScrollArea = new ScrolledComposite(container, 512);
        configurationScrollArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        configurationScrollArea.setExpandHorizontal(true);
        configurationScrollArea.setExpandVertical(true);
        this.mConfigurationArea = new Composite((Composite)configurationScrollArea, 0);
        GridLayout glConfigurationArea = new GridLayout(3, false);
        glConfigurationArea.horizontalSpacing = 0;
        glConfigurationArea.marginRight = 15;
        glConfigurationArea.marginWidth = 0;
        glConfigurationArea.marginHeight = 0;
        this.mConfigurationArea.setLayout((Layout)glConfigurationArea);
        Label foregroundLabel = new Label(this.mConfigurationArea, 0);
        foregroundLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        foregroundLabel.setText("Foreground:");
        Composite foregroundComposite = new Composite(this.mConfigurationArea, 0);
        foregroundComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout glForegroundComposite = new GridLayout(5, false);
        glForegroundComposite.horizontalSpacing = 0;
        foregroundComposite.setLayout((Layout)glForegroundComposite);
        this.mImageRadio = new Button(foregroundComposite, 0x800002);
        this.mImageRadio.setSelection(false);
        this.mImageRadio.addSelectionListener((SelectionListener)this);
        this.mImageRadio.setText("Image");
        this.mClipartRadio = new Button(foregroundComposite, 0x800002);
        this.mClipartRadio.setText("Clipart");
        this.mClipartRadio.addSelectionListener((SelectionListener)this);
        this.mTextRadio = new Button(foregroundComposite, 0x800002);
        this.mTextRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.mTextRadio.setText("Text");
        this.mTextRadio.addSelectionListener((SelectionListener)this);
        new Label(this.mConfigurationArea, 0);
        this.mForegroundArea = new Composite(this.mConfigurationArea, 0);
        this.mForegroundArea.setLayout((Layout)new StackLayout());
        this.mForegroundArea.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.mImageForm = new Composite(this.mForegroundArea, 0);
        this.mImageForm.setLayout((Layout)new GridLayout(3, false));
        Label fileLabel = new Label(this.mImageForm, 0);
        fileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        fileLabel.setText("Image File:");
        this.mImagePathText = new Text(this.mImageForm, 2048);
        GridData pathLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        pathLayoutData.widthHint = 200;
        this.mImagePathText.setLayoutData((Object)pathLayoutData);
        this.mImagePathText.addSelectionListener((SelectionListener)this);
        this.mImagePathText.addModifyListener((ModifyListener)this);
        this.mPickImageButton = new Button(this.mImageForm, 0x800000);
        this.mPickImageButton.setText("Browse...");
        this.mPickImageButton.addSelectionListener((SelectionListener)this);
        this.mClipartForm = new Composite(this.mForegroundArea, 0);
        this.mClipartForm.setLayout((Layout)new GridLayout(2, false));
        this.mChooseClipart = new Button(this.mClipartForm, 0x800000);
        this.mChooseClipart.setText("Choose...");
        this.mChooseClipart.addSelectionListener((SelectionListener)this);
        this.mClipartPreviewPanel = new Composite(this.mClipartForm, 0);
        RowLayout rlClipartPreviewPanel = new RowLayout(256);
        rlClipartPreviewPanel.marginBottom = 0;
        rlClipartPreviewPanel.marginTop = 0;
        rlClipartPreviewPanel.center = true;
        this.mClipartPreviewPanel.setLayout((Layout)rlClipartPreviewPanel);
        this.mClipartPreviewPanel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mTextForm = new Composite(this.mForegroundArea, 0);
        this.mTextForm.setLayout((Layout)new GridLayout(2, false));
        Label textLabel = new Label(this.mTextForm, 0);
        textLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        textLabel.setText("Text:");
        this.mText = new Text(this.mTextForm, 2048);
        this.mText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mText.addModifyListener((ModifyListener)this);
        Label fontLabel = new Label(this.mTextForm, 0);
        fontLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        fontLabel.setText("Font:");
        this.mFontButton = new Button(this.mTextForm, 0x800000);
        this.mFontButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.mFontButton.addSelectionListener((SelectionListener)this);
        this.mFontButton.setText("Choose Font...");
        new Label(this.mConfigurationArea, 0);
        this.mTrimCheckBox = new Button(this.mConfigurationArea, 32);
        this.mTrimCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mTrimCheckBox.setSelection(false);
        this.mTrimCheckBox.setText("Trim Surrounding Blank Space");
        this.mTrimCheckBox.addSelectionListener((SelectionListener)this);
        new Label(this.mConfigurationArea, 0);
        Label paddingLabel = new Label(this.mConfigurationArea, 0);
        paddingLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        paddingLabel.setText("Additional Padding:");
        new Label(this.mConfigurationArea, 0);
        this.mPaddingSlider = new Slider(this.mConfigurationArea, 0);
        this.mPaddingSlider.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mPaddingSlider.addSelectionListener((SelectionListener)this);
        this.mPercentLabel = new Label(this.mConfigurationArea, 0);
        this.mPercentLabel.setText("  15%");
        this.mScalingLabel = new Label(this.mConfigurationArea, 0);
        this.mScalingLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mScalingLabel.setText("Foreground Scaling:");
        this.mScalingComposite = new Composite(this.mConfigurationArea, 0);
        this.mScalingComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout gl_mScalingComposite = new GridLayout(5, false);
        gl_mScalingComposite.horizontalSpacing = 0;
        this.mScalingComposite.setLayout((Layout)gl_mScalingComposite);
        this.mCropRadio = new Button(this.mScalingComposite, 0x800002);
        this.mCropRadio.setSelection(true);
        this.mCropRadio.setText("Crop");
        this.mCropRadio.addSelectionListener((SelectionListener)this);
        this.mCenterRadio = new Button(this.mScalingComposite, 0x800002);
        this.mCenterRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mCenterRadio.setText("Center");
        this.mCenterRadio.addSelectionListener((SelectionListener)this);
        this.mShapeLabel = new Label(this.mConfigurationArea, 0);
        this.mShapeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mShapeLabel.setText("Shape");
        this.mShapeComposite = new Composite(this.mConfigurationArea, 0);
        this.mShapeComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout gl_mShapeComposite = new GridLayout(6, false);
        gl_mShapeComposite.horizontalSpacing = 0;
        this.mShapeComposite.setLayout((Layout)gl_mShapeComposite);
        this.mNoShapeRadio = new Button(this.mShapeComposite, 0x800002);
        this.mNoShapeRadio.setText("None");
        this.mNoShapeRadio.addSelectionListener((SelectionListener)this);
        this.mSquareRadio = new Button(this.mShapeComposite, 0x800002);
        this.mSquareRadio.setSelection(true);
        this.mSquareRadio.setText("Square");
        this.mSquareRadio.addSelectionListener((SelectionListener)this);
        this.mCircleButton = new Button(this.mShapeComposite, 0x800002);
        this.mCircleButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mCircleButton.setText("Circle");
        this.mCircleButton.addSelectionListener((SelectionListener)this);
        this.mThemeLabel = new Label(this.mConfigurationArea, 0);
        this.mThemeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mThemeLabel.setText("Theme");
        this.mThemeComposite = new Composite(this.mConfigurationArea, 0);
        this.mThemeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gl_mThemeComposite = new GridLayout(2, false);
        gl_mThemeComposite.horizontalSpacing = 0;
        this.mThemeComposite.setLayout((Layout)gl_mThemeComposite);
        this.mHoloLightRadio = new Button(this.mThemeComposite, 0x800002);
        this.mHoloLightRadio.setText("Holo Light");
        this.mHoloLightRadio.setSelection(true);
        this.mHoloLightRadio.addSelectionListener((SelectionListener)this);
        this.mHoloDarkRadio = new Button(this.mThemeComposite, 0x800002);
        this.mHoloDarkRadio.setText("Holo Dark");
        this.mHoloDarkRadio.addSelectionListener((SelectionListener)this);
        this.mBgColorLabel = new Label(this.mConfigurationArea, 0);
        this.mBgColorLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mBgColorLabel.setText("Background Color:");
        this.mBgButton = new Button(this.mConfigurationArea, 0x800000);
        this.mBgButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mBgButton.addSelectionListener((SelectionListener)this);
        this.mBgButton.setAlignment(0x1000000);
        this.mFgColorLabel = new Label(this.mConfigurationArea, 0);
        this.mFgColorLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mFgColorLabel.setText("Foreground Color:");
        this.mFgButton = new Button(this.mConfigurationArea, 0x800000);
        this.mFgButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mFgButton.setAlignment(0x1000000);
        this.mFgButton.addSelectionListener((SelectionListener)this);
        configurationScrollArea.setContent((Control)this.mConfigurationArea);
        configurationScrollArea.setMinSize(this.mConfigurationArea.computeSize(-1, -1));
        Label previewLabel = new Label(container, 0);
        previewLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        previewLabel.setText("Preview:");
        this.mPreviewArea = new Composite(container, 2048);
        RowLayout rlPreviewAreaPreviewArea = new RowLayout(256);
        rlPreviewAreaPreviewArea.wrap = true;
        rlPreviewAreaPreviewArea.pack = true;
        rlPreviewAreaPreviewArea.center = true;
        rlPreviewAreaPreviewArea.spacing = 0;
        rlPreviewAreaPreviewArea.marginBottom = 0;
        rlPreviewAreaPreviewArea.marginTop = 0;
        rlPreviewAreaPreviewArea.marginRight = 0;
        rlPreviewAreaPreviewArea.marginLeft = 0;
        this.mPreviewArea.setLayout((Layout)rlPreviewAreaPreviewArea);
        GridData gdMPreviewArea = new GridData(4, 4, false, false, 1, 1);
        gdMPreviewArea.widthHint = 144;
        this.mPreviewArea.setLayoutData((Object)gdMPreviewArea);
        Display display = parent.getDisplay();
        this.updateColor(display, this.mValues.background, true);
        this.updateColor(display, this.mValues.foreground, false);
        this.setSourceType(this.mValues.sourceType);
        new Label(this.mConfigurationArea, 0);
        new Label(this.mConfigurationArea, 0);
        new Label(this.mConfigurationArea, 0);
        this.validatePage();
    }

    void configureAssetType(AssetType type) {
        if (this.mValues.sourceType != this.mShowingType) {
            this.mShowingType = this.mValues.sourceType;
            ConfigureAssetSetPage.showGroup(type.needsForegroundScaling(), (Control)this.mScalingLabel, (Control)this.mScalingComposite);
            ConfigureAssetSetPage.showGroup(type.needsShape(), (Control)this.mShapeLabel, (Control)this.mShapeComposite);
            ConfigureAssetSetPage.showGroup(type.needsTheme(), (Control)this.mThemeLabel, (Control)this.mThemeComposite);
            ConfigureAssetSetPage.showGroup(type.needsColors(), (Control)this.mBgColorLabel, (Control)this.mBgButton);
            ConfigureAssetSetPage.showGroup(type.needsColors() && this.mValues.sourceType != CreateAssetSetWizardState.SourceType.IMAGE, (Control)this.mFgColorLabel, (Control)this.mFgButton);
            Composite parent = this.mScalingLabel.getParent();
            parent.pack();
            parent.layout();
        }
    }

    private static void showGroup(boolean show, Control control1, Control control2) {
        ConfigureAssetSetPage.showControl(show, control1);
        ConfigureAssetSetPage.showControl(show, control2);
    }

    private static void showControl(boolean show, Control control) {
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            GridData gridData = (GridData)data;
            gridData.exclude = !show;
        }
        control.setVisible(show);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IResource icon;
            IProject project;
            this.mShown = true;
            Control[] controlArray = this.mPreviewArea.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            this.mPreviewArea.layout(true);
            AssetType type = this.mValues.type;
            assert (type != null);
            this.configureAssetType(type);
            if (this.mValues.imagePath != null) {
                sImagePath = this.mValues.imagePath.getPath();
            }
            if (sImagePath == null && (project = this.mValues.project) != null && (icon = project.findMember("res/drawable-hdpi/icon.png")) != null) {
                IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
                IPath workspacePath = workspace.getLocation();
                sImagePath = workspacePath.append(icon.getFullPath()).toOSString();
            }
            if (sImagePath != null) {
                this.mValues.imagePath = new File(sImagePath);
                this.mImagePathText.setText(sImagePath);
            }
            try {
                this.mIgnore = true;
                this.mTrimCheckBox.setSelection(this.mValues.trim);
                this.mPaddingSlider.setSelection(this.mValues.padding + 10);
                this.mPercentLabel.setText(String.valueOf(Integer.toString(this.mValues.padding)) + '%');
                if (this.mValues.imagePath != null) {
                    this.mImagePathText.setText(this.mValues.imagePath.getPath());
                }
                if (this.mValues.text != null) {
                    this.mText.setText(this.mValues.text);
                }
                this.setSourceType(this.mValues.sourceType);
                if (this.mValues.shape == GraphicGenerator.Shape.NONE && this.mValues.type == AssetType.NOTIFICATION) {
                    this.mValues.shape = GraphicGenerator.Shape.SQUARE;
                }
                this.setShape(this.mValues.shape);
                this.mNoShapeRadio.setEnabled(this.mValues.type != AssetType.NOTIFICATION);
                if (this.mValues.sourceType == CreateAssetSetWizardState.SourceType.CLIPART && this.mValues.clipartName != null) {
                    this.updateClipartPreview();
                }
                Display display = this.mPreviewArea.getDisplay();
                this.updateColor(display, this.mValues.background, true);
                this.updateColor(display, this.mValues.foreground, false);
                this.updateTrimOptions();
            }
            finally {
                this.mIgnore = false;
            }
            this.validatePage();
            this.requestUpdatePreview(true);
            if (this.mTextRadio.getSelection()) {
                this.mText.setFocus();
            }
        }
    }

    private void setSourceType(CreateAssetSetWizardState.SourceType sourceType) {
        if (sourceType == CreateAssetSetWizardState.SourceType.IMAGE) {
            this.chooseForegroundTab(this.mImageRadio, this.mImageForm);
        } else if (sourceType == CreateAssetSetWizardState.SourceType.CLIPART) {
            this.chooseForegroundTab(this.mClipartRadio, this.mClipartForm);
            this.mChooseClipart.setFocus();
        } else if (sourceType == CreateAssetSetWizardState.SourceType.TEXT) {
            this.updateFontLabel();
            this.chooseForegroundTab(this.mTextRadio, this.mTextForm);
            this.mText.setFocus();
        }
    }

    private void updateTrimOptions() {
        if (this.mValues.sourceType == CreateAssetSetWizardState.SourceType.CLIPART && this.mValues.type == AssetType.ACTIONBAR) {
            this.mTrimCheckBox.setEnabled(false);
            this.mPaddingSlider.setEnabled(false);
            this.mValues.trim = false;
        } else if (!this.mTrimCheckBox.isEnabled()) {
            this.mTrimCheckBox.setEnabled(true);
            this.mPaddingSlider.setEnabled(true);
        }
    }

    private boolean validatePage() {
        String error = null;
        if (this.mImageRadio.getSelection()) {
            String path;
            String string = path = this.mValues.imagePath != null ? this.mValues.imagePath.getPath() : null;
            if (path == null || path.length() == 0) {
                error = "Select an image";
            } else if (!path.equals("launcher_icon")) {
                if (!new File(path).exists()) {
                    error = String.format("%1$s does not exist", path);
                } else {
                    sImagePath = path;
                }
            }
        } else if (this.mTextRadio.getSelection()) {
            if (this.mValues.text.length() == 0) {
                error = "Enter text";
            }
        } else {
            assert (this.mClipartRadio.getSelection());
            if (this.mValues.clipartName == null) {
                error = "Select clip art";
            }
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        return error == null;
    }

    public boolean isPageComplete() {
        return this.mShown;
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        if (e.getSource() == this.mImagePathText) {
            this.mValues.imagePath = new File(this.mImagePathText.getText().trim());
            this.requestUpdatePreview(false);
        } else if (e.getSource() == this.mText) {
            this.mValues.text = this.mText.getText().trim();
            this.requestUpdatePreview(false);
        }
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        RGB rgb;
        ColorDialog dlg;
        Object dialog;
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        boolean updateQuickly = true;
        if (source == this.mImageRadio) {
            this.mValues.sourceType = CreateAssetSetWizardState.SourceType.IMAGE;
            this.chooseForegroundTab((Button)source, this.mImageForm);
            this.configureAssetType(this.mValues.type);
            this.updateTrimOptions();
        } else if (source == this.mClipartRadio) {
            this.mValues.sourceType = CreateAssetSetWizardState.SourceType.CLIPART;
            this.chooseForegroundTab((Button)source, this.mClipartForm);
            this.configureAssetType(this.mValues.type);
            this.updateTrimOptions();
        } else if (source == this.mTextRadio) {
            this.mValues.sourceType = CreateAssetSetWizardState.SourceType.TEXT;
            this.updateFontLabel();
            this.chooseForegroundTab((Button)source, this.mTextForm);
            this.configureAssetType(this.mValues.type);
            this.mText.setFocus();
            this.updateTrimOptions();
        }
        if (source == this.mPickImageButton) {
            String file;
            dialog = new FileDialog(this.mPickImageButton.getShell(), 4096);
            String curLocation = this.mImagePathText.getText().trim();
            if (!curLocation.isEmpty()) {
                dialog.setFilterPath(curLocation);
            }
            if ((file = dialog.open()) != null) {
                this.mValues.imagePath = new File(file);
                this.mImagePathText.setText(file);
            }
        }
        if (source == this.mCropRadio) {
            this.mCropRadio.setSelection(true);
            this.mCenterRadio.setSelection(false);
            this.mValues.crop = true;
        } else if (source == this.mCenterRadio) {
            this.mCenterRadio.setSelection(true);
            this.mCropRadio.setSelection(false);
            this.mValues.crop = false;
        }
        if (source == this.mSquareRadio) {
            this.mValues.shape = GraphicGenerator.Shape.SQUARE;
            this.setShape(this.mValues.shape);
        } else if (source == this.mCircleButton) {
            this.mValues.shape = GraphicGenerator.Shape.CIRCLE;
            this.setShape(this.mValues.shape);
        } else if (source == this.mNoShapeRadio) {
            this.mValues.shape = GraphicGenerator.Shape.NONE;
            this.setShape(this.mValues.shape);
        }
        if (source == this.mTrimCheckBox) {
            this.mValues.trim = this.mTrimCheckBox.getSelection();
        }
        if (source == this.mHoloDarkRadio) {
            this.mHoloDarkRadio.setSelection(true);
            this.mHoloLightRadio.setSelection(false);
            this.mValues.holoDark = true;
        } else if (source == this.mHoloLightRadio) {
            this.mHoloLightRadio.setSelection(true);
            this.mHoloDarkRadio.setSelection(false);
            this.mValues.holoDark = false;
        }
        if (source == this.mChooseClipart) {
            dialog = new MessageDialog(this.mChooseClipart.getShell(), "Choose Clip Art", null, "Choose Clip Art Image:", 0, new String[]{"Close"}, 0){

                protected Control createCustomArea(Composite parent) {
                    Composite outer = new Composite(parent, 0);
                    GridLayout gridLayout = new GridLayout();
                    outer.setLayout((Layout)gridLayout);
                    Composite chooserForm = new Composite(outer, 0);
                    GridData gd = new GridData();
                    gd.grabExcessVerticalSpace = true;
                    gd.widthHint = 450;
                    chooserForm.setLayoutData((Object)gd);
                    RowLayout clipartFormLayout = new RowLayout(256);
                    clipartFormLayout.center = true;
                    clipartFormLayout.wrap = true;
                    chooserForm.setLayout((Layout)clipartFormLayout);
                    MouseAdapter clickListener = new MouseAdapter(){

                        public void mouseDown(MouseEvent event) {
                            if (event.widget instanceof ImageControl) {
                                ImageControl image = (ImageControl)event.widget;
                                ((ConfigureAssetSetPage)(this).ConfigureAssetSetPage.this).mValues.clipartName = (String)image.getData();
                                this.close();
                                ConfigureAssetSetPage.this.updateClipartPreview();
                                ConfigureAssetSetPage.this.updatePreview();
                            }
                        }
                    };
                    Display display = chooserForm.getDisplay();
                    org.eclipse.swt.graphics.Color hoverColor = display.getSystemColor(3);
                    Iterator clipartImages = GraphicGenerator.getClipartNames();
                    while (clipartImages.hasNext()) {
                        String name = (String)clipartImages.next();
                        try {
                            BufferedImage icon = GraphicGenerator.getClipartIcon((String)name);
                            if (icon == null) continue;
                            Image swtImage = SwtUtils.convertToSwt((Device)display, icon, true, -1);
                            ImageControl img = new ImageControl(chooserForm, 0, swtImage);
                            img.setData(name);
                            img.setHoverColor(hoverColor);
                            img.addMouseListener((MouseListener)clickListener);
                        }
                        catch (IOException e1) {
                            AdtPlugin.log(e1, null, new Object[0]);
                        }
                    }
                    outer.pack();
                    outer.layout();
                    return outer;
                }
            };
            dialog.open();
        }
        if (source == this.mBgButton) {
            dlg = new ColorDialog(this.mBgButton.getShell());
            dlg.setRGB(this.mBgColor);
            dlg.setText("Choose a new Background Color");
            rgb = dlg.open();
            if (rgb != null) {
                this.mValues.background = rgb;
                this.updateColor(this.mBgButton.getDisplay(), rgb, true);
            }
        } else if (source == this.mFgButton) {
            dlg = new ColorDialog(this.mFgButton.getShell());
            dlg.setRGB(this.mFgColor);
            dlg.setText("Choose a new Foreground Color");
            rgb = dlg.open();
            if (rgb != null) {
                this.mValues.foreground = rgb;
                this.updateColor(this.mFgButton.getDisplay(), rgb, false);
            }
        }
        if (source == this.mFontButton) {
            dialog = new FontDialog(this.mFontButton.getShell());
            FontData[] fontList = this.mFontButton.getData() == null ? this.mFontButton.getDisplay().getFontList(this.mValues.getTextFont().getFontName(), true) : this.mFontButton.getFont().getFontData();
            dialog.setFontList(fontList);
            FontData data = dialog.open();
            if (data != null) {
                Font font = new Font((Device)this.mFontButton.getDisplay(), dialog.getFontList());
                this.mFontButton.setFont(font);
                this.mFontButton.setData((Object)font);
                int fontHeight = new TextRenderUtil.Options().fontSize;
                FontData fontData = font.getFontData()[0];
                int awtStyle = 0;
                int swtStyle = fontData.getStyle();
                if ((swtStyle & 2) != 0) {
                    awtStyle |= 2;
                }
                if ((swtStyle & 1) != 0) {
                    awtStyle = 1;
                }
                this.mValues.setTextFont(new java.awt.Font(fontData.getName(), awtStyle, fontHeight));
                this.updateFontLabel();
                this.mFontButton.getParent().pack();
            }
        }
        if (source == this.mPaddingSlider) {
            this.mValues.padding = this.getPadding();
            this.mPercentLabel.setText(String.valueOf(Integer.toString(this.getPadding())) + '%');
            updateQuickly = false;
        }
        this.requestUpdatePreview(updateQuickly);
    }

    private void updateClipartPreview() {
        Control[] controlArray = this.mClipartPreviewPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (this.mClipartPreviewPanel.getChildren().length == 0) {
            try {
                BufferedImage icon = GraphicGenerator.getClipartIcon((String)this.mValues.clipartName);
                if (icon != null) {
                    Display display = this.mClipartForm.getDisplay();
                    Image swtImage = SwtUtils.convertToSwt((Device)display, icon, true, -1);
                    new ImageControl(this.mClipartPreviewPanel, 0, swtImage);
                }
            }
            catch (IOException e1) {
                AdtPlugin.log(e1, null, new Object[0]);
            }
            this.mClipartPreviewPanel.pack();
            this.mClipartPreviewPanel.layout();
        }
    }

    private void setShape(GraphicGenerator.Shape shape) {
        if (shape == GraphicGenerator.Shape.SQUARE) {
            this.mSquareRadio.setSelection(true);
            this.mCircleButton.setSelection(false);
            this.mNoShapeRadio.setSelection(false);
        } else if (shape == GraphicGenerator.Shape.CIRCLE) {
            this.mCircleButton.setSelection(true);
            this.mSquareRadio.setSelection(false);
            this.mNoShapeRadio.setSelection(false);
        } else if (shape == GraphicGenerator.Shape.NONE) {
            this.mNoShapeRadio.setSelection(true);
            this.mCircleButton.setSelection(false);
            this.mSquareRadio.setSelection(false);
        } else assert (false) : shape;
    }

    private void updateFontLabel() {
        this.mFontButton.setText(this.mValues.getTextFont().getFontName());
    }

    private int getPadding() {
        return this.mPaddingSlider.getSelection() - 10;
    }

    private void chooseForegroundTab(Button newButton, Composite newArea) {
        if (newButton.getSelection()) {
            this.mImageRadio.setSelection(false);
            this.mClipartRadio.setSelection(false);
            this.mTextRadio.setSelection(false);
            newButton.setSelection(true);
            StackLayout stackLayout = (StackLayout)this.mForegroundArea.getLayout();
            stackLayout.topControl = newArea;
            this.mForegroundArea.layout();
        } else {
            newButton.setSelection(true);
        }
    }

    private void requestUpdatePreview(boolean quickly) {
        if (this.mTimerPending) {
            return;
        }
        this.mTimerPending = true;
        Runnable timer = new Runnable(){

            @Override
            public void run() {
                ConfigureAssetSetPage.this.mTimerPending = false;
                ConfigureAssetSetPage.this.updatePreview();
            }
        };
        this.mPreviewArea.getDisplay().timerExec(quickly ? 10 : 250, timer);
    }

    private void updatePreview() {
        Display display = this.mPreviewArea.getDisplay();
        Control[] controlArray = this.mPreviewArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (!this.validatePage()) {
            return;
        }
        Map<String, Map<String, BufferedImage>> map = ConfigureAssetSetPage.generateImages(this.mValues, true, this);
        for (Map.Entry<String, Map<String, BufferedImage>> categoryEntry : map.entrySet()) {
            String category = categoryEntry.getKey();
            if (category.length() > 0) {
                Label nameLabel = new Label(this.mPreviewArea, 0);
                nameLabel.setText(String.format("%1$s:", category));
                RowData rowData = new RowData();
                nameLabel.setLayoutData((Object)rowData);
                rowData.width = 144;
            }
            Map<String, BufferedImage> images = categoryEntry.getValue();
            for (Map.Entry<String, BufferedImage> entry : images.entrySet()) {
                BufferedImage image = entry.getValue();
                Image swtImage = SwtUtils.convertToSwt((Device)display, image, true, -1);
                if (swtImage == null) continue;
                new ImageControl(this.mPreviewArea, 0, swtImage);
            }
        }
        this.mPreviewArea.layout(true);
    }

    public static Map<String, Map<String, BufferedImage>> generateImages(@NonNull CreateAssetSetWizardState mValues, boolean previewOnly, @Nullable WizardPage page) {
        LinkedHashMap<String, Map<String, BufferedImage>> categoryMap = new LinkedHashMap<String, Map<String, BufferedImage>>();
        AssetType type = mValues.type;
        boolean trim = mValues.trim;
        BufferedImage sourceImage = null;
        switch (mValues.sourceType) {
            case IMAGE: {
                File file;
                String path;
                String string = path = mValues.imagePath != null ? mValues.imagePath.getPath() : "";
                if (path.length() == 0) {
                    if (page != null) {
                        page.setErrorMessage("Enter a filename");
                    }
                    return Collections.emptyMap();
                }
                if (!path.equals("launcher_icon") && !(file = new File(path)).isFile()) {
                    if (page != null) {
                        page.setErrorMessage(String.format("%1$s does not exist", file.getPath()));
                    }
                    return Collections.emptyMap();
                }
                if (page != null) {
                    page.setErrorMessage(null);
                }
                try {
                    sourceImage = mValues.getCachedImage(path, false);
                    if (sourceImage == null) break;
                    if (trim) {
                        sourceImage = ImageUtils.cropBlank(sourceImage, null, 2);
                    }
                    if (mValues.padding == 0) break;
                    sourceImage = Util.paddedImage((BufferedImage)sourceImage, (int)mValues.padding);
                }
                catch (IOException ioe) {
                    if (page == null) break;
                    page.setErrorMessage(ioe.getLocalizedMessage());
                }
                break;
            }
            case CLIPART: {
                int color;
                try {
                    int padding;
                    boolean isActionBar;
                    sourceImage = GraphicGenerator.getClipartImage((String)mValues.clipartName);
                    boolean bl = isActionBar = mValues.type == AssetType.ACTIONBAR;
                    if (trim && !isActionBar) {
                        sourceImage = ImageUtils.cropBlank(sourceImage, null, 2);
                    }
                    if (type.needsColors()) {
                        RGB fg = mValues.foreground;
                        color = 0xFF000000 | fg.red << 16 | fg.green << 8 | fg.blue;
                        Color paint = new Color(color);
                        sourceImage = Util.filledImage((BufferedImage)sourceImage, (Paint)paint);
                    }
                    if ((padding = mValues.padding) == 0 || isActionBar) break;
                    sourceImage = Util.paddedImage((BufferedImage)sourceImage, (int)padding);
                    break;
                }
                catch (IOException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                    return categoryMap;
                }
            }
            case TEXT: {
                int padding;
                int color;
                String text = mValues.text;
                TextRenderUtil.Options options = new TextRenderUtil.Options();
                options.font = mValues.getTextFont();
                if (type.needsColors()) {
                    RGB fg = mValues.foreground;
                    color = 0xFF000000 | fg.red << 16 | fg.green << 8 | fg.blue;
                } else {
                    color = -1;
                }
                options.foregroundColor = color;
                sourceImage = TextRenderUtil.renderTextImage((String)text, (int)mValues.padding, (TextRenderUtil.Options)options);
                if (trim) {
                    sourceImage = ImageUtils.cropBlank(sourceImage, null, 2);
                }
                if ((padding = mValues.padding) == 0) break;
                sourceImage = Util.paddedImage((BufferedImage)sourceImage, (int)padding);
            }
        }
        LauncherIconGenerator generator = null;
        GraphicGenerator.Options options = null;
        switch (type) {
            case LAUNCHER: {
                int color;
                generator = new LauncherIconGenerator();
                LauncherIconGenerator.LauncherOptions launcherOptions = new LauncherIconGenerator.LauncherOptions();
                launcherOptions.shape = mValues.shape;
                launcherOptions.crop = mValues.crop;
                launcherOptions.style = GraphicGenerator.Style.SIMPLE;
                RGB bg = mValues.background;
                launcherOptions.backgroundColor = color = bg.red << 16 | bg.green << 8 | bg.blue;
                launcherOptions.isWebGraphic = !previewOnly;
                options = launcherOptions;
                break;
            }
            case MENU: {
                generator = new MenuIconGenerator();
                options = new GraphicGenerator.Options();
                break;
            }
            case ACTIONBAR: {
                generator = new ActionBarIconGenerator();
                ActionBarIconGenerator.ActionBarOptions actionBarOptions = new ActionBarIconGenerator.ActionBarOptions();
                actionBarOptions.theme = mValues.holoDark ? ActionBarIconGenerator.Theme.HOLO_DARK : ActionBarIconGenerator.Theme.HOLO_LIGHT;
                actionBarOptions.sourceIsClipart = mValues.sourceType == CreateAssetSetWizardState.SourceType.CLIPART;
                options = actionBarOptions;
                break;
            }
            case NOTIFICATION: {
                generator = new NotificationIconGenerator();
                options = new NotificationIconGenerator.NotificationOptions();
                break;
            }
            case TAB: {
                generator = new TabIconGenerator();
                options = new TabIconGenerator.TabOptions();
                break;
            }
            default: {
                AdtPlugin.log(4, "Unsupported asset type: %1$s", new Object[]{type});
                return categoryMap;
            }
        }
        options.sourceImage = sourceImage;
        IProject project = mValues.project;
        if (mValues.minSdk != -1) {
            options.minSdk = mValues.minSdk;
        } else {
            Pair<Integer, Integer> v = ManifestInfo.computeSdkVersions(project);
            options.minSdk = (Integer)v.getFirst();
        }
        String baseName = mValues.outputName;
        generator.generate(null, categoryMap, (GraphicGeneratorContext)mValues, options, baseName);
        return categoryMap;
    }

    public static void generateIcons(IProject newProject, @NonNull CreateAssetSetWizardState values, boolean previewOnly, @Nullable WizardPage page) {
        Map<String, Map<String, BufferedImage>> categories = ConfigureAssetSetPage.generateImages(values, false, page);
        for (Map<String, BufferedImage> previews : categories.values()) {
            for (Map.Entry<String, BufferedImage> entry : previews.entrySet()) {
                String relativePath = entry.getKey();
                Path dest = new Path(relativePath);
                IFile file = newProject.getFile((IPath)dest);
                if (file.exists()) {
                    try {
                        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        AdtPlugin.log(e, null, new Object[0]);
                    }
                }
                AdtUtils.createWsParentDirectory(file.getParent());
                BufferedImage image = entry.getValue();
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "PNG", stream);
                    byte[] bytes = stream.toByteArray();
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    file.create((InputStream)is, true, null);
                }
                catch (IOException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
                try {
                    file.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
            }
        }
    }

    private void updateColor(Display display, RGB color, boolean isBackground) {
        BufferedImage coloredImage = ImageUtils.createColoredImage(60, 20, color);
        Image image = SwtUtils.convertToSwt((Device)display, coloredImage, false, -1);
        if (isBackground) {
            this.mBgColor = color;
            this.mBgButton.setImage(image);
        } else {
            this.mFgColor = color;
            this.mFgButton.setImage(image);
        }
    }
}

