/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.layout.relative;

import com.android.annotations.NonNull;
import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.SegmentType;
import com.android.ide.common.layout.relative.ConstraintPainter;
import com.android.ide.common.layout.relative.DependencyGraph;
import com.android.ide.common.layout.relative.GuidelineHandler;
import com.android.ide.common.layout.relative.Match;
import com.android.ide.common.layout.relative.MoveHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GuidelinePainter
implements IFeedbackPainter {
    public void paint(@NonNull IGraphics gc, @NonNull INode node, @NonNull DropFeedback feedback) {
        GuidelineHandler state = (GuidelineHandler)feedback.userData;
        for (INode dragged : state.mDraggedNodes) {
            gc.useStyle(DrawingStyle.DRAGGED);
            Rect bounds = dragged.getBounds();
            if (!bounds.isValid()) continue;
            gc.fillRect(bounds);
        }
        Set<INode> horizontalDeps = state.mHorizontalDeps;
        Set<INode> verticalDeps = state.mVerticalDeps;
        HashSet<INode> deps = new HashSet<INode>(horizontalDeps.size() + verticalDeps.size());
        deps.addAll(horizontalDeps);
        deps.addAll(verticalDeps);
        if (deps.size() > 0) {
            gc.useStyle(DrawingStyle.DEPENDENCY);
            for (INode n : deps) {
                if (state.mDraggedNodes.contains(n)) continue;
                Rect bounds = n.getBounds();
                gc.fillRect(bounds);
            }
        }
        if (state.mBounds != null) {
            if (state instanceof MoveHandler) {
                gc.useStyle(DrawingStyle.DROP_PREVIEW);
            } else if (state.haveSuggestions()) {
                gc.useStyle(DrawingStyle.RESIZE_PREVIEW);
            } else {
                gc.useStyle(DrawingStyle.RESIZE_FAIL);
            }
            gc.drawRect(state.mBounds);
            if (feedback.dragBaseline != -1) {
                int y = state.mBounds.y + feedback.dragBaseline;
                gc.drawLine(state.mBounds.x, y, state.mBounds.x2(), y);
            }
        }
        ArrayList<String> strings = new ArrayList<String>();
        this.showMatch(gc, state.mCurrentLeftMatch, state, strings, state.mLeftMargin, "layout_marginLeft");
        this.showMatch(gc, state.mCurrentRightMatch, state, strings, state.mRightMargin, "layout_marginRight");
        this.showMatch(gc, state.mCurrentTopMatch, state, strings, state.mTopMargin, "layout_marginTop");
        this.showMatch(gc, state.mCurrentBottomMatch, state, strings, state.mBottomMargin, "layout_marginBottom");
        if (strings.size() > 0) {
            StringBuilder sb = new StringBuilder(200);
            for (String s : strings) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(s);
            }
            feedback.tooltip = sb.toString();
            if (state.mCurrentLeftMatch != null) {
                feedback.tooltipX = SegmentType.RIGHT;
            } else if (state.mCurrentRightMatch != null) {
                feedback.tooltipX = SegmentType.LEFT;
            }
            if (state.mCurrentTopMatch != null) {
                feedback.tooltipY = SegmentType.BOTTOM;
            } else if (state.mCurrentBottomMatch != null) {
                feedback.tooltipY = SegmentType.TOP;
            }
        } else {
            feedback.tooltip = null;
        }
        if (state.mHorizontalCycle != null) {
            this.paintCycle(gc, state, state.mHorizontalCycle);
        }
        if (state.mVerticalCycle != null) {
            this.paintCycle(gc, state, state.mVerticalCycle);
        }
    }

    private void showMatch(IGraphics gc, Match m, GuidelineHandler state, List<String> strings, int margin, String marginAttribute) {
        if (m == null) {
            return;
        }
        ConstraintPainter.paintConstraint(gc, state.mBounds, m);
        String constraint = m.getConstraint(false);
        String description = constraint.replace("@+id/", "").replace("@id/", "");
        if (description.startsWith("layout_")) {
            description = description.substring("layout_".length());
        }
        if (margin > 0) {
            int dp = state.getRulesEngine().pxToDp(margin);
            description = String.format("%1$s, margin=%2$d dp", description, dp);
        }
        strings.add(description);
    }

    void paintCycle(IGraphics gc, GuidelineHandler state, List<DependencyGraph.Constraint> cycle) {
        gc.useStyle(DrawingStyle.CYCLE);
        assert (cycle.size() > 0);
        INode from = cycle.get((int)0).from.node;
        Rect fromBounds = from.getBounds();
        if (state.mDraggedNodes.contains(from)) {
            fromBounds = state.mBounds;
        }
        Point fromCenter = fromBounds.center();
        INode to = null;
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(fromCenter);
        for (DependencyGraph.Constraint constraint : cycle) {
            assert (constraint.from.node == from);
            to = constraint.to.node;
            assert (from != null && to != null);
            Point toCenter = to.getBounds().center();
            points.add(toCenter);
            boolean isDragged = state.mDraggedNodes.contains(to);
            if (isDragged) {
                toCenter = state.mBounds.center();
                points.add(toCenter);
            }
            from = to;
            fromCenter = toCenter;
        }
        points.add(fromCenter);
        points.add((Point)points.get(0));
        int i = 1;
        int n = points.size();
        while (i < n) {
            gc.drawLine((Point)points.get(i - 1), (Point)points.get(i));
            ++i;
        }
    }
}

