/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.layout;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.RuleAction;
import com.android.ide.common.api.SegmentType;
import com.android.ide.common.layout.BaseLayoutRule;
import com.android.ide.common.layout.GravityHelper;
import com.android.ide.common.layout.PropertyCallback;
import com.android.ide.common.layout.ResizeState;
import com.android.ide.common.layout.grid.GridDropHandler;
import com.android.ide.common.layout.grid.GridLayoutPainter;
import com.android.ide.common.layout.grid.GridModel;
import com.android.utils.Pair;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GridLayoutRule
extends BaseLayoutRule {
    public static final int GRID_SIZE = 16;
    public static final int SHORT_GAP_DP = 16;
    public static final int MARGIN_SIZE = 32;
    private static final int NEW_CELL_WIDTH = 10;
    public static final double MAX_CELL_DIFFERENCE = 1.2;
    private static final boolean CAN_DEBUG = "true".equals(System.getenv("ADT_DEBUG_GRIDLAYOUT"));
    private static final String ACTION_ADD_ROW = "_addrow";
    private static final String ACTION_REMOVE_ROW = "_removerow";
    private static final String ACTION_ADD_COL = "_addcol";
    private static final String ACTION_REMOVE_COL = "_removecol";
    private static final String ACTION_ORIENTATION = "_orientation";
    private static final String ACTION_SHOW_STRUCTURE = "_structure";
    private static final String ACTION_GRID_MODE = "_gridmode";
    private static final String ACTION_SNAP = "_snap";
    private static final String ACTION_DEBUG = "_debug";
    private static final URL ICON_HORIZONTAL = GridLayoutRule.class.getResource("hlinear.png");
    private static final URL ICON_VERTICAL = GridLayoutRule.class.getResource("vlinear.png");
    private static final URL ICON_ADD_ROW = GridLayoutRule.class.getResource("addrow.png");
    private static final URL ICON_REMOVE_ROW = GridLayoutRule.class.getResource("removerow.png");
    private static final URL ICON_ADD_COL = GridLayoutRule.class.getResource("addcol.png");
    private static final URL ICON_REMOVE_COL = GridLayoutRule.class.getResource("removecol.png");
    private static final URL ICON_SHOW_STRUCT = GridLayoutRule.class.getResource("showgrid.png");
    private static final URL ICON_GRID_MODE = GridLayoutRule.class.getResource("gridmode.png");
    private static final URL ICON_SNAP = GridLayoutRule.class.getResource("snap.png");
    public static boolean sDebugGridLayout = CAN_DEBUG;
    public static boolean sShowStructure = false;
    public static boolean sSnapToGrid = false;
    public static boolean sGridMode = true;

    @Override
    public void addLayoutActions(@NonNull List<RuleAction> actions, final @NonNull INode parentNode, final @NonNull List<? extends INode> children) {
        super.addLayoutActions(actions, parentNode, children);
        String namespace = this.getNamespace(parentNode);
        RuleAction.Choices orientationAction = RuleAction.createChoices((String)ACTION_ORIENTATION, (String)"Orientation", (IMenuCallback)new PropertyCallback(Collections.singletonList(parentNode), "Change LinearLayout Orientation", namespace, "orientation"), Arrays.asList("Set Horizontal Orientation", "Set Vertical Orientation"), Arrays.asList(ICON_HORIZONTAL, ICON_VERTICAL), Arrays.asList("horizontal", "vertical"), (String)this.getCurrentOrientation(parentNode), null, (int)-10, (boolean)false);
        orientationAction.setRadio(true);
        actions.add((RuleAction)orientationAction);
        if (children != null && children.size() > 0) {
            actions.add((RuleAction)RuleAction.createSeparator((int)35));
            actions.add(this.createMarginAction(parentNode, children));
            actions.add(this.createGravityAction(children, "layout_gravity"));
        }
        IMenuCallback actionCallback = new IMenuCallback(){

            public void action(final @NonNull RuleAction action, @NonNull List<? extends INode> selectedNodes, @Nullable String valueId, @Nullable Boolean newValue) {
                parentNode.editXml("Add/Remove Row/Column", new INodeHandler(){

                    public void handle(@NonNull INode n) {
                        String id = action.getId();
                        if (id.equals(GridLayoutRule.ACTION_SHOW_STRUCTURE)) {
                            sShowStructure = !sShowStructure;
                            (this).GridLayoutRule.this.mRulesEngine.redraw();
                            return;
                        }
                        if (id.equals(GridLayoutRule.ACTION_GRID_MODE)) {
                            sGridMode = !sGridMode;
                            (this).GridLayoutRule.this.mRulesEngine.redraw();
                            return;
                        }
                        if (id.equals(GridLayoutRule.ACTION_SNAP)) {
                            sSnapToGrid = !sSnapToGrid;
                            (this).GridLayoutRule.this.mRulesEngine.redraw();
                            return;
                        }
                        if (id.equals(GridLayoutRule.ACTION_DEBUG)) {
                            sDebugGridLayout = !sDebugGridLayout;
                            (this).GridLayoutRule.this.mRulesEngine.layout();
                            return;
                        }
                        GridModel grid = GridModel.get((this).GridLayoutRule.this.mRulesEngine, parentNode, null);
                        if (id.equals(GridLayoutRule.ACTION_ADD_ROW)) {
                            grid.addRow(children);
                        } else if (id.equals(GridLayoutRule.ACTION_REMOVE_ROW)) {
                            grid.removeRows(children);
                        } else if (id.equals(GridLayoutRule.ACTION_ADD_COL)) {
                            grid.addColumn(children);
                        } else if (id.equals(GridLayoutRule.ACTION_REMOVE_COL)) {
                            grid.removeColumns(children);
                        }
                    }
                });
            }
        };
        actions.add((RuleAction)RuleAction.createSeparator((int)142));
        actions.add((RuleAction)RuleAction.createToggle((String)ACTION_GRID_MODE, (String)"Grid Model Mode", (boolean)sGridMode, (IMenuCallback)actionCallback, (URL)ICON_GRID_MODE, (int)145, (boolean)false));
        if (sGridMode) {
            actions.add((RuleAction)RuleAction.createToggle((String)ACTION_SHOW_STRUCTURE, (String)"Show Structure", (boolean)sShowStructure, (IMenuCallback)actionCallback, (URL)ICON_SHOW_STRUCT, (int)147, (boolean)false));
            actions.add((RuleAction)RuleAction.createSeparator((int)150));
            actions.add(RuleAction.createAction((String)ACTION_ADD_COL, (String)"Add Column", (IMenuCallback)actionCallback, (URL)ICON_ADD_COL, (int)160, (boolean)false));
            actions.add(RuleAction.createAction((String)ACTION_ADD_ROW, (String)"Add Row", (IMenuCallback)actionCallback, (URL)ICON_ADD_ROW, (int)165, (boolean)false));
            if (children != null && children.size() > 0) {
                actions.add(RuleAction.createAction((String)ACTION_REMOVE_COL, (String)"Remove Column", (IMenuCallback)actionCallback, (URL)ICON_REMOVE_COL, (int)170, (boolean)false));
                actions.add(RuleAction.createAction((String)ACTION_REMOVE_ROW, (String)"Remove Row", (IMenuCallback)actionCallback, (URL)ICON_REMOVE_ROW, (int)175, (boolean)false));
            }
            actions.add((RuleAction)RuleAction.createSeparator((int)185));
        } else {
            actions.add((RuleAction)RuleAction.createToggle((String)ACTION_SHOW_STRUCTURE, (String)"Show Structure", (boolean)sShowStructure, (IMenuCallback)actionCallback, (URL)ICON_SHOW_STRUCT, (int)190, (boolean)false));
            actions.add((RuleAction)RuleAction.createToggle((String)ACTION_SNAP, (String)"Snap to Grid", (boolean)sSnapToGrid, (IMenuCallback)actionCallback, (URL)ICON_SNAP, (int)200, (boolean)false));
        }
        if (CAN_DEBUG) {
            actions.add((RuleAction)RuleAction.createToggle((String)ACTION_DEBUG, (String)"Debug", (boolean)sDebugGridLayout, (IMenuCallback)actionCallback, null, (int)210, (boolean)false));
        }
    }

    private String getCurrentOrientation(INode node) {
        String orientation = node.getStringAttr(this.getNamespace(node), "orientation");
        if (orientation == null || orientation.length() == 0) {
            orientation = "horizontal";
        }
        return orientation;
    }

    public DropFeedback onDropEnter(@NonNull INode targetNode, @Nullable Object targetView, @Nullable IDragElement[] elements) {
        GridDropHandler userData = new GridDropHandler(this, targetNode, targetView);
        IFeedbackPainter painter = GridLayoutPainter.createDropFeedbackPainter(this, elements);
        return new DropFeedback((Object)userData, painter);
    }

    public DropFeedback onDropMove(@NonNull INode targetNode, @NonNull IDragElement[] elements, @Nullable DropFeedback feedback, @NonNull Point p) {
        if (feedback == null) {
            return null;
        }
        feedback.requestPaint = true;
        GridDropHandler handler = (GridDropHandler)feedback.userData;
        handler.computeMatches(feedback, p);
        return feedback;
    }

    public void onDropped(@NonNull INode targetNode, @NonNull IDragElement[] elements, @Nullable DropFeedback feedback, @NonNull Point p) {
        if (feedback == null) {
            return;
        }
        Rect b = targetNode.getBounds();
        if (!b.isValid()) {
            return;
        }
        GridDropHandler dropHandler = (GridDropHandler)feedback.userData;
        if (dropHandler.getRowMatch() == null || dropHandler.getColumnMatch() == null) {
            return;
        }
        Map<String, Pair<String, String>> idMap = GridLayoutRule.getDropIdMap(targetNode, elements, feedback.isCopy || !feedback.sameCanvas);
        IDragElement[] iDragElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IDragElement element = iDragElementArray[n2];
            INode newChild = !sGridMode ? dropHandler.handleFreeFormDrop(targetNode, element) : dropHandler.handleGridModeDrop(targetNode, element);
            GridLayoutRule.addAttributes(newChild, element, idMap, DEFAULT_ATTR_FILTER);
            GridLayoutRule.addInnerElements(newChild, element, idMap);
            ++n2;
        }
    }

    public void onChildInserted(@NonNull INode node, @NonNull INode parent, @NonNull InsertType insertType) {
        if (insertType == InsertType.MOVE_WITHIN) {
            return;
        }
        if (GridModel.isSpace(node.getFqcn())) {
            return;
        }
        String fqcn = node.getFqcn();
        IViewMetadata metadata = this.mRulesEngine.getMetadata(fqcn);
        IViewMetadata.FillPreference fill = metadata.getFillPreference();
        String gravity = GridLayoutRule.computeDefaultGravity(fill);
        if (gravity != null) {
            node.setAttribute(this.getNamespace(parent), "layout_gravity", gravity);
        }
    }

    public String getNamespace(INode layout) {
        String namespace = "http://schemas.android.com/apk/res/android";
        String fqcn = layout.getFqcn();
        if (!fqcn.equals("GridLayout") && !fqcn.equals("android.widget.GridLayout")) {
            namespace = this.mRulesEngine.getAppNameSpace();
        }
        return namespace;
    }

    public static String computeDefaultGravity(IViewMetadata.FillPreference fill) {
        String horizontal = "left";
        String vertical = null;
        if (fill.fillHorizontally(true)) {
            horizontal = "fill_horizontal";
        }
        if (fill.fillVertically(true)) {
            vertical = "fill_vertical";
        }
        String gravity = horizontal == "fill_horizontal" && vertical == "fill_vertical" ? "fill" : (vertical != null ? String.valueOf(horizontal) + '|' + vertical : horizontal);
        return gravity;
    }

    public void onRemovingChildren(@NonNull List<INode> deleted, @NonNull INode parent, boolean moved) {
        super.onRemovingChildren(deleted, parent, moved);
        if (!sGridMode) {
            GridModel grid = GridModel.get(this.mRulesEngine, parent, null);
            grid.onDeleted(deleted);
        }
    }

    @Override
    protected void paintResizeFeedback(IGraphics gc, INode node, ResizeState state) {
        GridModel grid;
        if (!sGridMode) {
            grid = this.getGrid(state);
            GridLayoutPainter.paintResizeFeedback(gc, state.layout, grid);
        }
        if (GridLayoutRule.resizingWidget(state)) {
            super.paintResizeFeedback(gc, node, state);
        } else {
            grid = this.getGrid(state);
            int startColumn = grid.getColumn(state.bounds.x);
            int endColumn = grid.getColumn(state.bounds.x2());
            int columnSpan = endColumn - startColumn + 1;
            int startRow = grid.getRow(state.bounds.y);
            int endRow = grid.getRow(state.bounds.y2());
            int rowSpan = endRow - startRow + 1;
            Rect cellBounds = grid.getCellBounds(startRow, startColumn, rowSpan, columnSpan);
            gc.useStyle(DrawingStyle.RESIZE_PREVIEW);
            gc.drawRect(cellBounds);
        }
    }

    private GridModel getGrid(ResizeState resizeState) {
        GridModel grid = (GridModel)resizeState.clientData;
        if (grid == null) {
            grid = GridModel.get(this.mRulesEngine, resizeState.layout, resizeState.layoutView);
            resizeState.clientData = grid;
        }
        return grid;
    }

    @Override
    protected void setNewSizeBounds(ResizeState state, INode node, INode layout, Rect oldBounds, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        if (GridLayoutRule.resizingWidget(state)) {
            GridModel grid;
            GridModel.ViewData view;
            if ((state.fillWidth || state.fillHeight || state.wrapWidth || state.wrapHeight) && (view = (grid = this.getGrid(state)).getView(node)) != null) {
                String gravityString = grid.getGridAttribute(view.node, "layout_gravity");
                int gravity = GravityHelper.getGravity(gravityString, 0);
                if (view.column > 0 && verticalEdge != null && state.fillWidth) {
                    state.fillWidth = false;
                    state.wrapWidth = true;
                    gravity &= 0xFFFFFCF0;
                    gravity |= 8;
                } else if (verticalEdge != null && state.wrapWidth) {
                    gravity &= 0xFFFFFCF0;
                    gravity |= 1;
                }
                if (view.row > 0 && horizontalEdge != null && state.fillHeight) {
                    state.fillHeight = false;
                    state.wrapHeight = true;
                    gravity &= 0xFFFFFF0F;
                    gravity |= 0x20;
                } else if (horizontalEdge != null && state.wrapHeight) {
                    gravity &= 0xFFFFFF0F;
                    gravity |= 0x40;
                }
                gravityString = GravityHelper.getGravity(gravity);
                grid.setGridAttribute(view.node, "layout_gravity", gravityString);
            }
            super.setNewSizeBounds(state, node, layout, oldBounds, newBounds, horizontalEdge, verticalEdge);
        } else {
            Pair<Integer, Integer> spans = this.computeResizeSpans(state);
            int rowSpan = (Integer)spans.getFirst();
            int columnSpan = (Integer)spans.getSecond();
            GridModel grid = this.getGrid(state);
            grid.setColumnSpanAttribute(node, columnSpan);
            grid.setRowSpanAttribute(node, rowSpan);
            GridModel.ViewData view = grid.getView(node);
            if (view != null) {
                String gravityString = grid.getGridAttribute(view.node, "layout_gravity");
                int gravity = GravityHelper.getGravity(gravityString, 0);
                if (verticalEdge != null && columnSpan > 1) {
                    gravity &= 0xFFFFFCF0;
                    gravity |= 8;
                }
                if (horizontalEdge != null && rowSpan > 1) {
                    gravity &= 0xFFFFFF0F;
                    gravity |= 0x20;
                }
                gravityString = GravityHelper.getGravity(gravity);
                grid.setGridAttribute(view.node, "layout_gravity", gravityString);
            }
        }
    }

    @Override
    protected String getResizeUpdateMessage(ResizeState state, INode child, INode parent, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        Pair<Integer, Integer> spans = this.computeResizeSpans(state);
        if (GridLayoutRule.resizingWidget(state)) {
            String width = state.getWidthAttribute();
            String height = state.getHeightAttribute();
            String message = horizontalEdge == null ? width : (verticalEdge == null ? height : String.format("%s \u00d7 %s", width, height));
            return String.format("%s\n(Press Shift to resize row/column spans)", message);
        }
        int rowSpan = (Integer)spans.getFirst();
        int columnSpan = (Integer)spans.getSecond();
        return String.format("ColumnSpan=%d, RowSpan=%d\n(Release Shift to resize widget itself)", columnSpan, rowSpan);
    }

    private static boolean resizingWidget(ResizeState state) {
        return (state.modifierMask & 2) == 0;
    }

    private Pair<Integer, Integer> computeResizeSpans(ResizeState state) {
        GridModel grid = this.getGrid(state);
        int startColumn = grid.getColumn(state.bounds.x);
        int endColumn = grid.getColumn(state.bounds.x2());
        int columnSpan = endColumn - startColumn + 1;
        int startRow = grid.getRow(state.bounds.y);
        int endRow = grid.getRow(state.bounds.y2());
        int rowSpan = endRow - startRow + 1;
        return Pair.of((Object)rowSpan, (Object)columnSpan);
    }

    public int getNewCellSize() {
        return this.mRulesEngine.screenToLayout(5);
    }

    public void paintSelectionFeedback(@NonNull IGraphics graphics, @NonNull INode parentNode, @NonNull List<? extends INode> childNodes, @Nullable Object view) {
        super.paintSelectionFeedback(graphics, parentNode, childNodes, view);
        if (sShowStructure) {
            if (view != null && GridLayoutPainter.paintStructure(view, DrawingStyle.GUIDELINE_DASHED, parentNode, graphics)) {
                return;
            }
            GridLayoutPainter.paintStructure(DrawingStyle.GUIDELINE_DASHED, parentNode, graphics, GridModel.get(this.mRulesEngine, parentNode, view));
        } else if (sDebugGridLayout) {
            GridLayoutPainter.paintStructure(DrawingStyle.GRID, parentNode, graphics, GridModel.get(this.mRulesEngine, parentNode, view));
        }
    }

    @Override
    public void onPaste(@NonNull INode targetNode, @Nullable Object targetView, @NonNull IDragElement[] elements) {
        DropFeedback feedback = this.onDropEnter(targetNode, targetView, elements);
        if (feedback != null) {
            Rect b = targetNode.getBounds();
            if (!b.isValid()) {
                return;
            }
            Map<String, Pair<String, String>> idMap = GridLayoutRule.getDropIdMap(targetNode, elements, true);
            IDragElement[] iDragElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IDragElement element = iDragElementArray[n2];
                if (elements.length <= 1 || !"android.widget.Space".equals(element.getFqcn()) && !"android.support.v7.widget.Space".equals(element.getFqcn())) {
                    String fqcn = element.getFqcn();
                    INode newChild = targetNode.appendChild(fqcn);
                    GridLayoutRule.addAttributes(newChild, element, idMap, DEFAULT_ATTR_FILTER);
                    GridDropHandler handler = (GridDropHandler)feedback.userData;
                    GridModel grid = handler.getGrid();
                    grid.setGridAttribute(newChild, "layout_column", null);
                    grid.setGridAttribute(newChild, "layout_row", null);
                    GridLayoutRule.addInnerElements(newChild, element, idMap);
                }
                ++n2;
            }
        }
    }
}

