/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.signer;

import com.qihoo.signer.ZipUtil;
import com.qihoo.signer.keystore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class signApk {
    private ArrayList<String> signed_apk_paths;
    private static Shell sShell;
    private static CLabel processMessageLabel;
    private static Text content;
    private static String result_str;

    public signApk() {
        result_str = "";
        this.signed_apk_paths = new ArrayList();
    }

    public String getresult() {
        return result_str;
    }

    public ArrayList<String> getSignedApkPaths() {
        return this.signed_apk_paths;
    }

    public static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public void deleteDir(String filepath) {
        File file = new File(filepath);
        if (file.exists() && file.isDirectory()) {
            if (file.listFiles().length == 0) {
                file.delete();
            } else {
                File[] delFile = file.listFiles();
                int i = file.listFiles().length;
                int j = 0;
                while (j < i) {
                    if (delFile[j].isDirectory()) {
                        this.deleteDir(delFile[j].getAbsolutePath());
                    }
                    delFile[j].delete();
                    ++j;
                }
            }
        }
        file.delete();
    }

    public int signed_apks() throws Exception {
        for (String destfileName : keystore.listPath) {
            int index = destfileName.toString().lastIndexOf("_");
            String originalPath = destfileName.toString().substring(0, index);
            String originalFile = String.valueOf(originalPath) + ".apk";
            System.out.println(originalFile);
            ZipUtil zip = new ZipUtil();
            if (!zip.unZip(originalFile)) continue;
            String zipcmd = ".\\tools\\java\\bin\\7za.exe -tzip -ssc d " + originalFile.toString().replace(" ", "\" \"") + " " + "META-INF";
            Runtime rn = Runtime.getRuntime();
            Process proc = null;
            proc = rn.exec(zipcmd);
            InputStream stdin = proc.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            int exitVal = proc.waitFor();
            System.out.println(exitVal);
            String file = "";
            int _index = destfileName.toString().lastIndexOf("_");
            if (_index != -1) {
                file = destfileName.toString().substring(0, _index);
                file = String.valueOf(file) + ".apk";
            } else {
                file = destfileName;
            }
            if (exitVal == 0 || exitVal != 2) continue;
            result_str = String.valueOf(result_str) + file + "  \u8bfb\u53d6\u538b\u7f29\u6587\u4ef6\u5931\u8d25\uff0c\u53ef\u80fd\u88ab\u5176\u4f59\u8fdb\u7a0b\u5360\u7528\uff0c\u5173\u95ed\u540e\u91cd\u8bd5\r\n";
            return exitVal;
        }
        return 0;
    }

    public static boolean sign_one_apk(Shell shell, String destPath, final Button okButton, SelectionEvent e) {
        if (destPath != "" && keystore.listPath.size() == 1) {
            int index = keystore.listPath.get(0).toString().lastIndexOf("_");
            String originalFile = keystore.listPath.get(0).toString().substring(0, index);
            originalFile = String.valueOf(originalFile) + ".apk";
            int dotIndex = destPath.toString().lastIndexOf(".");
            String alignedname = destPath.toString().substring(0, dotIndex);
            String alignedFile = String.valueOf(alignedname) + "_Aligned.apk";
            String exeAlignFile = "cmd /c .\\tools\\java\\bin\\zipalign.exe -f -v 4 " + destPath.toString().replace(" ", "\" \"") + " " + alignedFile.replace(" ", "\" \"");
            String exeFile = "cmd /c .\\tools\\java\\bin\\jarsigner.exe -verbose -keystore " + keystore.KEYSTORE_PATH.replace(" ", "\" \"") + " -storepass " + "\"" + keystore.KEYSTORE_PWD + "\"" + " -keypass " + "\"" + keystore.KEY_PWD + "\"" + " -signedjar " + destPath.toString().replace(" ", "\" \"") + " " + originalFile.replace(" ", "\" \"") + " " + "\"" + keystore.KEY_ALIAS + "\"";
            signApk.execute(exeFile, exeAlignFile, destPath, shell, e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    okButton.setEnabled(true);
                }
            });
            return true;
        }
        return false;
    }

    public static void sign_multi_apks(Shell shell, String destPath, final Button okButton, SelectionEvent e, int i) {
        String destfileName = keystore.listPath.get(i);
        int index = destfileName.toString().lastIndexOf("_");
        String originalFile = destfileName.toString().substring(0, index);
        originalFile = String.valueOf(originalFile) + ".apk";
        int dotIndex = destfileName.toString().lastIndexOf(".");
        String alignedname = destfileName.toString().substring(0, dotIndex);
        String alignedFile = String.valueOf(alignedname) + "_Aligned.apk";
        String exeAlignFile = ".\\tools\\java\\bin\\zipalign.exe -f -v 4 " + destfileName.toString().replace(" ", "\" \"") + " " + alignedFile.replace(" ", "\" \"");
        String exeFile = ".\\tools\\java\\bin\\jarsigner.exe -verbose -keystore " + keystore.KEYSTORE_PATH.replace(" ", "\" \"") + " -storepass " + "\"" + keystore.KEYSTORE_PWD + "\"" + " -keypass " + "\"" + keystore.KEY_PWD + "\"" + " -signedjar " + destfileName.toString().replace(" ", "\" \"") + " " + originalFile.replace(" ", "\" \"") + " " + "\"" + keystore.KEY_ALIAS + "\"";
        signApk.execute(exeFile, exeAlignFile, destfileName, shell, e);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                okButton.setEnabled(true);
            }
        });
    }

    public static void sign_by_command(Shell shell, String destPath, Button okButton, SelectionEvent e) throws Exception {
        signApk.createSShell(shell, destPath, okButton, e);
    }

    public static void execute(String exeFile, String exeAlignFile, final String destfileName, Shell shell, SelectionEvent e) {
        Runtime rn = Runtime.getRuntime();
        Process proc = null;
        Process alignproc = null;
        try {
            proc = rn.exec(exeFile);
            InputStream stdin = proc.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            final int exitVal = proc.waitFor();
            alignproc = rn.exec(exeAlignFile);
            InputStream stdin02 = alignproc.getInputStream();
            InputStreamReader isr02 = new InputStreamReader(stdin02);
            BufferedReader br02 = new BufferedReader(isr02);
            String line02 = null;
            while ((line02 = br02.readLine()) != null) {
                System.out.println(line02);
            }
            final int exitVal02 = alignproc.waitFor();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String file;
                    int index = destfileName.toString().lastIndexOf("_");
                    if (index != -1) {
                        file = destfileName.toString().substring(0, index);
                        file = String.valueOf(file) + ".apk";
                    } else {
                        file = destfileName;
                    }
                    if (exitVal == 0 && exitVal02 == 0) {
                        signApk.deleteFile(destfileName);
                        result_str = String.valueOf(result_str) + file + " \u7b7e\u540d\u6210\u529f\r\n";
                        content.setText(result_str);
                    } else if (exitVal == 0 && exitVal02 != 0) {
                        result_str = String.valueOf(result_str) + file + " \u5bf9\u9f50\u5931\u8d25\r\n";
                        content.setText(result_str);
                    } else {
                        signApk.deleteFile(destfileName);
                        result_str = String.valueOf(result_str) + file + " \u7b7e\u540d\u5931\u8d25\uff08\u8bf7\u68c0\u67e5\u539f\u5305\u662f\u5426\u6b63\u5e38 \u6216\u8005 \u8f93\u5165\u7684\u7b2c\u4e8c\u4e2a\u5bc6\u7801\u662f\u5426\u6b63\u786e\uff09\r\n";
                        content.setText(result_str);
                    }
                }
            });
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void createSShell(final Shell shell, final String destPath, final Button okButton, final SelectionEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                sShell = new Shell(Display.getDefault(), 84064);
                sShell.setText("\u8fdb\u5ea6");
                sShell.setSize(300, 200);
                RowLayout layout = new RowLayout(512);
                layout.spacing = 0;
                layout.marginLeft = 0;
                layout.marginTop = 0;
                sShell.setLayout((Layout)layout);
                signApk.progress(Display.getDefault(), keystore.listPath.size(), shell, destPath, okButton, e);
                sShell.pack();
                sShell.open();
                while (!sShell.isDisposed()) {
                    if (Display.getDefault().readAndDispatch()) continue;
                    Display.getDefault().sleep();
                }
            }
        });
    }

    public static ProgressBar progress(Display display, final int max, final Shell shell, final String destPath, final Button okButton, final SelectionEvent e) {
        String processMessage = "processing......";
        CLabel message = new CLabel((Composite)sShell, 8);
        message.setText(processMessage);
        message.setLayoutData((Object)new RowData(330, 20));
        final ProgressBar progress = new ProgressBar((Composite)sShell, 65544);
        progress.setLayoutData((Object)new RowData(330, 20));
        processMessageLabel = new CLabel((Composite)sShell, 8);
        processMessageLabel.setLayoutData((Object)new RowData(330, 20));
        content = new Text((Composite)sShell, 840);
        content.setLayoutData((Object)new RowData(300, 100));
        progress.setMaximum(max);
        progress.setMinimum(0);
        final int Maximum = progress.getMaximum();
        final int Minimum = progress.getMinimum();
        Runnable Run = new Runnable(){

            @Override
            public void run() {
                int i = Minimum;
                while (i < Maximum) {
                    if (signApk.sign_one_apk(shell, destPath, okButton, e)) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (progress.isDisposed()) {
                                    return;
                                }
                                progress.setSelection(progress.getSelection() + 1);
                                String info = signApk.process(progress.getSelection());
                                processMessageLabel.setText(info);
                            }
                        });
                        return;
                    }
                    signApk.sign_multi_apks(shell, destPath, okButton, e, i);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (progress.isDisposed()) {
                                return;
                            }
                            progress.setSelection(progress.getSelection() + 1);
                            String info = signApk.process(progress.getSelection());
                            processMessageLabel.setText(info);
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            if (progress.getSelection() == max) {
                                final MessageBox messageBox = new MessageBox(sShell, 40);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        signApk.WriteMyFile();
                                        messageBox.setText("");
                                        messageBox.setMessage("Done!");
                                        e.doit = messageBox.open() == 64;
                                        signApk.close();
                                    }
                                });
                            }
                        }
                    });
                    ++i;
                }
            }
        };
        new Thread(Run).start();
        return progress;
    }

    public static void WriteMyFile() {
        try {
            FileWriter fw = new FileWriter(".\\log.txt");
            PrintWriter out = new PrintWriter(fw);
            out.print(result_str);
            out.close();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("\u5199\u5165\u9519\u8bef");
            e.printStackTrace();
        }
    }

    public static void close() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                sShell.close();
                sShell.dispose();
            }
        });
    }

    private static String process(int selection) {
        String str = " apk processed ";
        String str_int = Integer.toString(selection);
        str_int = String.valueOf(str_int) + str;
        return str_int;
    }
}

