/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.signer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int BUFFER = 1024;
    private static final String BASE_DIR = "";
    private static final String PATH = "/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unZip(String fileName) throws Exception {
        try {
            ZipEntry entry;
            ZipFile zipFile = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> emu = zipFile.entries();
            do {
                if (emu.hasMoreElements()) continue;
                zipFile.close();
                return false;
            } while (!(entry = emu.nextElement()).getName().startsWith("META-INF"));
            zipFile.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    public void unZip(String fileName, String filePath) throws Exception {
        ZipFile zipFile = new ZipFile(fileName);
        Enumeration<? extends ZipEntry> emu = zipFile.entries();
        while (emu.hasMoreElements()) {
            ZipEntry entry = emu.nextElement();
            if (entry.isDirectory()) {
                new File(String.valueOf(filePath) + PATH + entry.getName()).mkdirs();
                continue;
            }
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
            File file = new File(String.valueOf(filePath) + PATH + entry.getName());
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = bis.read(buf, 0, 1024)) != -1) {
                fos.write(buf, 0, len);
            }
            bos.flush();
            bos.close();
            bis.close();
        }
        zipFile.close();
    }

    public void compress(String srcFile, String destPath) throws Exception {
        this.compress(new File(srcFile), new File(destPath));
    }

    public void compress(File srcFile, File destFile) throws Exception {
        CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(destFile), new CRC32());
        ZipOutputStream zos = new ZipOutputStream(cos);
        this.compress(srcFile, zos, BASE_DIR);
        zos.flush();
        zos.close();
    }

    private void compress(File srcFile, ZipOutputStream zos, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            this.compressDir(srcFile, zos, basePath);
        } else {
            this.compressFile(srcFile, zos, basePath);
        }
    }

    private void compressDir(File dir, ZipOutputStream zos, String basePath) throws Exception {
        File[] files = dir.listFiles();
        if (files.length < 1) {
            ZipEntry entry = new ZipEntry(String.valueOf(basePath) + dir.getName() + PATH);
            zos.putNextEntry(entry);
            zos.closeEntry();
        }
        String dirName = BASE_DIR;
        String path = BASE_DIR;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (basePath != null && !BASE_DIR.equals(basePath)) {
                dirName = dir.getName();
            }
            path = String.valueOf(basePath) + dirName + PATH;
            this.compress(file, zos, path);
            ++n2;
        }
    }

    private void compressFile(File file, ZipOutputStream zos, String dir) throws Exception {
        int count;
        if (PATH.equals(dir)) {
            dir = BASE_DIR;
        } else if (dir.startsWith(PATH)) {
            dir = dir.substring(1, dir.length());
        }
        ZipEntry entry = new ZipEntry(String.valueOf(dir) + file.getName());
        zos.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] data = new byte[1024];
        while ((count = bis.read(data, 0, 1024)) != -1) {
            zos.write(data, 0, count);
        }
        bis.close();
        zos.closeEntry();
    }
}

