/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import sun.security.util.Length;

public final class KeyLength {
    public static final int getKeySize(Key key) {
        Object object;
        int n = -1;
        if (key instanceof Length) {
            try {
                object = (Length)((Object)key);
                n = object.length();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (n >= 0) {
                return n;
            }
        }
        if (key instanceof SecretKey) {
            object = (SecretKey)key;
            String string = object.getFormat();
            if ("RAW".equals(string) && object.getEncoded() != null) {
                n = object.getEncoded().length * 8;
            }
        } else if (key instanceof RSAKey) {
            object = (RSAKey)((Object)key);
            n = object.getModulus().bitLength();
        } else if (key instanceof ECKey) {
            object = (ECKey)((Object)key);
            n = object.getParams().getOrder().bitLength();
        } else if (key instanceof DSAKey) {
            object = (DSAKey)((Object)key);
            n = object.getParams().getP().bitLength();
        } else if (key instanceof DHKey) {
            object = (DHKey)((Object)key);
            n = object.getParams().getP().bitLength();
        }
        return n;
    }
}

