/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import sun.net.idn.Punycode;
import sun.net.idn.StringPrep;
import sun.text.normalizer.UCharacterIterator;

public final class IDN {
    public static final int ALLOW_UNASSIGNED = 1;
    public static final int USE_STD3_ASCII_RULES = 2;
    private static final String ACE_PREFIX = "xn--";
    private static final int ACE_PREFIX_LENGTH;
    private static final int MAX_LABEL_LENGTH = 63;
    private static StringPrep namePrep;

    public static String toASCII(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < string.length()) {
            n3 = IDN.searchDots(string, n2);
            stringBuffer.append(IDN.toASCIIInternal(string.substring(n2, n3), n));
            n2 = n3 + 1;
            if (n2 >= string.length()) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public static String toASCII(String string) {
        return IDN.toASCII(string, 0);
    }

    public static String toUnicode(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < string.length()) {
            n3 = IDN.searchDots(string, n2);
            stringBuffer.append(IDN.toUnicodeInternal(string.substring(n2, n3), n));
            n2 = n3 + 1;
            if (n2 >= string.length()) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public static String toUnicode(String string) {
        return IDN.toUnicode(string, 0);
    }

    private IDN() {
    }

    private static String toASCIIInternal(String string, int n) {
        boolean bl;
        StringBuffer stringBuffer;
        boolean bl2 = IDN.isAllASCII(string);
        if (!bl2) {
            UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(string);
            try {
                stringBuffer = namePrep.prepare(uCharacterIterator, n);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        } else {
            stringBuffer = new StringBuffer(string);
        }
        boolean bl3 = bl = (n & 2) != 0;
        if (bl) {
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (IDN.isLDHChar(c)) continue;
                throw new IllegalArgumentException("Contains non-LDH characters");
            }
            if (stringBuffer.charAt(0) == '-' || stringBuffer.charAt(stringBuffer.length() - 1) == '-') {
                throw new IllegalArgumentException("Has leading or trailing hyphen");
            }
        }
        if (!bl2 && !IDN.isAllASCII(stringBuffer.toString())) {
            if (!IDN.startsWithACEPrefix(stringBuffer)) {
                try {
                    stringBuffer = Punycode.encode((StringBuffer)stringBuffer, null);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(parseException);
                }
                stringBuffer = IDN.toASCIILower(stringBuffer);
                stringBuffer.insert(0, ACE_PREFIX);
            } else {
                throw new IllegalArgumentException("The input starts with the ACE Prefix");
            }
        }
        if (stringBuffer.length() > 63) {
            throw new IllegalArgumentException("The label in the input is too long");
        }
        return stringBuffer.toString();
    }

    private static String toUnicodeInternal(String string, int n) {
        StringBuffer stringBuffer;
        Object object;
        Object var2_2 = null;
        boolean bl = IDN.isAllASCII(string);
        if (!bl) {
            try {
                object = UCharacterIterator.getInstance(string);
                stringBuffer = namePrep.prepare((UCharacterIterator)object, n);
            }
            catch (Exception exception) {
                return string;
            }
        } else {
            stringBuffer = new StringBuffer(string);
        }
        if (IDN.startsWithACEPrefix(stringBuffer)) {
            object = stringBuffer.substring(ACE_PREFIX_LENGTH, stringBuffer.length());
            try {
                StringBuffer stringBuffer2 = Punycode.decode((StringBuffer)new StringBuffer((String)object), null);
                String string2 = IDN.toASCII(stringBuffer2.toString(), n);
                if (string2.equalsIgnoreCase(stringBuffer.toString())) {
                    return stringBuffer2.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static boolean isLDHChar(int n) {
        if (n > 122) {
            return false;
        }
        return n == 45 || 48 <= n && n <= 57 || 65 <= n && n <= 90 || 97 <= n && n <= 122;
    }

    private static int searchDots(String string, int n) {
        char c;
        int n2;
        for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '.' && c != '\u3002' && c != '\uff0e' && c != '\uff61'; ++n2) {
        }
        return n2;
    }

    private static boolean isAllASCII(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean startsWithACEPrefix(StringBuffer stringBuffer) {
        boolean bl = true;
        if (stringBuffer.length() < ACE_PREFIX_LENGTH) {
            return false;
        }
        for (int i = 0; i < ACE_PREFIX_LENGTH; ++i) {
            if (IDN.toASCIILower(stringBuffer.charAt(i)) == ACE_PREFIX.charAt(i)) continue;
            bl = false;
        }
        return bl;
    }

    private static char toASCIILower(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 97 - 65);
        }
        return c;
    }

    private static StringBuffer toASCIILower(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            stringBuffer2.append(IDN.toASCIILower(stringBuffer.charAt(i)));
        }
        return stringBuffer2;
    }

    static {
        block2: {
            ACE_PREFIX_LENGTH = ACE_PREFIX.length();
            namePrep = null;
            InputStream inputStream = null;
            try {
                inputStream = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return StringPrep.class.getResourceAsStream("uidna.spp");
                    }
                }) : StringPrep.class.getResourceAsStream("uidna.spp");
                namePrep = new StringPrep(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

