﻿function sha1(str, raw) {
    var hexcase = 0;
    var chrsz = 8;
    str = utf16to8(str);

    function utf16to8(str) {
        var out, i, len, c;

        out = "";
        len = str.length;
        for (i = 0; i < len; i++) {
            c = str.charCodeAt(i);
            if ((c >= 0x0001) && (c <= 0x007F)) {
                out += str.charAt(i);
            } else if (c > 0x07FF) {
                out += String.fromCharCode(0xE0 | ((c >> 12) & 0x0F));
                out += String.fromCharCode(0x80 | ((c >> 6) & 0x3F));
                out += String.fromCharCode(0x80 | ((c >> 0) & 0x3F));
            } else {
                out += String.fromCharCode(0xC0 | ((c >> 6) & 0x1F));
                out += String.fromCharCode(0x80 | ((c >> 0) & 0x3F));
            }
        }
        return out;
    }

    function hex_sha1(s) {
        return binb2hex(core_sha1(str2binb(s), s.length * chrsz));
    }

    function str_sha1(s) {
        return binb2str(core_sha1(str2binb(s), s.length * chrsz));
    }

    function binb2hex(binarray) {
        var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
        var str = "";
        for (var i = 0; i < binarray.length * 4; i++) {
            str += hex_tab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8 + 4)) & 0xF) +
                hex_tab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8)) & 0xF);
        }
        return str;
    }

    function binb2str(bin) {
        var str = "";
        var mask = (1 << chrsz) - 1;
        for (var i = 0; i < bin.length * 32; i += chrsz)
            str += String.fromCharCode((bin[i >> 5] >>> (32 - chrsz - i % 32)) & mask);
        return str;
    }

    function str2binb(str) {
        var bin = Array();
        var mask = (1 << chrsz) - 1;
        for (var i = 0; i < str.length * chrsz; i += chrsz)
            bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << (32 - chrsz - i % 32);
        return bin;
    }

    function safe_add(x, y) {
        var lsw = (x & 0xFFFF) + (y & 0xFFFF);
        var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return (msw << 16) | (lsw & 0xFFFF);
    }

    function rol(num, cnt) {
        return (num << cnt) | (num >>> (32 - cnt));
    }

    function sha1_ft(t, b, c, d) {
        if (t < 20)
            return (b & c) | ((~b) & d);
        if (t < 40)
            return b ^ c ^ d;
        if (t < 60)
            return (b & c) | (b & d) | (c & d);
        return b ^ c ^ d;
    }

    function sha1_kt(t) {
        return (t < 20) ? 1518500249 : (t < 40) ? 1859775393 : (t < 60) ? -1894007588 : -899497514;
    }

    function core_sha1(x, len) {
        x[len >> 5] |= 0x80 << (24 - len % 32);
        x[((len + 64 >> 9) << 4) + 15] = len;

        var w = Array(80);
        var a = 1732584193;
        var b = -271733879;
        var c = -1732584194;
        var d = 271733878;
        var e = -1009589776;

        for (var i = 0; i < x.length; i += 16) {
            var olda = a;
            var oldb = b;
            var oldc = c;
            var oldd = d;
            var olde = e;

            for (var j = 0; j < 80; j++) {
                if (j < 16)
                    w[j] = x[i + j];
                else
                    w[j] = rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1);
                var t = safe_add(safe_add(rol(a, 5), sha1_ft(j, b, c, d)), safe_add(safe_add(e, w[j]), sha1_kt(j)));
                e = d;
                d = c;
                c = rol(b, 30);
                b = a;
                a = t;
            }

            a = safe_add(a, olda);
            b = safe_add(b, oldb);
            c = safe_add(c, oldc);
            d = safe_add(d, oldd);
            e = safe_add(e, olde);
        }
        return Array(a, b, c, d, e);
    }

    if (raw == true) {
        return str_sha1(str);
    } else {
        return hex_sha1(str);
    }
}


var encode_list = [0, 2, 4, 16];

function decode_sha1_safe_pwd(pwd) {
    var old = pwd;
    if (pwd.length == 48) {
        pwd = pwd.split("");
        var i, c, n, p, tmp;
        tmp = 0;
        for (i = 0, c = pwd.length; i < c; i++) {
            tmp += parseInt(pwd[i], 16);
        }
        tmp = (parseInt(pwd[0], 16) - (tmp % 2) * 2);
        if (tmp < 0) tmp += 16;
        pwd[0] = tmp.toString(16);

        for (i = encode_list.length - 1; i >= 0; i--) {
            pwd.reverse();
            n = encode_list[i];
            p = pwd[n];
            tmp = parseInt(p, 16);
            tmp = pwd.splice(n + tmp, 1);
            if (tmp[0] != pwd.pop()) {
                break;
            }
        }
        return pwd.join("");
    }
    return sha1(old);
}

function sha1pwd(pwd, account, vcode) {
    return sha1(sha1(decode_sha1_safe_pwd(pwd) + sha1(account)) + vcode.toUpperCase());
}

function encode_safe_pwd(pwd) {
    var tmp;

    pwd = decode_sha1_safe_pwd(pwd);
    pwd = pwd.split("");
    var i, c, n, p
    for (i = 0, c = encode_list.length; i < c; i++) {
        n = encode_list[i];
        p = pwd[n];
        tmp = parseInt(p, 16);
        pwd.splice(n + tmp, 0, p);
        pwd.push(p);
        pwd.reverse();
    }
    tmp = 0;
    for (i = 0, c = pwd.length; i < c; i++) {
        tmp += parseInt(pwd[i], 16);
    }
    tmp = ((tmp % 2) * 2 + parseInt(pwd[0], 16)) % 16;
    pwd[0] = tmp.toString(16);
    return pwd.join("");
}

function uniqid(prefix, more_entropy) {
    if (typeof prefix == 'undefined') {
        prefix = "";
    }

    var retId;
    var formatSeed = function (seed, reqWidth) {
        seed = parseInt(seed, 10).toString(16); // to hex str
        if (reqWidth < seed.length) { // so long we split
            return seed.slice(seed.length - reqWidth);
        }
        if (reqWidth > seed.length) { // so short we pad
            return Array(1 + (reqWidth - seed.length)).join('0') + seed;
        }
        return seed;
    };

    if (!this.php_js) {
        this.php_js = {};
    }
    if (!this.php_js.uniqidSeed) { // init seed with big random int
        this.php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
    }
    this.php_js.uniqidSeed++;

    retId = prefix; // start with prefix, add current milliseconds hex string
    retId += formatSeed(parseInt(new Date().getTime() / 1000, 10), 8);
    retId += formatSeed(this.php_js.uniqidSeed, 5); // add seed hex string
    if (more_entropy) {
        // for more entropy we add a float lower to 10
        retId += (Math.random() * 10).toFixed(8).toString();
    }

    return retId;
}