Class(function(extend, using, self){
    using("lib/jquery.min.js");
    $(function () {
        window.imageEdit = (function () {
            var $imageEditBox = $("#image-edit-box");
            var $imageEdit = $("#imageEdit");
            var $mask = $("#head-mask");
            var $photoFrame = $("#photoFrame");
            var $self = $("#image-source");
            var $editPlaceHolder = $("#image-placeholder");
            var $resizeAnchor = $photoFrame.find("span");
            var imageSource = $self.data("source");
            var scaling = 1;
            if (imageSource == "" || !imageSource) {
                console.log("需要在id= image-source 的标签中配置图片的URL");
            }
            var editBoxW, editBoxH;
            var imageRatio;

            //预览图
            var thumbnail = (function () {
                var $thumbBox = $(".thumb-image-box");
                var $thumb100 = $thumbBox.find(".room-head-100");
                var $thumb60 = $thumbBox.find(".room-head-60");
                var $thumb30 = $thumbBox.find(".room-head-30");
                var $thumb68 = $thumbBox.find(".room-head-68");
                var $thumbArea = $thumbBox.find(".thumb-area");
                var imageW, imageH;
                var ratio = [100, 60, 30];
                if ($thumb68.length > 0) {
                    ratio = [68];
                }
                function setImage(w, h, ratio, index, img) {
                    var scale = ratio / $photoFrame.width();
                    var imageWidth = w * scale;
                    var imageHeight = h * scale;
                    var thumbImage = $thumbArea.eq(index).find("img");
                    img.width(imageWidth);
                    img.height(imageHeight);
                    if (thumbImage.length > 0) {
                        thumbImage.remove();
                    }
                    $thumbArea.eq(index).append(img);
                }
                function setPosition(l, t, ratio, index) {
                    var img = $thumbArea.eq(index).find("img");
                    var imageW = img.width();
                    var imageH = img.height();
                    var left = imageW * (l / editBoxW);
                    var top = imageH * (t / editBoxH);
                    img.css({ "left": (-left) + "px", "top": (-top) + "px" });
                }
                function setSize(w, h, ratio, index) {
                    //缩略图和当前的比例如100*100  主图和当前的相框  有一定的比例关系
                    var img = $thumbArea.eq(index).find("img");
                    var width = ratio / (w / editBoxW);
                    var height = width / imageRatio;
                    img.css({ "width": (width) + "px", "height": (height) + "px" });
                }
                return {
                    addImage: function (w, h) {
                        $(ratio).each(function (index, ratio) {
                            //var img = $("<img src=" + imageSource + " />");
                            var img = $("<img/>");
                            img.attr("src",imageSource);
                            setImage(w, h, ratio, index, img);
                        });
                    },
                    setPosition: function (l, t) {
                        $(ratio).each(function (index, ratio) {
                            setPosition(l, t, ratio, index);
                        });
                    },
                    setSize: function (w, h) {
                        $(ratio).each(function (index, ratio) {
                            setSize(w, h, ratio, index);
                        });
                    },
                    setThumbnail: function (offsetL) {
                        setThumbnail(offsetL);
                    },
                    mainImg: function () {
                        return $thumb100.find("img");
                    }
                }
            })();
            //图片编辑区域
            var editBox = {
                setDataSource: function (data) {
                    $imageEditBox.removeClass("loading");
                    this.removeBg();
                    $editPlaceHolder.hide();
                    imageSource = data;
                    this.imageLoad(data);
                },
                imageLoad: function (source) {
                    var errorImage = "static/images/head.png";//图片加载错误图片
                    var imageW, imageH;
                    var that = this;
                    var $imgDom = $("<img />");
                    $imgDom.bind("load", function () {
                        $self.data("loading", false);
                        $self.data("error", false);
                        $self.hide();
                        if ($self.is("img")) {
                            $self.attr("src", source);
                        }
                        imageW = $imgDom[0].width;
                        imageH = $imgDom[0].height;
                        that.create(imageW, imageH);
                        $imageEditBox.removeClass("loading");
                        $self.show();
                        $self.data("loaded", true);
                    }).bind("error", function () {
                        $self.data("error", true);
                        $self.data("loading", false);
                        $("<img />").bind("load", function () {
                            $self.hide();
                            if ($self.is("img")) {
                                $self.attr("src", errorImage);
                            }
                            $imageEdit.height(158);
                            $imageEditBox.removeClass("loading");
                            $self.show();
                        }).attr("src", errorImage);
                    }).attr("src", source);
                },
                removeBg: function () {
                    $imageEditBox.removeClass("normal");
                },
                //用户是否还未上传头像
                getStatus: function () {
                    return $imageEditBox.data("status");
                },
                //设置用户上传头像的状态
                setStatus: function (boolean) {
                    $imageEditBox.data("status", boolean);
                },
                create: function (imageW, imageH) {
                    var editBoxW1 = $imageEditBox.width();
                    var editBoxH1 = $imageEditBox.height();
                    var image = this.resize_image($self, imageW, imageH, editBoxW1, editBoxH1);
                    var imageWidth = image.width;
                    var imageHeight = image.height;
                    $imageEdit.height(imageHeight);
                    $imageEdit.width(imageWidth);
                    if (imageW <= 100 || imageH <= 100) {
                        $imageEdit.height(imageH + 2);
                        $imageEdit.width(imageW + 2);
                        var image_maxSize;
                        if(imageW > imageH){
                            image_maxSize=imageH;
                        }else{
                            image_maxSize=imageW;
                        }
                        $photoFrame.width(image_maxSize);
                        $photoFrame.height(image_maxSize);
                    }else{
                        $photoFrame.width(100);
                        $photoFrame.height(100);
                    }
                    $imageEdit.css({ "marginLeft": -imageWidth / 2 + "px", "marginTop": -imageHeight / 2 + "px" })
                    $imageEdit.show();
                    thumbnail.addImage(imageWidth, imageHeight);
                    frame.init();
                },
                resize_image: function (self, image_width, image_height, parent_width, parent_height) {
                    var image = self;
                    var imageWidth, imageHeight;
                    if (image_width <= parent_width && image_height <= parent_height) {
                        imageWidth = image_width;
                        imageHeight = image_height;
                        scaling = 1;
                        image.css('height', imageHeight);
                        image.css('width', imageWidth);
                        return {
                            width:imageWidth,
                            height:imageHeight
                        }
                    }
                    if (parent_width / image_width > parent_height / image_height) {
                        imageHeight = parent_height;
                        imageWidth = image_width * parent_height / image_height;
                        scaling = parent_height / image_height;
                        image.css('height', imageHeight);
                        image.css('width', imageWidth);
                    }
                    else {
                        imageWidth = parent_width;
                        imageHeight = image_height * parent_width / image_width;
                        scaling = parent_width / image_width;
                        image.css('width', imageWidth);
                        image.css('height', imageHeight);
                    }
                    return {
                        width: imageWidth,
                        height: imageHeight
                    }
                }
            }
            //裁剪相框
            var frame = {
                init: function () {
                    editBoxW = $imageEdit.width();
                    editBoxH = $imageEdit.height();
                    var that = this;
                    $photoFrame.show();
                    this.center();
                    $photoFrame.bind("mousedown.frame", frame.moveEvent);
                    $resizeAnchor.bind("mousedown.scale", frame.scaleEvent);
                    imageRatio = editBoxW / editBoxH;
                    $("body").bind("mouseup", function (e) {
                        $photoFrame.unbind("mousemove.frame");
                        $imageEdit.unbind("mousemove.scale");
                        $photoFrame.bind("mousedown.frame", frame.moveEvent);
                        $resizeAnchor.bind("mousedown.scale", frame.scaleEvent);
                    });
                },
                center: function () {
                    var fWidth = $photoFrame.width();
                    var fHeight = $photoFrame.height();
                    var left = parseInt(editBoxW / 2 - fWidth / 2);
                    var top = parseInt(editBoxH / 2 - fHeight / 2);
                    $photoFrame.css({
                        left: left,
                        top: top
                    })
                    thumbnail.setPosition(left, top);
                },
                frameSize: function () {
                    var widthW = $photoFrame.outerWidth();
                    var heightH = $photoFrame.outerHeight();
                    return {
                        width: widthW,
                        height: heightH
                    }
                },
                getRatio: function () {
                    return parseInt(this.frameSize().width) / parseInt(this.frameSize().height);
                },
                setPosition: function (X, Y) {
                    var fWidth = $photoFrame.outerWidth();
                    var fHeight = $photoFrame.outerHeight();
                    var left = X;
                    var top = Y;
                    if (left < 0) {
                        left = 0;
                    }
                    if (left > editBoxW - fWidth) {
                        left = editBoxW - fWidth;
                    }
                    if (top < 0) {
                        top = 0;
                    }
                    if (top > editBoxH - fHeight) {
                        top = editBoxH - fHeight;
                    }
                    $photoFrame[0].style.left = left + "px";
                    $photoFrame[0].style.top = top + "px";
                    thumbnail.setPosition(left, top);
                },
                setScalePosition: function (X, Y) {
                    var left = X;
                    var top = Y;
                    $photoFrame[0].style.left = left + "px";
                    $photoFrame[0].style.top = top + "px";
                    thumbnail.setPosition(left, top);
                },
                setSize: function (w, h) {
                    var widthW = w;
                    var heightH = h;
                    $photoFrame.css({ width: widthW + "px", height: heightH + "px" });
                    thumbnail.setSize(widthW, heightH);
                },
                moveEvent: function (e) {
                    var mouseX = e.pageX;
                    var mouseY = e.pageY;
                    var framePX = $photoFrame.position().left;
                    var framePY = $photoFrame.position().top;
                    var that = this;
                    $photoFrame.bind("mousemove.frame", function (e) {
                        e.stopPropagation();
                        var x = e.pageX;
                        var y = e.pageY;
                        frame.setPosition(x - mouseX + framePX, y - mouseY + framePY);
                    });
                },
                scaleEvent: function (e) {
                    e.stopPropagation();
                    var index = $(this).index() + 1;
                    var frameW = frame.frameSize().width;
                    var frameH = frame.frameSize().height;
                    var mouseX = e.pageX;
                    var mouseY = e.pageY;
                    var framePX = $photoFrame.position().left;
                    var framePY = $photoFrame.position().top;
                    var ratio = frame.getRatio();
                    $imageEdit.bind("mousemove.scale", function (e) {
                        frame.size(e, index, mouseX, mouseY, frameW, frameH, framePX, framePY, ratio);
                    });
                },
                size: function (e, index, mouseX, mouseY, frameW, frameH, framePX, framePY, ratio) {
                    var x = e.pageX;
                    var y = e.pageY;
                    var that = this;
                    var fWidth = $photoFrame.width();
                    var fHeight = $photoFrame.height();
                    var width, height, left, top, offsetX;
                    switch (index) {
                        case 4:
                            var offsetX = x - mouseX;
                            var offsetY = offsetX / ratio;
                            width = frameW - offsetX;
                            height = frameH - offsetY;
                            left = offsetX + framePX;
                            top = framePY + (offsetY / 2);
                            if (height + framePY >= editBoxH - 2) {
                                return
                            }
                            break;
                        case 5:
                            var offsetX = x - mouseX;
                            var offsetY = offsetX / ratio;
                            width = frameW + offsetX;
                            height = frameH + offsetY;
                            left = framePX;
                            top = framePY - (offsetY / 2);
                            if (height + framePY >= editBoxH - 2 || width + framePX >= editBoxW - 2) {
                                return
                            }
                            break;
                        case 2:
                            var offsetY = y - mouseY;
                            var offsetX = offsetY * ratio;
                            width = frameW - offsetX;
                            height = frameH - offsetY;
                            left = framePX + (offsetX / 2);
                            top = framePY + offsetY;
                            if (width + framePX >= editBoxW - 2) {
                                return
                            }
                            break;
                        case 7:
                            var offsetY = y - mouseY;
                            var offsetX = offsetY * ratio;
                            width = frameW + offsetX;
                            height = frameH + offsetY;
                            left = framePX - (offsetX / 2);
                            top = framePY;
                            if (width + framePX >= editBoxW - 2) {
                                return
                            }
                            break;
                        case 1:
                            var offsetX = x - mouseX;
                            var offsetY = offsetX / ratio;
                            var sqr = Math.floor(Math.sqrt(offsetX * offsetX + offsetY * offsetY));
                            if (offsetX > 0) {
                                var offsetW = -sqr;
                            } else {
                                var offsetW = sqr;
                            }
                            var offsetH = offsetW / ratio;
                            width = frameW + offsetW;
                            height = width / ratio;
                            left = framePX - offsetW;
                            top = framePY - offsetH;
                            break;
                        case 3:
                            var offsetX = x - mouseX;
                            var offsetY = offsetX / ratio;
                            var sqr = Math.floor(Math.sqrt(offsetX * offsetX + offsetY * offsetY));;
                            if (offsetX > 0) {
                                var offsetW = -sqr;
                            } else {
                                var offsetW = sqr;
                            }
                            var offsetH = offsetW / ratio;
                            width = frameW - offsetW;
                            height = width / ratio;
                            left = framePX;
                            top = framePY + offsetH;
                            if (width + framePX >= editBoxW - 2) {
                                return
                            }
                            break;
                        case 6:
                            var offsetX = x - mouseX;
                            var offsetY = offsetX / ratio;
                            var sqr = Math.floor(Math.sqrt(offsetX * offsetX + offsetY * offsetY));
                            if (offsetX > 0) {
                                var offsetW = -sqr;
                            } else {
                                var offsetW = sqr;
                            }
                            var offsetH = offsetW / ratio;
                            width = offsetW + frameW;
                            height = width / ratio;
                            left = framePX - offsetW;
                            top = framePY;
                            if (height + framePY >= editBoxH - 2) {
                                return
                            }
                            break;
                        case 8:
                            var offsetX = x - mouseX;
                            var offsetY = offsetX / ratio;
                            var sqr = Math.floor(Math.sqrt(offsetX * offsetX + offsetY * offsetY));
                            if (offsetX > 0) {
                                var offsetW = -sqr;
                            } else {
                                var offsetW = sqr;
                            }
                            var offsetH = offsetW / ratio;
                            width = frameW - offsetW;
                            height = width / ratio;
                            var widthT = thumbnail.mainImg().width() + offsetW;
                            var heightT = widthT / (editBoxW / editBoxH);
                            left = framePX;
                            top = framePY;
                            if (height + framePY >= editBoxH - 2 || width + framePX >= editBoxW - 2) {
                                return
                            }
                            break;
                    }
                    if (top < 0) {
                        top = 0;
                        return
                    }
                    if (left < 0) {
                        left = 0;
                        return
                    }
                    that.setSize(width, height);
                    that.setScalePosition(left, top);
                }
            }

            return {
                //设置图片url
                setImageUrl: function (url) {
                    $self.data("source", url);
                },
                scale:function(){
                    return scaling;
                },
                getFramePosition: function () {
                    var left = $photoFrame.position().left;
                    var top = $photoFrame.position().top;
                    return { x: left, y: top }
                },
                getFrameSize: function () {
                    var w = $photoFrame.width();
                    var h = $photoFrame.height();
                    return { width: w, height: h }
                },
                setDataSource: function (imageSource) {
                    imageSource = "file:///" + imageSource;
                    editBox.setDataSource(imageSource);
                }
            }
        })()
    })
})
