Class(function(extend, using, self){
    using("lib/jquery.min.js");


    // 默认设置
    var data = { country: "中国", city: "北京市", area: "北京市" };

    var country_id = 0;

    // 国家列表
    var countryList = ["中国"];

    // 城市-地区列表
    // 北京  上海   天津  重庆
    // 安徽  福建   甘肃  广东  广西
    // 贵州  海南   河北  河南  黑龙江
    // 湖北  湖南   吉林  江苏  江西
    // 辽宁  内蒙古 宁夏  青海  山东
    // 山西  陕西   四川  西藏  新疆
    // 云南  浙江
    // 香港  澳门   台湾
    var areaList = {
        citys: ["北京市", "上海市", "天津市", "重庆市",
            "安徽省", "福建省", "甘肃省", "广东省", "广西壮族自治区",
            "贵州省", "海南省", "河北省", "河南省", "黑龙江省",
            "湖北省", "湖南省", "吉林省", "江苏省", "江西省",
            "辽宁省", "内蒙古自治区", "宁夏回族自治区", "青海省", "山东省",
            "山西省", "陕西省", "四川省", "西藏自治区", "新疆维吾尔族自治区",
            "云南省", "浙江省",
            "香港特别行政区", "澳门特别行政区", "台湾省", " "],

        "北京市": ["北京市"],
        "上海市": ["上海市"],
        "天津市": ["天津市"],
        "重庆市": ["重庆市"],

        "安徽省": ["合肥", "芜湖", "蚌埠", "马鞍山", "淮北", "铜陵", "安庆", "黄山", "滁州", "宿州", "池州", "淮南", "巢湖", "阜阳", "六安", "宣城", "亳州"],
        "福建省": ["福州", "厦门", "莆田", "三明", "泉州", "漳州", "南平", "龙岩", "宁德", "平潭"],
        "甘肃省": ["兰州", "嘉峪关", "金昌", "白银", "天水", "酒泉", "张掖", "武威", "定西", "陇南", "平凉", "庆阳", "临夏", "甘南"],
        "广东省": ["广州", "深圳", "珠海", "汕头", "东莞", "中山", "佛山", "韶关", "江门", "湛江", "茂名", "肇庆", "惠州", "梅州", "汕尾", "河源", "阳江", "清远", "潮州", "揭阳", "云浮"],
        "广西壮族自治区": ["南宁", "柳州", "桂林", "梧州", "北海", "防城港", "钦州", "贵港", "玉林", "贺州", "百色", "河池", "来宾", "崇左"],

        "贵州省": ["贵阳", "六盘水", "遵义", "安顺", "铜仁", "黔西南", "毕节", "黔东南", "黔南"],
        "海南省": ["海口", "三亚", "三沙", "儋州", "五指山", "文昌", "琼海", "万宁", "东方", "定安", "屯昌", "澄迈", "临高", "琼中", "保亭", "白沙", "昌江", "乐东", "陵水"],
        "河北省": ["石家庄", "邯郸", "邢台", "保定", "张家口", "承德", "廊坊", "唐山", "秦皇岛", "沧州", "衡水"],
        "河南省": ["郑州", "开封", "洛阳", "平顶山", "安阳", "鹤壁", "新乡", "焦作", "濮阳", "许昌", "漯河", "三门峡", "南阳", "商丘", "信阳", "周口", "驻马店", "济源"],
        "黑龙江省": ["哈尔滨", "齐齐哈尔", "牡丹江", "佳木斯", "大庆", "绥化", "鹤岗", "鸡西", "黑河", "双鸭山", "伊春", "七台河", "大兴安岭", "绥芬河", "抚远"],

        "湖北省": ["武汉", "宜昌", "荆州", "襄阳", "鄂州", "黄石", "荆门", "黄冈", "十堰", "恩施", "潜江", "天门", "仙桃", "随州", "咸宁", "孝感", "鄂州"],
        "湖南省": ["长沙", "常德", "株洲", "湘潭", "衡阳", "岳阳", "邵阳", "益阳", "娄底", "怀化", "郴州", "永州", "湘西", "张家界"],
        "吉林省": ["长春", "吉林", "四平", "辽源", "通化", "白山", "松原", "白城", "延边", "梅河口", "公主岭"],
        "江苏省": ["南京", "镇江", "苏州", "南通", "扬州", "盐城", "徐州", "连云港", "常州", "无锡", "宿迁", "泰州", "淮安"],
        "江西省": ["南昌", "景德镇", "九江", "鹰潭", "萍乡", "新余", "赣州", "吉安", "宜春", "抚州", "上饶"],

        "辽宁省": ["沈阳", "大连", "鞍山", "抚顺", "本溪", "丹东", "锦州", "营口", "阜新", "辽阳", "盘锦", "铁岭", "朝阳", "葫芦岛"],
        "内蒙古自治区": ["呼和浩特", "包头", "乌海", "赤峰", "通辽", "鄂尔多斯", "呼伦贝尔", "巴彦淖尔", "乌兰察布", "阿拉善盟", "兴安盟", "锡林郭勒盟"],
        "宁夏回族自治区": ["银川", "石嘴山", "吴忠", "固原", "中卫"],
        "青海省": ["西宁", "海东", "海南", "海北", "黄南", "玉树", "果洛", "海西"],
        "山东省": ["济南", "青岛", "淄博", "枣庄", "东营", "烟台", "潍坊", "济宁", "泰安", "威海", "日照", "莱芜", "临沂", "德州", "聊城", "滨州", "菏泽"],

        "山西省": ["太原", "大同", "阳泉", "长治", "晋城", "朔州", "吕梁", "忻州", "晋中", "临汾", "运城"],
        "陕西省": ["西安", "宝鸡", "咸阳", "铜川", "渭南", "延安", "榆林", "汉中", "安康", "商洛"],
        "四川省": ["成都", "绵阳", "德阳", "自贡", "攀枝花", "广元", "遂宁", "内江", "乐山", "南充", "宜宾", "巴中", "广安", "达州", "雅安", "眉山", "资阳", "泸州", "甘孜", "凉山", "阿坝"],
        "西藏自治区": ["拉萨", "日喀则", "山南", "林芝", "昌都", "阿里", "那曲"],
        "新疆维吾尔族自治区": ["乌鲁木齐", "石河子", "克拉玛依", "伊犁", "巴音郭勒", "昌吉", "克孜勒苏柯尔克孜", "博尔塔拉", "吐鲁番", "哈密", "喀什", "和田", "阿克苏", "塔城", "阿勒泰", "阿拉尔", "图木舒克", "五家渠", "北屯", "铁门关", "双河"],

        "云南省": ["昆明", "大理", "曲靖", "玉溪", "昭通", "楚雄", "红河", "文山", "西双版纳", "保山", "德宏", "丽江", "怒江", "迪庆", "临沧", "保山", "普洱"],
        "浙江省": ["杭州", "宁波", "温州", "嘉兴", "湖州", "绍兴", "金华", "衢州", "舟山", "台州", "丽水"],

        "香港特别行政区": ["香港特别行政区"],
        "澳门特别行政区": ["澳门特别行政区"],
        "台湾省": ["台北", "新北", "高雄", "台中", "台南", "屏东", "南投", "云林", "新竹", "彰化", "苗栗", "嘉义", "花莲", "桃园", "宜兰", "基隆", "台东", "金门", "马祖", "澎湖"],
        " ": [" "]
    };
    var curUser = null;

    // 地址显示
    // $("#city div").attr("value", 0);
    // 地址显示框
    $(".selInput").on("click", toggleSelInput);

    /* 阻止事件冒泡 */
    $(".selInputArea").on("click", function(e) { e.stopPropagation(); });
    $(".selectList").on("click", function(e) { e.stopPropagation(); });

    // 下拉箭头
    $(".down-arrow").on("click", selectAddr);
    $(".selSelectOp div").on("click", function () { $(this).next().trigger("click"); });

    // 显示地址设置区域
    function toggleSelInput(e) {
        e.stopPropagation();

        var $selInput = $(this);
        var $selArea = $(".selInputArea");

        // 解绑事件, 并设置选择样式
        $selInput.off("click", toggleSelInput).addClass("selected");

        // 计算地址设置区域的大小以及位置
        var width = $selInput.outerWidth();
        var height = $selInput.height();
        var pos = $selInput.position();

        $selArea.css({
            marginLeft: pos.left,
            marginTop: pos.top + height + 5
        });
        $selArea.outerWidth(width);

        // $("#country div").text(data.country); // 国家

        $("#city div").text(data.city); // 城市
        $("#area div").text(data.area); // 地区
        $selArea.show();

        // 点击其他区域, 隐藏地址选择
        $(document).on("click", hideSelInput);
    };

    // 点击其他区域, 隐藏地址选择
    function hideSelInput(e) {
        var $self = $(".selInput");

        $(document).off("click", hideSelInput); // 解除绑定
        $self.removeClass("selected");
        $(".selInputArea").hide();
        $(".selectList").hide();

        if(country_id == 1) {
            $self.text("").on("click", toggleSelInput);
        }else {
            $self.text(data.city + (data.city == data.area ? "" : " " + data.area)).on("click", toggleSelInput);
        }
    };

    // 弹出地址选择下拉框
    function selectAddr(e) {
        var dataId = $(this).parent().attr("id"); // example: country, city, area
        var htmlStr = "";

        var sel_id = $(".selectList ul").attr("data-id");

        if(dataId === "country") { // 国家

        }else if(dataId === "city") {
            if (sel_id !== dataId) {
                var citys = queryCityList();

                for (var i = 0, len = citys.length; i < len; i++) {
                    htmlStr += "<li value='" + i + "' style='height:20px;'>" + citys[i] + "</li>";
                }
                $(".selectList ul").html(htmlStr);
                $(".selectList ul").attr("data-id", dataId);
                $(".selectList ul li").on("click", updateAddr);
            }
        }else {
            if (sel_id !== dataId) {
                var areas = queryAreaListByCity(data.city);

                for (var i = 0, len = areas.length; i < len; i++) {
                    htmlStr += "<li value='" + i + "' style='height:20px;'>" + areas[i] + "</li>";
                }
                $(".selectList ul").html(htmlStr);
                $(".selectList ul").attr("data-id", dataId);
                $(".selectList ul li").on("click", updateAddr);
            }
        }

        // 计算地址选项区域
        var $self = $(this);
        var width = $self.prev().outerWidth();
        var height = $self.parent().outerHeight();
        var absPox = $self.parent().offset();

        $(".selectList").css({
            marginLeft: absPox.left,
            marginTop: absPox.top + height
        });
        $(".selectList").outerWidth(width);
        $(".selectList").show();
    };


    // 更新地址信息
    function updateAddr(e) {
        var dataId = $(this).parent().attr("data-id");
        var value = $(this).text();
        var code = $(this).attr("value");

        if(value !== "") {
            data[dataId] = value;
            if(dataId === "country") {

            }else if(dataId === "city") {
                var areas = queryAreaListByCity(value);
                $("#city div").text(value);
                $("#area div").text(areas[0]);
                data.area = areas[0];

                $(".selInput").text(value + (value == areas[0] ? "" : " " + areas[0]));
                curUser.settingApply(true);
            }else {
                var city = data.city;
                $("#area div").text(value);
                $(".selInput").text(city + (value == data.city ? "" : " " + value));
                curUser.settingApply(true);
            }
        }

        $(".selectList").hide();
    }


    // 查询城市列表
    function queryCityList() {
        return areaList["citys"];
    }

    // 查询地区列表
    function queryAreaListByCity(city) {
        return areaList[city];
    }

    self.getData = function(){
        return data;
    }

    self.func(function(user){
        curUser = user;
    })
})
