﻿Class(function(extend,using,self){
    extend("pages/page");
    using("lib/jquery.min.js");

    self.test_mic_ref = null;
    self.initPage = function () {

    }
    // 设置麦克风、者扬声器音量效果
    self.setAudioVol = function (vol) {
        $(".volunmbar-active").css({ "width": parseInt(vol / 100 * 166) });
    }
    // 显示试麦成功、失败的结果
    self.showTestMicInfo = function (status) {
        $(".content-page1").hide();
        $(".content-page2").hide();
        var c = $(".content-page3");
        if (status == "success") {
            c.find(".popup-box div").first().removeAttr("class").addClass("ico-succ");
            c.find(".c-report-title").text("恭喜您，语音设备可以正常使用！");
            c.find(".c-report-tip").text("如果您还未听到对方声音，不妨建议对方进行语音检测。");
            c.find(".c-send-report").hide();
        }
        if (status == "failed") {
            c.find(".popup-box div").first().removeAttr("class").addClass("ico-fail");
            c.find(".c-report-title").text("很抱歉，您的扬声器无法使用！");
            c.find(".c-report-tip").text("已为您生成一份语音异常报告，建议您发送此报告帮助我们解决您的语音问题。");
        }
        c.show();
    }

    self.initEvent = function(){
        var that = this;
        /* 听到声音按钮 */
        $(document).delegate(".c-audio-yes", "click", function () {
            that.test_mic_ref.btn_voice_success_click();
        });

        /* 未听到声音按钮 */
        $(document).delegate(".c-audio-no", "click", function () {
            that.test_mic_ref.btn_voice_failed_click();
        });

        /* 完成按钮 */
        $(document).delegate(".c-btn-confirm", "click", function () {
            that.test_mic_ref.btn_close_click();
        });
    }

    self.func(function(curData){
        var that = this;

        /* 预览麦克风音量 */
        that.addCall("on_refresh_mico_vol", function (vol) {
            that.setAudioVol(vol);
        });

        /* 预览扬声器音量 */
        that.addCall("on_refresh_speak_vol", function (vol) {
            that.setAudioVol(vol);
        })

        /* 试麦失败 */
        that.addCall("on_display_check_audio_failed", function () {
            that.showTestMicInfo("failed");
        })

        /* 试麦成功 */
        that.addCall("on_display_check_audio_success", function () {
            that.showTestMicInfo("success");
        });

        /* 麦克风有声音输入显示提示 */
        that.addCall("on_display_mico_input_tips", function () {
            $(".c-mic-tip").show();
        });

        /* 显示扬声器 */
        that.addCall("on_display_speak_check", function() {
            $(".content-page1").hide();
            $(".content-page2").show();
        });

        /* 显示麦克风的信息 */
        that.addCall("on_refresh_mico_device", function(text1, text2) {
            var c = $(".c-mic-info");
            c.find("span").first().text(text1);
            c.find("select[name='c-select-mic']").empty().append("<option value=\"" + text2 + "\">" + text2 + "</option>");
            c.show();
        })

        /* 显示扬声器的信息 */
        that.addCall("on_refresh_speak_device", function(text1, text2) {
            var c = $(".c-speak-info");
            c.find("span").first().text(text1);
            c.find("select[name='c-select-spk']").empty().append("<option value=\"" + text2 + "\">" + text2 + "</option>");
        });

        that.test_mic_ref = curData;//checkaudio;
        that.sup().constructor(curData);
        that.initPage();
        that.initEvent();
    })
});

//Audio.TestMic = Audio.TestMic || {
//    test_mic_ref: null,
//    initPage: function () {
//
//    },/* 设置麦克风、者扬声器音量效果 */
//    setAudioVol: function (vol) {
//        $(".volunmbar-active").css({ "width": parseInt(vol / 100 * 166) });
//    },/* 显示试麦成功、失败的结果 */
//    showTestMicInfo: function (status) {
//        $(".content-page1").hide();
//        $(".content-page2").hide();
//        var c = $(".content-page3");
//        if (status == "success") {
//            c.find(".popup-box div").first().removeAttr("class").addClass("ico-succ");
//            c.find(".c-report-title").text("恭喜您，语音设备可以正常使用！");
//            c.find(".c-report-tip").text("如果您还未听到对方声音，不妨建议对方进行语音检测。");
//            c.find(".c-send-report").hide();
//        }
//        if (status == "failed") {
//            c.find(".popup-box div").first().removeAttr("class").addClass("ico-fail");
//            c.find(".c-report-title").text("很抱歉，您的扬声器无法使用！");
//            c.find(".c-report-tip").text("已为您生成一份语音异常报告，建议您发送此报告帮助我们解决您的语音问题。");
//        }
//        c.show();
//    }
//};

///* 预览麦克风音量 */
//function on_refresh_mico_vol(vol) {
//    Audio.TestMic.setAudioVol(vol);
//}
//
///* 预览扬声器音量 */
//function on_refresh_speak_vol(vol) {
//    Audio.TestMic.setAudioVol(vol);
//}
//
///* 试麦失败 */
//function on_display_check_audio_failed() {
//    Audio.TestMic.showTestMicInfo("failed");
//}
//
///* 试麦成功 */
//function on_display_check_audio_success() {
//    Audio.TestMic.showTestMicInfo("success");
//}
//
///* 麦克风有声音输入显示提示 */
//function on_display_mico_input_tips() {
//    $(".c-mic-tip").show();
//}
//
///* 显示扬声器 */
//function on_display_speak_check() {
//    $(".content-page1").hide();
//    $(".content-page2").show();
//}
//
///* 显示麦克风的信息 */
//function on_refresh_mico_device(text1, text2) {
//    var c = $(".c-mic-info");
//    c.find("span").first().text(text1);
//    c.find("select[name='c-select-mic']").empty().append("<option value=\"" + text2 + "\">" + text2 + "</option>");
//    c.show();
//}
//
///* 显示扬声器的信息 */
//function on_refresh_speak_device(text1, text2) {
//    var c = $(".c-speak-info");
//    c.find("span").first().text(text1);
//    c.find("select[name='c-select-spk']").empty().append("<option value=\"" + text2 + "\">" + text2 + "</option>");
//}

//(function () {
//    /* 听到声音按钮 */
//    $(document).delegate(".c-audio-yes", "click", function () {
//        Audio.TestMic.test_mic_ref.btn_voice_success_click();
//    });
//
//    /* 未听到声音按钮 */
//    $(document).delegate(".c-audio-no", "click", function () {
//        Audio.TestMic.test_mic_ref.btn_voice_failed_click();
//    });
//
//    /* 完成按钮 */
//    $(document).delegate(".c-btn-confirm", "click", function () {
//        Audio.TestMic.test_mic_ref.btn_close_click();
//    });
//})();

//window.onload = function () { Audio.TestMic.test_mic_ref = checkaudio; Audio.TestMic.initPage(); }