Class(function(extend, using, self){
    using("lib/jquery.min.js");

    var me = {
        spend_mill_time : 0,
        spend_second_time : 0,
        log_trace_status : 0
    };

    self.static("load", function(curData){
        this.New(curData);
    })

    self.func(function(data){
        this.curPage = {
            client: this,
            server: data
        };

        var that = this;
        window.onerror = function(sMsg,sUrl,sLine){
            var arr = new Array();
            arr.push("An error was thrown and caught.===");
            arr.push("Error: " + sMsg + "===");
            arr.push("Line: " + sLine + "===");
            arr.push("URL: " + sUrl + "===");

            that.log_trace(that.curPage.server, arr.join(""), 0)
        }

       
    });

    // 添加c++调用函数
    self.addCall = function(name, func){
        window[name] = func;
    }
    self.isEmpty = function(){
        if (arguments.length <= 0 || arguments[0] === null || arguments[0] === undefined)
            return true;
        return (arguments[0].replace(/(^\s*)|(\s*$)/g, "") == "");
    };
    self.toInt = function(){
        if (arguments.length <= 0) return 0;
        if (isNaN(parseInt(arguments[0])))
            return 0;
        else
            return parseInt(arguments[0]);
    };
    self.func("formatData",  function (data) {
        return window.eval('(' + data + ')');
    });
    /* 通过等级获取不同的level样式*/
    self.func("change_class_by_level" , function (level, text) {
        if (level >= 0 && level < 20) {
            $(".Integral " + text).addClass("level");
        }
        if (level >= 20 && level < 40) {
            $(".Integral " + text).addClass("level2");
        }
        if (level >= 40 && level < 60) {
            $(".Integral " + text).addClass("level3");
        }
        if (level >= 60 && level < 80) {
            $(".Integral " + text).addClass("level4");
        }
        if (level >= 80 + text) {
            $(".Integral " + text).addClass("level5");
        }
    });
    /*按数字排序*/
    self.func("sort", function (obj) {
        return obj.sort(function (a, b) {
            return a > b ? 1 : -1
        });
    });

    /*正则替换，替换长度很长的城市名字*/
    self.func("replaceLongCityName", function (a) {
        return a.replace(/中国/g, "").replace(/特别行政区/g, "").replace(/自治区/g, "").replace(/壮族/g, "").replace(/回族/g, "").replace(/维吾尔族/g, "").replace(/省/g, "").replace(/市/g, "").replace(/县/g, "");
    })

    /*正则替换防止注入*/
    self.func("encodeHTML",  function (a) {
        return a.replace(/\&/g, "&amp;").replace(/"/g, "&quot;").replace(/\</g, "&lt;").replace(/\>/g, "&gt;").replace(/\'/g, "&#39;").replace(/\u00A0/g, "&nbsp;").replace(/(\u000B|\u2028|\u2029|\f)/g, "&#32;");
    })

    /*正则替换防止注入，替换单双引号*/
    self.func("encodeHTMLQuotes" , function (a) {
        return a.replace(/\&/g, "&amp;").replace(/"/g, "&quot;").replace(/\</g, "&lt;").replace(/\>/g, "&gt;").replace(/\'/g, "&#39;").replace(/\u00A0/g, "&nbsp;").replace(/\\/g, "\\\\").replace(/(\u0020|\u000B|\u2028|\u2029|\f)/g, "&#32;").replace(/\"/g, "\\\"").replace(/\'/g, "\'").replace(/\n/g, "\\n");
    })

    self.func("log_trace", function(msg){
        this.curPage
            && this.curPage.server
            && this.log_trace(this.curPage.server, msg, 0);
    })

    /* 添加日志*/
    self.func("log_trace", function(log_ref, str){
        this.log_trace(log_ref, str, 0);
    });
    self.func("log_trace", function (log_ref, str, flag) {
        var d,
            spend_second_time,
            spend_mill_time,
            second_time,
            mill_time,
            sum_mill_time;

        if (flag == 3) {
            me.log_trace_status = 1;
            return;
        }
        if (me.log_trace_status == undefined) {

        } else {
            if (flag == 1) {
                d = new Date();
                spend_second_time = d.getSeconds();
                spend_mill_time = d.getMilliseconds();
                me.spend_second_time = spend_second_time;
                me.spend_mill_time = spend_mill_time;
                log_ref.log_trace(str + "时间:" + d + "--second:" + spend_second_time + "----mill:" + spend_mill_time);
            }
            if (flag == 0) {
                d = new Date();
                spend_second_time = d.getSeconds();
                spend_mill_time = d.getMilliseconds();
                second_time = spend_second_time - me.spend_second_time;
                mill_time = spend_mill_time - me.spend_mill_time;
                me.spend_second_time = spend_second_time;
                me.spend_mill_time = spend_mill_time;
                sum_mill_time = 1000 * second_time + mill_time;
                // + ":second:" + spend_second_time + ":mill:" + spend_mill_time

                log_ref.log_trace(str + "sum_mill_time:" + sum_mill_time);
            }
        }
    });
    var _utf8_encode = function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";
        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    }

    var _utf8_decode = function (utftext) {
        var string = "",
            i = 0,
            c = 0,
            c1 = 0,
            c2 = 0;

        while (i < utftext.length) {
            c = utftext.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
    self.func("encode" , function (string) {
        return escape(_utf8_encode(string));
    });

    self.func("decode" , function (string) {
        return _utf8_decode(unescape(string));
    });

    /* 计算字符串长度 */
    self.func("strlen" , function (str, w) {
        var count_cn = 0, count_else = 0;
        for (var i = 0; i < str.length; i++) {
            if (str.charCodeAt(i) > 1327)
                count_cn = count_cn + 1;
            else
                count_else = count_else + 1;
        }
        return (!w ? count_cn * 2 + count_else * 1 : Math.ceil(count_cn * 1 + count_else * 0.5));
    });

    /*计算字符串字节长度*/
    self.func("getByteVal", function (val, max) {
        var returnValue = '';
        var byteValLen = 0;
        for (var i = 0; i <= val.length; i++) {
            if (val[i].match(/[^\x00-\xff]/ig) != null)
                byteValLen += 2;
            else
                byteValLen += 1;

            if (byteValLen > max)
                break;

            returnValue += val[i];
        }
        return returnValue;
    });
    //删除左右两端的空格
    self.func("trim" , function (str) {
        return str.replace(/(^\s*)|(\s*$)/g, "");
    });
    //删除左边的空格
    self.func("ltrim" , function (str) {
        return str.replace(/(^\s*)/g, "");
    });
    //删除右边的空格
    self.func("rtrim" , function (str) {
        return str.replace(/(\s*$)/g, "");
    });

    //获取元素绝对坐标
    self.func("cumulativeOffset" , function (element) {
        var top = 0, left = 0;
        do {
            top += element.offsetTop || 0;
            left += element.offsetLeft || 0;
            element = element.offsetParent;
        } while (element);

        return {
            top: top,
            left: left
        };
    });
});

//var Audio = Audio || {
//    spend_mill_time: 0,
//    spend_second_time: 0,
//    log_trace_status: 0
//  };
//Audio.isEmpty = function () {
//  if (arguments.length <= 0 || arguments[0] === null || arguments[0] === undefined)
//    return true;
//  return (arguments[0].replace(/(^\s*)|(\s*$)/g, "") == "");
//};
//Audio.toInt = function () {
//  if (arguments.length <= 0) return 0;
//  if (isNaN(parseInt(arguments[0])))
//    return 0;
//  else
//    return parseInt(arguments[0]);
//};
//Audio.formatData = function (data) {
//  return window.eval('(' + data + ')');
//};

/* 通过等级获取不同的level样式*/
//Audio.change_class_by_level = function (level, text) {
//  if (level >= 0 && level < 20) {
//    $(".Integral " + text).addClass("level");
//  }
//  if (level >= 20 && level < 40) {
//    $(".Integral " + text).addClass("level2");
//  }
//  if (level >= 40 && level < 60) {
//    $(".Integral " + text).addClass("level3");
//  }
//  if (level >= 60 && level < 80) {
//    $(".Integral " + text).addClass("level4");
//  }
//  if (level >= 80 + text) {
//    $(".Integral " + text).addClass("level5");
//  }
//};

///*按数字排序*/
//Audio.sort = function (obj) {
//  return obj.sort(function (a, b) {
//    return a > b ? 1 : -1
//  });
//};

///*正则替换，替换长度很长的城市名字*/
//Audio.replaceLongCityName = function (a) {
//  return a.replace(/中国/g, "").replace(/特别行政区/g, "").replace(/自治区/g, "").replace(/壮族/g, "").replace(/回族/g, "").replace(/维吾尔族/g, "").replace(/省/g, "").replace(/市/g, "").replace(/县/g, "");
//};
//
///*正则替换防止注入*/
//Audio.encodeHTML = function (a) {
//  return a.replace(/\&/g, "&amp;").replace(/"/g, "&quot;").replace(/\</g, "&lt;").replace(/\>/g, "&gt;").replace(/\'/g, "&#39;").replace(/\u00A0/g, "&nbsp;").replace(/(\u000B|\u2028|\u2029|\f)/g, "&#32;");
//};
//
///*正则替换防止注入，替换单双引号*/
//Audio.encodeHTMLQuotes = function (a) {
//  return a.replace(/\&/g, "&amp;").replace(/"/g, "&quot;").replace(/\</g, "&lt;").replace(/\>/g, "&gt;").replace(/\'/g, "&#39;").replace(/\u00A0/g, "&nbsp;").replace(/\\/g, "\\\\").replace(/(\u0020|\u000B|\u2028|\u2029|\f)/g, "&#32;").replace(/\"/g, "\\\"").replace(/\'/g, "\'").replace(/\n/g, "\\n");
//};

//
//Audio.log_trace = function (log_ref, str, flag) {
//  var d,
//    spend_second_time,
//    spend_mill_time,
//    second_time,
//    mill_time,
//    sum_mill_time;
//
//  if (flag == 3) {
//    Audio.log_trace_status = 1;
//    return;
//  }
//  if (Audio.log_trace_status == undefined) {
//
//  } else {
//    if (flag == 1) {
//      d = new Date();
//      spend_second_time = d.getSeconds();
//      spend_mill_time = d.getMilliseconds();
//      Audio.spend_second_time = spend_second_time;
//      Audio.spend_mill_time = spend_mill_time;
//      log_ref.log_trace(str + "时间:" + d + "--second:" + spend_second_time + "----mill:" + spend_mill_time);
//    }
//    if (flag == 0) {
//      d = new Date();
//      spend_second_time = d.getSeconds();
//      spend_mill_time = d.getMilliseconds();
//      second_time = spend_second_time - Audio.spend_second_time;
//      mill_time = spend_mill_time - Audio.spend_mill_time;
//      Audio.spend_second_time = spend_second_time;
//      Audio.spend_mill_time = spend_mill_time;
//      sum_mill_time = 1000 * second_time + mill_time;
//      // + ":second:" + spend_second_time + ":mill:" + spend_mill_time
//      log_ref.log_trace(str + "sum_mill_time:" + sum_mill_time);
//    }
//  }
//
//};

//Audio.encode = function (string) {
//  return escape(_utf8_encode(string));
//};
//
//Audio.decode = function (string) {
//  return _utf8_decode(unescape(string));
//};

//function _utf8_encode(string) {
//  string = string.replace(/\r\n/g, "\n");
//  var utftext = "";
//  for (var n = 0; n < string.length; n++) {
//
//    var c = string.charCodeAt(n);
//
//    if (c < 128) {
//      utftext += String.fromCharCode(c);
//    }
//    else if ((c > 127) && (c < 2048)) {
//      utftext += String.fromCharCode((c >> 6) | 192);
//      utftext += String.fromCharCode((c & 63) | 128);
//    }
//    else {
//      utftext += String.fromCharCode((c >> 12) | 224);
//      utftext += String.fromCharCode(((c >> 6) & 63) | 128);
//      utftext += String.fromCharCode((c & 63) | 128);
//    }
//  }
//  return utftext;
//}
//
//function _utf8_decode(utftext) {
//  var string = "",
//    i = 0,
//    c = 0,
//    c1 = 0,
//    c2 = 0;
//
//  while (i < utftext.length) {
//    c = utftext.charCodeAt(i);
//    if (c < 128) {
//      string += String.fromCharCode(c);
//      i++;
//    }
//    else if ((c > 191) && (c < 224)) {
//      c2 = utftext.charCodeAt(i + 1);
//      string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
//      i += 2;
//    }
//    else {
//      c2 = utftext.charCodeAt(i + 1);
//      c3 = utftext.charCodeAt(i + 2);
//      string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
//      i += 3;
//    }
//  }
//  return string;
//}

///* 计算字符串长度 */
//Audio.strlen = function (str, w) {
//  var count_cn = 0, count_else = 0;
//  for (var i = 0; i < str.length; i++) {
//    if (str.charCodeAt(i) > 1327)
//      count_cn = count_cn + 1;
//    else
//      count_else = count_else + 1;
//  }
//  return (!w ? count_cn * 2 + count_else * 1 : Math.ceil(count_cn * 1 + count_else * 0.5));
//};
//
///*计算字符串字节长度*/
//Audio.getByteVal = function (val, max) {
//  var returnValue = '';
//  var byteValLen = 0;
//  for (var i = 0; i <= val.length; i++) {
//    if (val[i].match(/[^\x00-\xff]/ig) != null)
//      byteValLen += 2;
//    else
//      byteValLen += 1;
//
//    if (byteValLen > max)
//      break;
//
//    returnValue += val[i];
//  }
//  return returnValue;
//};
////删除左右两端的空格
//Audio.trim = function (str) {
//  return str.replace(/(^\s*)|(\s*$)/g, "");
//};
////删除左边的空格
//Audio.ltrim = function (str) {
//  return str.replace(/(^\s*)/g, "");
//};
////删除右边的空格
//Audio.rtrim = function (str) {
//  return str.replace(/(\s*$)/g, "");
//};
//
////获取元素绝对坐标
//Audio.cumulativeOffset = function (element) {
//  var top = 0, left = 0;
//  do {
//    top += element.offsetTop || 0;
//    left += element.offsetLeft || 0;
//    element = element.offsetParent;
//  } while (element);
//
//  return {
//    top: top,
//    left: left
//  };
//};

