﻿Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");
    self.login_ref  = login;
    self.plugin_account = plugin_account;
    self.password = password;


    self.initPage = function () {
        // 获取历史用户列表
        var users = this.login_ref.get_current_user();
        var user_name = '';
        var user_pwd = '';

        if (users.length > 0) {
            user_name = users[users.length - 1];
            this.plugin_account.setText(user_name);
            if (this.login_ref.is_save_pwd(user_name)) {
                user_pwd = this.login_ref.get_pwd(user_name);
                if (!this.isEmpty(user_pwd)) {
                    this.password.setText(user_pwd);
                }
                $("input[type='checkbox'][name='password-check']").prop('checked', true);
            }
        }

        if (user_name && user_pwd) {
            $('.btn').focus();
        }

        if (user_name && !user_pwd) {
            this.password.setFocus();
        }
        if (!user_name && !user_pwd) {
            this.plugin_account.setFocus();
        }

        /**
         *是否自动登陆
         */
        if (this.login_ref.is_autologin()) {
            $("input[type='checkbox'][name='login-auto']").prop('checked', true);
            $("input[type='checkbox'][name='password-check']").prop('checked', true);
            this.checkLogin();
        }
    };

    self.checkLogin = function () {
        var login = $(".login-box");
        var uname = this.plugin_account.text;
        var pwd = this.password.text;
        var pwd_check = login.find("input[name='password-check']:checked").val();
        var login_auto = login.find("input[name='login-auto']:checked").val();
        if (this.isEmpty(uname)) {
            login.find(".error-box").text('请您输入账号后再登录');
            return false;
        }
        if (this.isEmpty(pwd)) {
            login.find(".error-box").text('请您输入密码后再登录');
            return false;
        }
        var login_ret = this.login_ref.start_login(uname, pwd);
        if (login_ret == 0) {
            login.find(".error-box").text('获取用户登录信息失败');
            return false;
        } else if (login_ret == 1) {
            login.find(".loading-mask").show();
            this.login_ref.enable_view = false;
            $('body').bind("selectstart", function () {
                return false;
            });
        }
    }

    self.initEvent = function(){
        var that = this;
        /* 登陆按钮 */
        $(document).delegate(".btn", "click", function () {
            that.checkLogin();
        });
        /* 自动登陆按钮 */
        $(document).delegate("input[type='checkbox'][name='login-auto']", "click", function () {
            if ($(this).is(':checked')) {
                $("input[type='checkbox'][name='password-check']").prop('checked', true);
            }
        });
        // 点击label，相邻兄弟节点checked改变状态
        $(document).delegate("label", "click", function () {
            var flag = $(this).prev().is(":checked");
            if (flag == true) {
                $(this).prev().prop('checked', false);
            } else {
                $(this).prev().prop('checked', true);
            }
        });
        /* 自动登陆按钮 */
        $(document).delegate("input[type='checkbox'][name='password-check']", "click", function () {
            if (!$(this).is(':checked')) {
                $("input[type='checkbox'][name='login-auto']").prop('checked', false);
            }
        });
        /* 点击账号和密码框清楚错误信息 */
        $(document).delegate(".f-box :input", "click", function () {
            $(".error-box").text('');
        });
        /* 键入回车键则登录否则清除错误提示 */
        $(document).delegate(".f-box :input", "keydown", function (e) {
            if (e.keyCode == 13) {
                this.checkLogin();
            } else {
                $(".error-box").text('');
            }
        });

        $(document).delegate(".btn", "keydown", function (e) {
            if (e.keyCode == 9) {
                document.getElementById("password-check").focus();
                that.plugin_account.ffocus = true;
            }
        });
    }

    self.func(function(data){
        var that = this;

        this.sup().construct(data);
        //  通知js异步登陆的结果
        window.on_login_res = function(err_msg) {
            var login = $(".login-box");
            that.login_ref.enable_view = true;
            login.find(".error-box").text(err_msg);
            login.find(".loading-mask").hide();

        }
        // tab键事件
        window.on_tabpress = function(tagid) {
            if (tagid == "plugin_account") {
                that.password.ffocus = true;
            } else if (tagid == "plugin_pwd") {
                that.login_ref.set_webctrl_focus();
                document.getElementById("password-check").focus();
            }
        }
        // 清空密码和提示
        window.empty_pwd = function() {
            that.password.text = "";
        }
        // 清空密码和提示
        window.empty_object = function() {
            $(".error-box").text('');
        }
        // 获取保存密码是否选中
        window.is_save_pwd = function() {
            if ($("input[type='checkbox'][name='password-check']").is(':checked')) {
                return true;
            }
            return false;
        }
        // 获取自动登陆是否选中
        window.is_auto_login = function() {
            if ($("input[type='checkbox'][name='login-auto']").is(':checked')) {
                return true;
            }
            return false;
        }
        /* keydown 时间(异步)*/
        window.login_by_key_down = function() {
            that.checkLogin();
        }
        /*账号密码改变清空数据(异步)*/
        window.on_textchanged = function(tagid) {
            if (tagid == "plugin_account") {
                that.password.setText("");
                $(".error-box").text('');
            } else {
                var pwd = that.password.text();
                if (pwd.length) {
                    $(".error-box").text('');
                }
            }
        }
        /* loading-mask 控制*/
        window.on_show_loading = function(bshow) {
            var login = $(".login-box");
            if (bshow == true) {
                that.login_ref.enable_view = false;
                login.find(".loading-mask").show();
            } else {
                that.login_ref.enable_view = true;
                login.find(".loading-mask").hide();
            }
        }

        that.plugin_account.hinttext = "请输入账号";
        that.password.hinttext = "请输入密码";

        this.initPage();
        this.initEvent();
    });
});