Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");
    using("plugin/jquery.contextMenu");
    using("plugin/jsrender.min")
    var _curRefeashNumTxt = "";
    //self.hall_ref = {"objectName":"halllogic","internal":true,"inaddress":true,"enable_view":false,"zoneinfo_json":""}//hall;
    self.hall_ref = null;//hall;
    self.internal_status = 0;
    self.myroom_flag = 0;
    self.roomId = 0;
    self.lastbrowse_count = 0,
    self.room_ref = {};
    self.cache_img = {};
    self.showRoomList = function () {
        var r;
        if (this.lastbrowse_count > 0) {
            r = $("#recentRoom");
            r.find(".title").css({ "background-color": "#e5a639" })
                             .find("span:eq(0)")
                             .removeClass("triangle-right")
                             .removeClass("triangle-down")
                             .addClass("triangle-down");
            r.find(".item-box").show();
        }
        else {
            r = $("#myRoom");
            r.find(".title").css({"background-color": "#e5a639"})
                             .find("span:eq(0)")
                             .removeClass("triangle-right")
                             .removeClass("triangle-down")
                             .addClass("triangle-down");
            r.find(".item-box").show();
        }
    }
    self.resizeListHeight = function () {
        /* 296px 是除去房间列表高度之外的 (2014-10-09) + 2px 为里列表的边框 */
        var windowHeight = $("body").height();
        var targetTop = $(".room-container").offset().top;
        var messageHeight = $(".message").height();
        var height = windowHeight - targetTop - messageHeight - 5;
        $(".room-container").height(height);
        $(".item-box").css({"height": document.documentElement.clientHeight - 298});
    }
    self.mySet = function (index) {
        this.hall_ref.ShowUserInfoSet(index);
    }
    self.room = function (id, name, number, imageUrl) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.imageUrl = "file:///" + imageUrl;
    }
    self.room_recommend = function (id, name, number, imageUrl) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.imageUrl = imageUrl;
    }
    /* 添加收藏 */
    self.addFavorite = function (id) {
        this.hall_ref.save_zone(id);
    }
    /* 取消收藏*/
    self.removeFavorite = function (id) {
        this.hall_ref.unsave_zone(id);
    }
    /* 添加收藏列表 */
    self.addFavoriteList = function (id) {
        var r = $("#my-favorite-result");
        var items;
        if (r.find(".c-room-list-" + id).length > 0) {
            return;
        }
        var info = this.hall_ref.get_myzone_on_id(id);
        if (info && info.zoneid > 0) {
            items = [];
            items.push('<div class="item c-room-list-{{:id}}" roomid="{{:id}}">');
            items.push('    <ul>');
            items.push('        <li>');
            items.push('            <div><img class="image" src="file:///{{:imageUrl}}" alt="{{:imageUrl}}" /></div>');
            items.push('            <div class="info">');
            items.push('            <div class="name">{{:name}}</div>');
            items.push('            <div class="id"><span>ID</span>{{:id}}</div>');
            items.push('                <div class="people">');
            items.push('                    <span class="member-ico"></span>');
            items.push('                    <span class="member-num c-room-list-number-{{:id}}">{{:number}}</span>');
            items.push('                    <div class="action" style="display:none;"> ');
            items.push('                    <span class="trash-normal-ico" rol="delete" title="移除"></span>');
            items.push('                </div>');
            items.push('            </div>');
            items.push('            </div>');
            items.push('        </li>');
            items.push('    </ul>');
            items.push('</div>');
            items.push('<div class="horizontal-line c-room-list-{{:id}}"></div>');
            var sum_people = $(".c-room-list-number-" + id + ":first").text();
            var text = items.join("").replace(/\{\{\:id\}\}/g, info.zoneid)
                                      .replace(/\{\{\:name\}\}/, this.encodeHTML(info.zonename))
                                      .replace(/\{\{\:imageUrl\}\}/g, info.imagepath + "?t=" + Math.random())
                                      .replace(/\{\{\:number\}\}/g, sum_people);
            if (r.find(".item").length > 0) {
                r.children(":last").after(text);
            } else {
                r.append(text);
            }
        }
    }
    /* 添加历史记录列表 */
    self.addLastBrowse = function () {
        var info = this.hall_ref.get_current_zoneinfo();
        var r = $("#last-browse-result");
        var item_list = r.find(".item");
        var sum_count = item_list.length;
        var items;
        if (sum_count > 20) {
            $.each(item_list, function (key, value) {
                if (key == 20) {
                    $(this).remove();
                }
            });
        }
        if (r.find(".c-room-list-" + info.zoneid).length > 0) {
            r.find(".c-room-list-" + info.zoneid).remove();
        }
        if (info && info.zoneid > 0) {
            items = [];
            items.push('<div class="item c-room-list-{{:id}}" roomid="{{:id}}">');
            items.push('<ul>');
            items.push('    <li>');
            items.push('        <div class="image"><img class="image" src="file:///{{:imageUrl}}" alt="{{:imageUrl}}" /></div>');
            items.push('        <div class="info">');
            items.push('            <div class="name">{{:name}}</div>');
            items.push('            <div class="id"><span>ID</span>{{:id}}</div>');
            items.push('            <div class="people">');
            items.push('                <span class="member-ico"></span>');
            items.push('                <span class="member-num c-room-list-number-{{:id}}">{{:number}}</span>');
            items.push('                <div class="action" style="display:none;">');
            items.push('                    <span class="collect-normal-ico" rol="collect"></span>');
            items.push('                    <span class="trash-normal-ico" rol="delete_last_browse" title="移除"></span>');
            items.push('                </div>');
            items.push('            </div>');
            items.push('        </div>');
            items.push('    </li>');
            items.push('</ul>');
            items.push('</div>');
            items.push('<div class="horizontal-line c-room-list-{{:id}}"></div>');

            var text = items.join("").replace(/\{\{\:id\}\}/g, info.zoneid)
                                      .replace(/\{\{\:name\}\}/, this.encodeHTML(info.zonename))
                                      .replace(/\{\{\:imageUrl\}\}/g, info.imagepath + "?t=" + Math.random())
                                      .replace(/\{\{\:number\}\}/g, info.zone_member);
            if (r.find(".item").length > 0) {
                r.find("div:first").before(text);
            } else {
                r.append(text);
            }
        }
    }
    /* 取消收藏列表 */
    self.removeFavoriteList = function (id) {
        var r = $("#my-favorite-result");
        var m = r.find(".c-room-list-" + id);
        if (m.length <= 0) {
            return;
        }
        m.remove();
    };
    /* 添加我的房间列表 */
    self.addRoomList = function (room_id, room_name, room_desc, room_member, room_image) {
        var r = $("#my-zone-result");
        var items;
        if (r.find(".c-room-list-" + room_id).length > 0) {
            return;
        }
        if (room_id > 0) {
            items = [];
            items.push('<div class="item c-room-list-{{:id}}" roomid="{{:id}}">');
            items.push('    <ul>');
            items.push('        <li>');
            items.push('            <div><img class="image" src="file:///{{:imageUrl}}" alt="{{:imageUrl}}" /></div>');
            items.push('            <div class="info">');
            items.push('                    <div class="name">{{:name}}</div>');
            items.push('                        <div class="id"><span>ID</span>{{:id}}</div>');
            items.push('                        <div class="people">');
            items.push('                            <span class="member-ico"></span>');
            items.push('                            <span class="member-num c-room-list-number-{{:id}}">{{:number}}</span>');
            items.push('                            <div class="action" style="display:none;">');
            items.push('                                <span class="collect-normal-ico" rol="collect"></span>');
            items.push('                         </div>');
            items.push('                    </div>');
            items.push('            </div>');
            items.push('        </li>');
            items.push('    </ul>');
            items.push('</div>');
            items.push('<div class="horizontal-line c-room-list-{{:id}}"></div>');
            var text = items.join("").replace(/\{\{\:id\}\}/g, room_id)
                                     .replace(/\{\{\:name\}\}/, this.encodeHTML(room_name))
                                     .replace(/\{\{\:imageUrl\}\}/g, room_image + "?t=" + Math.random())
                                     .replace(/\{\{\:number\}\}/g, 0);
            if (r.find(".item").length > 0) {
                r.children(":last").after(text);
            } else {
                r.append(text);
            }
        }
    }
    /* 查找房间 */
    self.findRoom = function (id) {
        this.hall_ref.find_zone(id);
    }
    /* 显示房间信息 */
    self.cache_room_online = [];
    self.setRoomOnline = function (id, n) {
        this.cache_room_online[id] = n;


        var that = this;
        $(".c-room-list-number-" + id).text(n);
        $(".box-hori-flex-dynamic").eq(0).before($(".c-room-list-number-" + id).not(".subscribe-lol-result .c-room-list-number-" + id).text(n).closest(".box-hori-flex-dynamic"));
        $(".box-hori-flex").each(function(){
            var _id = $(this).find(".id").html().replace("ID:","").replace(/\s/g, "");
            if (_id == id)
                $(this).find(".number").text(n);
        })
    };
    self.setVideoRoomOnline = function(id, n){
        this.cache_room_online[id] = n;
        $('i[uid="'+id+'"]').text(n);
        //$(".c-video-room-list-number-" + id).text(n);
    }

    self.viewRoom = function (id) {
        this.hall_ref.view_zoneinfo(id);
    }
    /* 进入房间 */
    self.enterRoom = function (id) {
        this.hall_ref.enter_zone(id, 0, "");
    }
    /* 创建房间 */
    self.createRoom = function () {
        this.hall_ref.query_create_zone();
    }
    /* 绑定我的个人信息 */
    self.bindUserInfo = function () {
        var c = $(".c-head-info"), info = this.hall_ref.my_local_info(), level = parseInt(Math.sqrt(info.experience / 60));
        c.find(".head-box img:first").attr({src: "file:///" + info.imagepath + "?t=" + Math.random()});
        c.find(".name").text(info.name);
        c.find(".name").attr("title", info.name);
        c.find('.Integral span:first').text("积分：" + parseInt(info.experience / 60));
        c.find('span:eq(1) strong').text(level);
        c.show();
        this.change_class_by_level(level, "span:eq(1)");
    }
    /* 绑定我的房间信息 */
    self.bindMyRoomsInfo = function () {
        var count = this.hall_ref.get_myzone_count();
        var room_infos = [];
        for (var i = 0; i < count; i++) {
            var info = this.hall_ref.get_myzone_on_index(i);
            if (info && info.zoneid > 0) {
                room_infos.push(new this.room(info.zoneid, this.encodeHTML(info.zonename), 0, info.imagepath + "?t=" + Math.random()));
            }
        }
        $("#my-zone-result").html($("#my-zone-tpl").render(room_infos));
    }
    self.bindMyFavoritesInfo = function () {
        var count = this.hall_ref.get_savezone_count();
        var room_infos = [];
        for (var i = 0; i < count; i++) {
            var info = this.hall_ref.get_savezone_on_index(i);
            if (info && info.zoneid > 0) {
                room_infos.push(new this.room(info.zoneid, this.encodeHTML(info.zonename), 0, info.imagepath));
            }
        }
        $("#my-favorite-result").html($("#my-favorite-tpl").render(room_infos));
    }
    self.bindLastBrowseRoomsInfo = function () {
        this.lastbrowse_count = this.hall_ref.get_recentzone_count();
        var room_infos = [];
        for (var i = 0; i < this.lastbrowse_count; i++) {
            var info = this.hall_ref.get_recentzone_on_index(i);
            if (info && info.zoneid > 0) {
                room_infos.push(new this.room(info.zoneid, this.encodeHTML(info.zonename), 0, info.imagepath));
            }
        }
        //alert(JSON.stringify(room_infos))
        $("#last-browse-result").html($("#last-browse-tpl").render(room_infos));
        $("#recommend").show();
    }
    self.removeLastBrowse = function (id) {
        var r = $("#last-browse-result");
        var m = r.find(".c-room-list-" + id);
        if (m.length <= 0) {
            return;
        }
        m.remove();
        this.hall_ref.delete_zone_from_recent(id);
    }



    /* 根据errCode获取错误信息说明 */
    self.bindSubscribeRoomsInfo = function () {
        var count = this.hall_ref.get_publiczone_count();
        var room_infos = [];
        for (var i = 8; i < 12; i++) {
            var info = this.hall_ref.get_publiczone_on_index(i);
            if (info && info.zoneid > 0) {
                var zone_name = this.trim(info.zonename);
                //info.imagepath =  get_server_addr(info.zoneid);

                info.imagepath = "file:///" + info.imagepath + "?t=" + Math.random();
                room_infos.push(new this.room_recommend(info.zoneid, this.encodeHTML(zone_name), this.cache_room_online[info.zoneid] || 0, info.imagepath));
            }
        }

        $("#subscribe-lol-result").html($("#subscribe-lol-tpl").render(room_infos));
    }
    self.getErrorMessage = function (err_code) {
        return this.hall_ref.get_errcode(err_code);
    }
    /*获取内外网状态*/
    self.InitIntnetStatus = function () {
        var flag1 = this.hall_ref.internal;
        var flag2 = this.hall_ref.inaddress;
        if (flag1 == true) {
            this.internal_status = 1;
            this.log_trace(hall, "内网开启日志:", 3);
        }
    }

    self.getPrivateImgUrl = function (anchor, gid, zid) {
        var temp = zid + '/' + gid + '/' + anchor + '.png?r='+Math.random();
        if (hall.inaddress) {
            return 'http://10.0.19.14/file/images/live/' + temp;
        } else {
            return 'http://pic.5211game.com/images/live/' + temp;
        }
    }
    self.makeEmptyPosition = function (box, n) {
        var ch = box.children();
        var len = ch.length;
        var remove = n - (4 - len);
        if (remove == 1) {
            ch.eq(0).remove();
        }
        if (remove == 2) {
            ch.eq(0).remove();
            ch.eq(1).remove();
        }
        if (remove == 3) {
            ch.eq(0).remove();
            ch.eq(1).remove();
            ch.eq(2).remove();
        }
        if (remove == 4) {
            box.html('');
        }
    }
    self.makeKRoom = function (name, title, number, gid, zid, anchor) {
        hall.log_trace("hall makeKroom返回直播房间图片");
        var that = this;
        var $div = $('<div>').addClass('k-room-box');
       // $div.html('<img src="' + that.getPrivateImgUrl(anchor, gid, zid) + '" onerror="this.src=\'static/images/roomsmall.png\'" /><div class="k-room-hover"></div><div class="k-room-tag"><p></p><span></span><i></i></div>');
        $div.html('<img src="static/images/hall/video0nline-background.gif" onerror="this.src=\'static/images/roomsmall.png\'" /><div class="k-room-hover"></div><div class="k-room-tag"><p></p><span></span><i></i></div>');

        $div.find('p').text(name).attr("title", name);
        $div.find('span').text(title).attr("title", title)
        var clsName = ".c-video-room-list-number-"+anchor;
        $div.find('i').attr("uid", anchor).text(this.makeUserNumber(number));

        $div.click(function () {
            that.hall_ref.enter_zone(zid, gid, "");
        });
        this.room_ref[anchor] = $div;
        return $div;
    }
    self.makeGRoom = function (name, number, gid, zid, anchor) {
        hall.log_trace("hall makeGroom返回直播房间图片");

        var that = this;
        var $div = $('<div>').addClass('g-room-box');
        $div.html('<img src="' + that.getPrivateImgUrl(anchor, gid, zid) + '" onerror="this.src=\'images/roomsmall.png\'" />'
                    + '<div class="g-room-hover"></div>'
                    + '<div class="g-room-tag">'
                    +   '<span></span>'
                    +   '<i></i>'
                    + '</div>');
        this.setText($div.find('span'), name, 8);
        $div.find('i').addClass(".c-video-room-list-number-" + anchor).text(this.makeUserNumber(number));
        $div.click(function () {
            that.hall_ref.enter_zone(zid, gid, "");
        });
        this.room_ref[anchor] = $div;


        return $div;
    }
    self.makePRoom = function (name, title, number, gid, zid, type, anchor) {
        // 游戏直播
        if (type == 2) {
            return this.makeKRoom(name, title, number, gid, zid, anchor);
        }
        // 美女直播
        if (type == 1) {
            return this.makeGRoom(name, number, gid, zid, anchor);
        }
    }
    self.makeUserNumber = function (number) {
        if (number < 10000) {
            return number;
        } else {
            return Math.round(number / 1000) / 10 + '万';
        }
    }
    self.isJsonOK = function (json) {
        return (json && Array.isArray(json) && (json.length > 0));
    }
    self.getShortString = function (str, len) {
        if (str && len) {
            if (str.length <= len) {
                return str;
            }
            return str.substr(0, len) + '...';
        }
        return '';
    }
    self.setText = function ($o, text, len) {
        var t = text;
        if (!text) {
            t = '';
        }
        if (len >= text.length) {
            t = text;
        } else {
            t = text.substr(0, len) + '...';
            $o.attr('title', text);
        }
        $o.text(t);
    }
    // 初始化事件
    self.initEvent = function(){
        var that = this;
        //右键创建房间
        $.contextMenu({
            selector: '.emptyDiv', callback: function (key, options) {
                //var m = "clicked: " + key;
                //window.console && console.log(m) || alert(m);
                switch (key) {
                    case "create":
                        that.createRoom();
                        break;
                    default:
                        return;
                }
            },
            animation: {show: "fadeIn", hide: "fadeOut"},
            items: {"create": {name: "创建房间", icon: "create"}}
        });

        // 点击头像后显示设置窗口
        $(document).delegate(".head-box img:first", "click", function () {
            that.mySet(0);
        });
        // 点击名称后显示设置窗口
        $(document).delegate(".head-info div:first", "click", function () {
            that.mySet(0);
        });
        // 房间上单击（选中操作）
        $(document).delegate(".item", "click", function (e) {
            e.stopPropagation();
            $(".item").each(function () {
                $(this).removeClass("active");
            });
            $(this).addClass("active");
        });

        // 房间上单击（进入房间操作）
        $(document).delegate(".status", "click", function (e) {
            e.stopPropagation();
            var id = parseInt($(this).parent().parent().attr("roomid"));
            if (id > 0) {
                that.enterRoom(id);
            }
        });

        // 房间上双击（进房操作）
        $(document).delegate(".item", "dblclick", function (e) {
            e.stopPropagation();
            var id = parseInt($(this).attr("roomid"));
            if (id > 0) {
                that.enterRoom(id);
            }
        });

        // 点击 我的房间 收藏房间 或者 最后访问 切换不同的列表(2014-10-09)
        $(document).delegate(".title", "click", function () {
            var r = $(this).closest(".room"), b = r.find(".item-box"), s = $(this).find("span:eq(0)");
            if (b.is(":hidden")) {
                $(".item-box").hide().each(function () {
                    $(this).closest(".room")
                            .find(".title")
                            .css({ "background-color": "rgba(255, 255, 255, 0.2)"})
                            .find("span:eq(0)")
                            .removeClass("triangle-right")
                            .removeClass("triangle-down")
                            .addClass("triangle-right");
                });
                $(this).css({"background-color": "#e5a639"});
                b.show();
                s.removeClass("triangle-right")
                 .addClass("triangle-down");
            }
            else {
                $(".item-box").hide().each(function () {
                    $(this).closest(".room")
                            .find(".title")
                            .css({ "background-color": "rgba(255, 255, 255, 0.2)" })
                            .find("span:eq(0)")
                            .removeClass("triangle-right")
                            .removeClass("triangle-down")
                            .addClass("triangle-right");
                });
                $(this).css({"background-color": "#e5a639"});
            }
        });

        // 收藏或者取消收藏
        $(document).delegate("span[rol='collect']", "click", function (e) {
            e.stopPropagation();
            var id = parseInt($(this).closest('.item').attr("roomid"));
            if ($(this).hasClass("active")) {
                that.removeFavorite(id);
            }
            else {
                that.addFavorite(id);
            }
        });

        // 删除收藏
        $(document).delegate("span[rol='delete']", "click", function (e) {
            e.stopPropagation();
            var id = parseInt($(this).closest('.item').attr("roomid"));
            if (id > 0) {
                that.removeFavorite(id);
            }
        });
        // 删除最近访问
        $(document).delegate("span[rol='delete_last_browse']", "click", function (e) {
            e.stopPropagation();
            var id = parseInt($(this).closest('.item').attr("roomid"));
            if (id > 0) {
                that.removeLastBrowse(id);
            }
        });

        /**
         * 1：鼠标进入房间项上之后显示收藏等状态按钮。
         * 2：判断房间是否被收藏。
         */
        $(document).delegate(".item", "mouseenter", function (e) {
            //e.stopPropagation();
            $(this).find(".action").show();

            var c = $(".context-menu-list");

            if (that.hall_ref.is_zone_saved($(this).attr("roomid"))) {
                $(this).find(".collect-normal-ico").removeClass("active").addClass("active");
                $(this).find(".collect-normal-ico").attr('title', '取消收藏');
                if (c.length > 0) {
                    c.children().eq(2).hide();
                    c.children().eq(3).show();
                }
            }
            else {
                $(this).find(".collect-normal-ico").attr('title', '加入收藏');
                if (c.length > 0) {
                    c.children().eq(2).show();
                    c.children().eq(3).hide();
                }
            }
        });

        // 1：鼠标离开房间项上之后隐藏收藏等状态按钮
        $(document).delegate(".item", "mouseleave", function (e) {
            //e.stopPropagation();
            $(this).find(".action").hide();
        });

        // 1：鼠标离开房间列表隐藏
        $(document).delegate(".room", "mouseleave", function (e) {
            e.stopPropagation();
            $(this).find(".item-box").css({"overflow": "hidden"});
        });
        // 1：进入房间列表显示
        $(document).delegate(".room", "mouseenter", function (e) {
            e.stopPropagation();
            $(this).find(".item-box").css({"overflow": "auto"});
        });
        // 1：鼠标离开房间列表隐藏
        $(document).delegate(".room-container", "mouseleave", function (e) {
            e.stopPropagation();
            $(this).find(".room-container").css({"overflow": "hidden"});
        });
        // 1：进入房间列表显示
        $(document).delegate(".room-container", "mouseenter", function (e) {
            e.stopPropagation();
            $(this).find(".room-container").css({"overflow": "auto"});
        });


        // 输入房间号码按回车查找进房
        $(document).delegate(".search input:first", "keydown", function (e) {
            var t = $(this).val();
            if (e.keyCode == 13) {
                if (that.isEmpty(t)) {
                    that.hall_ref.show_messagebox('输入的房间号为空!');
                } else {

                    if((t > 3200 && t < 3209) || (t > 3300 && t < 3309) || t == 32 || t == 3401){

                        that.hall_ref.show_messagebox('未找到此房间');
                    }
                    else{
                        that.findRoom(t);
                    }
                }
            }
            else {
                /**
                 *   8:  BackSpace  46: Delete  37: Left Arrow  39: Right Arrow  16: Shift  36: Home  35: End
                 */
                if (e.keyCode == 8
                        || e.keyCode == 46
                        || e.keyCode == 37
                        || e.keyCode == 39
                        || e.keyCode == 16
                        || e.keyCode == 36
                        || e.keyCode == 35
                        || e.ctrlKey && e.keyCode == 67
                        || e.ctrlKey && e.keyCode == 88) {
                    return true;
                }
                if (e.keyCode >= 48 && e.keyCode <= 57
                    || e.keyCode >= 96 && e.keyCode <= 105
                    || e.ctrlKey && e.keyCode == 86) {
                    setTimeout(function () {
                        var s = $(".search input:first");
                        var i = s.val();
                        var i = i.replace(/\D|^0/g, '');
                        if (i.length > 10) {
                            i = i.substr(0, 10);
                        }
                        s.val(i);
                    }, 2);
                    return true;
                } else {
                    return false;
                }
            }
        });

        // 输入房间号码按查找按钮查找进房
        $(document).delegate(".search span:first", "click", function () {
            var t = $(this).prev().val();
            if (that.isEmpty(t)) {
                that.hall_ref.show_messagebox('输入的房间号为空!');
            } else {
                that.findRoom(t);
            }
        });

        // 创建房间
        $(document).delegate(".title span:eq(2)", "click", function () {
            that.createRoom();
        });
        // 替换输入的汉字
        $(document).delegate(".search input:first", "input", function () {
            var reg = /^[0-9]*$/;
            var str = this.value;
            var flag = reg.test(str);
            if (flag == false) {
                var ww = str.replace(/\D+/g, "");
                this.value = ww;
                return false;
            }
        });

        // 点击查看未读信息 (message)
        $(document).delegate(".message_af", "click", function () {
            that.hall_ref.showunreadmsg(34);
        });
        $(".head-box > img").on("error", function(){
            var my_local_info = that.hall_ref.my_local_info();
            if (my_local_info.bUserSex == 1) {
                $(".head-box img:first").attr({src: "static/images/hall/pic.png"});
            }
            else {
                $(".head-box img:first").attr({src: "static/images/hall/female.png"});
            }
        });


        $(window).on("resize", function () {
            that.resizeListHeight();
            if (rsizePage()) {
                that.bindRecommendRoomsInfo();
                on_time_refeash_zonenum(_curRefeashNumTxt);
            }
            that.printLine();
        }).on("blur", function(){
            $("input").blur();
        });


    }

    // info list code st
    // common
    var curCol = 0
    var rsizePage = function(){
        var curItemWidth = 175;
        var winW = $(".main").width() - 20;
        var col = Math.floor( winW / curItemWidth );
        col > 6 && (col = 6)
        col < 2 && (col = 2)

        if (col == curCol)
            return false;


        curCol = col;


        $(".page").width(col * curItemWidth);
        var $itemEle = $(".box-hori-flex", ".page");
        $itemEle.css("visibility", "");
        var len = $itemEle.length;
        for (var i = 0, j = 0; i < len; i ++){
            if (i == col - 1 || i == col - 2 || i == col * 2 - 1 || i == col * 2 - 2){
                $itemEle.eq(i).css("visibility", "hidden");
                $itemEle.eq(i).find("[data-id]").each(function(){
                    $(this).attr("id","");
                })
            } else {
                $itemEle.eq(i).find("[data-id]").each(function(){
                    $(this).attr("id", $(this).attr("data-id").replace("{index}", j));
                })
                j++;
            }
        }

        return true;
    }

    self.printLine = function(){
        $(".split-line").remove();
        var cur =  $(".recommend-room-list > div").not(".box-hori-flex2");
        cur.eq(curCol  * 3).length && cur.eq( (curCol  * 3) - 1 ).after($("<div class='split-line'></div>").css({ width:curCol * 175 - 15 }))
    }

    self.appendItemForNum = function(num, cls, tips) {
        var html = new Array();
        var i = 0;
        while(num) {
            html.push('<div class="box-hori-flex'+ (cls ? "-"+cls : "")  +'">');
            if (i ++ > 8 && cls == 'dynamic') {
                html.push("   <div class='tips-icon' title='"+tips+"' style='display:none'></div>")
            } else
                html.push("   <div class='tips-icon' title='"+tips+"'></div>")
            html.push('    <div class="room-box item c-recommend-box" data-id="room-item-{index}" roomid="">');
            html.push('        <img class="image" data-id="recommend-item-img-{index}" style="width:164px;height:124px;" onerror="javascript:this.src=\'static/images/room.png\';" src="static/images/room.png" alt="">');
            html.push('            <!-- <span class="symbol amusement amusement-ico"></span> -->');
            html.push('            <div class="desc-amusement">');
            html.push('                <div>');
            html.push('                  <span class="id" data-id="recommend-item-id-{index}">ID:</span>');
            html.push('                  <span class="number">人数: <span data-id="recommend-item-number-{index}"></span></span>');
            html.push('              </div>');
            html.push('          </div>');
            html.push('          <div class="desc-amusement-hover">');
            html.push('              <span class="status amusement" data-id="recommend-status-id-{index}">进入房间</span>');
            html.push('              <span class="ad amusement name" data-id="recommend-hover-id-{index}"></span>');
            html.push('          </div>');
            html.push('      </div>');
            html.push('  </div>');
            num --;
        }

        $(".recommend-room-list").append(html.join(''))
    }
    // 推荐内容
    self.loadRecommendRoomsInfo = function(){
        this.appendItemForNum(12, "", "官方推荐");
    }
    //self.curRecommendRoomsInfo = [];
    self.bindRecommendRoomsInfo = function () {
        var count = this.hall_ref.get_publiczone_count();
        var zone_name;
        //this.curRecommendRoomsInfo = new Array();
        for (var i = 0; i < count; i++) {
            var info = this.hall_ref.get_publiczone_on_index(i);
            if (info && info.zoneid > 0) {
                var roomid = $("#room-item-" + i, ".box-hori-flex").attr("roomid");
                $("#room-item-" + i, ".box-hori-flex").removeClass("c-room-list-" + roomid).addClass("c-room-list-" + info.zoneid).attr("roomid", info.zoneid);
                $("#recommend-item-id-" + i, ".box-hori-flex").html("ID: " + info.zoneid);
                $("#recommend-item-number-" + i, ".box-hori-flex").html(info.number || 0).removeClass("c-room-list-" + roomid).addClass("c-room-list-number-" + info.zoneid);
                $("#recommend-item-img-" + i, ".box-hori-flex").removeClass("c-room-list-img-" + roomid).addClass("c-room-list-img-" + info.zoneid).attr("src", "file:///" + info.imagepath + "?t=" + Math.random());

                zone_name = this.trim(info.zonename);
                $("#recommend-hover-id-" + i, ".box-hori-flex").html(zone_name);
                $("#recommend-status-id-" + i, ".box-hori-flex").html("进入房间");
            } else {
                $("#recommend-status-id-" + i, ".box-hori-flex").html("");
            }
        }


    }

    // 视频房间
    self.bindVideoplayRoomsInfo = function(){
        var $box = $(".box-hori-flex:last", '.recommend-room-list');
        var i = 0;
        var len = this.hall_ref.get_videoplay_count();
        $(".k-room-box").remove();
        for (i = 0; i < len; i++) {
            var json = this.hall_ref.get_videoplay_index(i);
            $box.after(this.makePRoom(json.nick,
                json.groupname,
                json.number || json.get_usermun_onzone(json.zid),
                json.gid,
                json.zid,
                json.model,
                json.anchor));

            //alert($(".c-video-room-list-number-"+json.anchor).length)
        }
        this.printLine();
    }

    // 在线房间
    self.bindDynamiczoneRoomInfo = function(){
        var len = this.hall_ref.get_dynamiczone_count();
        $(".box-hori-flex-dynamic").remove()
        this.appendItemForNum(len, "dynamic", "人气推荐");
        $(".box-hori-flex-dynamic").each(function(i){
            $(this).find("[data-id]").each(function(){
                $(this).attr("id", $(this).attr("data-id").replace("{index}", i));
            });
        })

        for (var i = 0; i < len; i++) {
            var info = this.hall_ref.get_dynamiczone_index(i);
            if (info && info.zoneid > 0) {
                $("#room-item-" + i, ".box-hori-flex-dynamic").addClass("c-room-list-" + info.zoneid).attr("roomid", info.zoneid);
                $("#recommend-item-id-" + i, ".box-hori-flex-dynamic").html("ID: " + info.zoneid);
                $("#recommend-item-number-" + i, ".box-hori-flex-dynamic").text(info.number || 0).addClass("c-room-list-number-" + info.zoneid).addClass("c-room-list-number-dynamic");
                $("#recommend-item-img-" + i, ".box-hori-flex-dynamic").addClass("c-room-list-img-" + info.zoneid).attr("src", "file:///" + info.imagepath + "?t=" + Math.random());
                zone_name = this.trim(info.zonename);
                $("#recommend-hover-id-" + i, ".box-hori-flex-dynamic").html(zone_name);
                $("#recommend-status-id-" + i, ".box-hori-flex-dynamic").html("进入房间");
            } else {
                $("#recommend-status-id-" + i, ".box-hori-flex-dynamic").html("");
            }
        }
        this.printLine();
    }

    // info list code ed

    // 构造函数
    self.func(function(curData){
        var that = this;
        that.hall_ref = curData;
        this.sup().construct(curData);
        this.log_trace("进入大厅:");

        // 我的头像下周下载成功(异步通知)
        that.addCall("on_myheadimage_complete", function(imageUrl) {
            $(".head-box img:first").attr("src", "file:///" + imageUrl + "?t=" + Math.random());
        });

        // 房间图像下载成功通知(异步通知)
        that.addCall("on_roomimage_complete", function(id, imageUrl) {
            var room = $(".c-room-list-" + id,".room-list");
            //alert($(".c-room-list-100926").length)
            id == 35 && alert(imageUrl)//that.hall_ref.log_trace(imageUrl+"=================")
            room.find("img.image").attr("src", "file:///" + imageUrl + "?t=" + Math.random());
        });

        // 刷新官方推荐
        that.addCall("on_room_coverimage_complete", function(id, imageUrl) {
            $(".c-room-list-img-" + id, ".main").attr("src", "file:///" + imageUrl + "?t=" + Math.random());
        });
        // 房间收藏成功的通知(异步通知)  暂时取消了，不知道还要不
        that.addCall("on_zone_saved", function(id) {
            $(".c-room-list-" + id).each(function (i) {
                if ($(this)) {
                    $(this).find(".collect-normal-ico").addClass("active");
                    $(this).find(".collect-normal-ico").attr('title', '取消收藏');
                    if (i == 0) {
                        that.addFavoriteList(id);
                    }
                }
            });
        });

        // 房间已取消收藏成功的通知(异步通知) 暂时取消了，不知道还要不
        that.addCall("on_zone_unsaved", function(id) {
            $(".c-room-list-" + id).each(function (i) {
                if ($(this)) {
                    $(this).find(".collect-normal-ico").removeClass("active");
                    $(this).find(".collect-normal-ico").attr('title', '加入收藏');
                }
            });
            that.removeFavoriteList(id);
        });

        // 查找房间是否存在(异步回调通知)
        that.addCall("on_findzone_res", function(err_code) {
            if (err_code != 0) {
                /* 查找失败 */
                var err_msg = that.getErrorMessage(err_code);
            }
        });

        /* 进入房间是否成功(异步回调通知),成功追加历史记录,失败弹出框 */
        that.addCall("on_enterzone_res", function(err_code) {
            if (err_code != 0) {
                /* 进房失败 */
                var err_msg = that.getErrorMessage(err_code);
            }
        });

        // 点击创建房间按钮之后
        that.addCall("on_query_create_zone_res", function(err_code, err_msg) {
            if (err_code != 0) {
                //alert(err_msg);
            }
        });

        // 点击+创建房间成功后需要更新到我的房间里面（异步回调）(还没测试)
        that.addCall("on_update_myroom_list", function(room_id, room_name, room_desc, room_member, room_image) {
            decode_room_name = that.hall_ref.base64decode_string(room_name);
            that.addRoomList(room_id, decode_room_name, room_desc, room_member, room_image);
        });

        // 更新房间相关信息（异步回调）????
        that.addCall("on_update_myroom_info", function(room_id, room_name, room_desc, room_member, room_image) {
            decode_room_name = that.hall_ref.base64decode_string(room_name);
            var room = $(".c-room-list-" + room_id);
            var recommend = $("#recommend .c-room-list-" + room_id);
            room.find(".name").text(decode_room_name);
            recommend.find(".info .name").text(decode_room_name);
            room.find(".desc-lol-hover").hide();
            room.find(".desc-amusement-hover").hide();
            recommend.find(".desc-lol-hover").hide();
            recommend.find(".desc-amusement-hover").hide();
        });


        // 退出房间更新对应我的房间列表 (异步回调)
        that.addCall("on_delete_myroom", function(zoneid) {
            var my_zone = $("#my-zone-result .c-room-list-" + zoneid);
            var my_favorite = $("#my-favorite-result .c-room-list-" + zoneid);
            var last_browse = $("#last-browse-result .c-room-list-" + zoneid);
            my_zone.remove();
            my_favorite.remove();
            last_browse.remove();
        });


        // 进房成功追求历史记录
        that.addCall("on_insert_recently_list", function(err_code) {
            that.addLastBrowse();
        });

        // loading-mask 控制
        that.addCall("on_show_loading", function(bshow) {
            if (bshow == true) {
                that.hall_ref.enable_view = false;
                $(".loading-mask").show();
            } else {
                that.hall_ref.enable_view = true;
                $(".loading-mask").hide();
            }
        });

        // 更新等级积分(异步)
        that.addCall("update_score_grade", function(experience) {
            var c = $(".c-head-info");
            var level = parseInt(Math.sqrt(experience / 60));
            c.find('.Integral span:first').text("积分：" + parseInt(experience / 60));
            c.find('span:eq(1) strong').text(level);
        });

        // 获取服务器绝对路径地址
        that.addCall("get_server_addr", function(zoneid) {
            var str1 = "http://pic.5211game.com/images/recommend/";
            var str3 = zoneid + ".jpg";
            var z = "" + zoneid;
            var init = "000000000000";
            var val = init.substring(0, init.length - z.length) + z;
            var str2 = "";
            for (var i = 0; i < 4; i++) {
                str2 = str2 + val.substr(i * 3, 3) + "/";
            }
            return str1 + str2 + str3;
        });

        // message 房间底部
        that.addCall("msgflash", function(flag) {
            var i_flag = that.toInt(flag);
            var $m = $(".message");
            if (i_flag == 0) {
                $m.find("#infos").hide();
                $m.find(".anim").hide();
            }

            if (i_flag == 1) {
                $m.find("#infos").show();
                $m.find(".anim").hide();
            }

            if (i_flag == 2) {
                $m.find("#infos").show();
                $m.find(".anim").show();
            }
        });

        that.addCall("on_update_proom", function () {
           //that.loadPrivateRoom();
        });

        that.addCall("on_refresh_proom_num",function (anchor, num) {
            var $div = that.room_ref[anchor];
            if ($div) {
                $div.find('i').text(that.makeUserNumber(num));
            }
        });


        that.addCall("on_load_data",function() {
            /**
             * 此初始化数据必须是页面数据load绑定完之后才可以进行 此顺序勿动
             *
             * 初始化开始...
             */
            that.resizeListHeight();
            that.log_trace(that.hall_ref, "resizeListHeight time:", 0);
            /**
             * 初始化结束...
             */

            /* 绑定基础数据开始... */
            /*是否打印日志*/
            that.InitIntnetStatus();
            that.bindMyRoomsInfo();

            that.log_trace(that.hall_ref, "bindMyRoomsInfo time:", 0);
            that.bindLastBrowseRoomsInfo();
            that.log_trace(that.hall_ref, "bindLastBrowseRoomsInfo time:", 0);

            //(2014-10-09)
            that.showRoomList();
            that.bindUserInfo();
            that.log_trace(that.hall_ref, "bindUserInfo time:", 0);

            // Init主页内容块
            that.loadRecommendRoomsInfo();
            rsizePage();

            that.bindRecommendRoomsInfo();
            that.bindVideoplayRoomsInfo();

            that.bindDynamiczoneRoomInfo();
            that.printLine();

            that.log_trace(that.hall_ref, "bindRecommendRoomsInfo time:", 0);
            //that.loadPrivateRoom();


            /* 绑定基础数据结束... */
            /*开始加载iframe*/
            var $iframe = $("<iframe>");
            $iframe.attr("frameborder", "0")
                   .attr("scrolling", "no")
                   .css({
                        width:"338px",
                        height:"264px",
                        display:"block"
                    });
            $(".room-advert").html("").append($iframe)
            $(".room-advert iframe").attr({src: "http://pt.5211game.com/YuyinPlat/MainPage/v2/index.html"});
            /*加载iframe结束*/
            that.log_trace(hall, "iframe time :", 0);

            /* window.onload 是的时候 show() */
            $(".loading-mask").hide();
            that.hall_ref.enable_view = true;
            that.bindMyFavoritesInfo();
            that.log_trace(that.hall_ref, "bindMyFavoritesInfo time:", 0);
            return 1;
        });



        // item info list callback func
        that.addCall("update_recommendRooms_info", function(){
            that.bindRecommendRoomsInfo();
        })
        that.addCall("update_videoplay", function(){
            that.bindVideoplayRoomsInfo();
        });
        that.addCall("update_dynamiczone", function(){
            that.bindDynamiczoneRoomInfo();
        });

        // 定时刷房间人数数据.
        that.addCall("on_time_refeash_zonenum", function(text) {
            /* 待定 需要传入房间id和房间的人数 */
            if (that.isEmpty(text)) {
                return;
            }
            _curRefeashNumTxt = text;
            var arr = text.split("|").sort(function(a, b){
                var t1 = a.split(":");
                var t2 = b.split(":");

                return parseInt( t1[1] ) - parseInt( t2[1] );
            })
            arr.forEach(function (e) {
                var t = e.split(":");
                if (t.length == 2) {
                    that.setRoomOnline(t[0], t[1]);
                }
            });
//            $(".box-hori-flex-dynamic > .tips-icon").each(function(i){
//                if (i < 8){
//                    $(this).show();
//                } else
//                    $(this).hide();
//            })
            that.printLine();
        });
        // 定时刷在线视频房间人数数据.
        that.addCall("on_time_refeash_videoplay_groupnum", function(text) {
            /* 待定 需要传入房间id和房间的人数 */
            if (that.isEmpty(text)) {
                return;
            }

            text.split("|").forEach(function (e) {
                var t = e.split(":");

                if (t.length == 2) {
                    that.setVideoRoomOnline(t[0], t[1]);
                }
            });
            that.printLine();
        });

        this.initEvent();






    })
})
