Class(function(extend, using, self){

    extend("pages/page");
    using("lib/jquery.min.js");
    using("plugin/switchtab");

    var zoneid;
    var uid;
    self.room_ref = null;
    self.on_change = 0; // 用户点击确定按钮的时候如果传入参数 0 则不做处理 1 则做处理
    self.initPage = function() {
        this.log_trace(this.room_ref, "roomSet initPage  start");
        this.log_trace(this.room_ref, "roomSet bindRoomInfo  start");
        this.bindRoomInfo();
        this.log_trace(this.room_ref, "roomSet bindRoomInfo  end");

        $(".set-btn-box li").SwitchTab({// $('.newsBar a') 点击元素
            showObj: '.set-content', // 需显示的内容（必填项）
            mouseEvent: 'click', // 鼠标事件设定，默认：click
            currentClass: 'active', //当前tab class
            showEffect: "show"      // 默认show（无效果），fade（渐隐渐现）,slide（窗帘效果）
        });

        this.log_trace(this.room_ref, "roomSet iframe  start");
        zoneid = this.room_ref.get_room_info().zoneid;
        uid = this.room_ref.get_user_id();
        var weburl = this.room_ref.get_webaddress();
        var init_mem_url = weburl + "/plat/html/member.html?zoneid=" + zoneid;
        var init_lim_url = weburl + "/plat/html/limit.html?zoneid=" + zoneid;
        /*初始化iframe*/
        $(".c-admin-box1").html('<iframe frameborder="0" scrolling="no" style="width:421px;height:308px;display:block;"></iframe>');
        $(".c-admin-box1 iframe").attr({src: init_mem_url});
        $(".c-admin-box2").html('<iframe frameborder="0" scrolling="no" style="width:421px;height:308px;display:block;"></iframe>');
        $(".c-admin-box2 iframe").attr({src: init_lim_url});
        /*通过cookie获取管理员和黑名单*/
        var cookie = this.room_ref.on_cookie_mgrsetting();
        var srand=parseInt(Math.random()*10000);
        var key = "";
        var memurl = weburl + "/plat/login?ReturnUrl=" + encodeURIComponent(weburl + "/plat/html/member.html?zoneid=" + zoneid + "&key=" + key+"&srand="+srand) + "&uid="+uid+"&cookie="+cookie;
        var limurl = weburl + "/plat/login?ReturnUrl=" + encodeURIComponent(weburl + "/plat/html/limit.html?zoneid=" + zoneid+"&srand="+srand) + "&uid="+uid + "&cookie="+cookie;
        $(".c-admin-box2 iframe").attr({src: limurl});
        $(".c-admin-box1 iframe").attr({src: memurl});
        this.log_trace(this.room_ref, "roomSet iframe  end");
        /*  cookie获取管理员和黑名单结束  */
        this.room_ref.autologin_mgrreq("");//向接口传空值,下面配置管理员和黑名单URL
        this.room_ref.autologin_darklistreq(limurl);
        this.log_trace(this.room_ref, "roomSet initPage  end");

    }
    // 绑定房间信息
    self.bindRoomInfo = function() {
        var rows = $(".user-info");
        var room_info = this.room_ref.get_room_info();
        var img = $(".room-head-box img:first");
        var zonewelcome = $("textarea[name='c-person-text']");
        var one_row = rows.find("tr:eq(1)");
        var two_row = rows.find("tr:eq(2)");
        var three_row = rows.find("tr:eq(3)");
        var img_url = room_info.zoneimg;
        img.attr({src: "file:///" + img_url + "?t=" + Math.random()});
        one_row.find("td:eq(1) input").val(room_info.zonename);
        two_row.find("td:eq(1)").text(room_info.zoneid);
        two_row.find("td:eq(3)").text(parseInt(room_info.zoneexp / 1440));
        three_row.find("td:eq(1)").text(room_info.cardformat);
        zonewelcome.text(room_info.zonewelcome);
        get_room_collect_info();
    }
    // 加入收藏
    self.addFavorite = function() {
        this.room_ref.collect_room();
    }
    // 取消收藏
    self.removeFavorite = function() {
        this.room_ref.uncollect_room();
    }
    // 设置飞机票地址
    self.getAirplaneAddress = function() {
        this.room_ref.get_airplane_address();
    }
    // 设置应用的状态
    self.settingApply = function(apply_status) {
        if (apply_status) {
            $(".btn-box button:eq(2)").removeAttr("disabled").removeClass("disabled");
            this.on_change = 1;
        } else {
            $(".btn-box button:eq(2)").attr("disabled", "disabled").addClass("disabled");
            this.on_change = 0;
        }
    }

    self.initEvent = function(){
        var that = this;
        /*  收藏或者取消房间 */
        $(document).delegate("span[rol='collect']", "click", function(e) {
            //e.stopPropagation();
            if ($(this).hasClass("active")) {
                that.removeFavorite();
                $(".collect-normal-ico").attr('title', '加入收藏');
            }
            else {
                that.addFavorite();
                $(".collect-normal-ico").attr('title', '取消收藏');
            }
        });

        /* 更改按钮更改房间头像 */
        $(document).delegate(".set-box button:first", "click", function(e) {
            that.room_ref.btn_alter_image_click();
        });

        /*点击头像更改头像*/
        $(document).delegate(".set-box .room-head-box img:first", "click", function (e) {
            that.room_ref.btn_alter_image_click();
        });
        /*  获取飞机票地址 3s 后消失*/
        $(document).delegate("span[rol='air']", "click", function() {
            that.getAirplaneAddress();
            $(".tip").css('display', 'block');
            var t = setTimeout("display_dip()", 3000);
        });

        /*更改房间名称 更新应用按钮状态*/
        $(document).delegate("input[name='c-room-name']", "input", function() {
            if($(this).val().length > 0) {
                that.settingApply(true);
            } else {
                that.settingApply(false);
            }
        });

        /*更改个性签名 更新应用按钮状态*/
        $(document).delegate("textarea[name='c-person-text']", "input", function() {
            that.settingApply(true);
        });

        /*确定按钮*/
        $(document).delegate(".btn-box button:eq(0)", "click", function() {
            that.room_ref.btn_ok_click(that.on_change);
        });

        /*取消按钮*/
        $(document).delegate(".btn-box button:eq(1)", "click", function() {
            that.room_ref.btn_cancel_click();
        });

        /*应用按钮*/
        $(document).delegate(".btn-box button:eq(2)", "click", function() {
            that.settingApply(false);
            that.room_ref.btn_apply_click();
        });
    }

    self.func(function(curData){
        var that = this;
        /*查询房间收藏或者取消收藏 */
        that.addCall("get_room_collect_info", function() {
            var flag = that.room_ref.is_collected_room();
            if (flag) {
                $(".collect-normal-ico").addClass("active");
                $(".collect-normal-ico").attr('title', '取消收藏');
            } else {
                $(".collect-normal-ico").removeClass("active");
                $(".collect-normal-ico").attr('title', '加入收藏');
            }
        });

        /*管理员和黑名单*/
        that.addCall("on_autologin_mgrsetting", function() {
            var autourl = that.room_ref.get_automgr();
            if (that.isEmpty(autourl)) {
                return false;
            }
            var weburl = that.room_ref.get_webaddress();
            var key = autourl.substring(autourl.indexOf("encryptStr=") + 11, autourl.indexOf("&systemUrl="));
            var srand=parseInt(Math.random()*10000);
            var memurl = encodeURIComponent(weburl + "/plat/login?ReturnUrl=" + encodeURIComponent(weburl + "/plat/html/member.html?zoneid=" + zoneid + "&key=" + key+"&srand="+srand));
            var limurl = encodeURIComponent(weburl + "/plat/login?ReturnUrl=" + encodeURIComponent(weburl + "/plat/html/limit.html?zoneid=" + zoneid+"&srand="+srand));
            $(".c-admin-box1 iframe").attr({src: autourl + memurl});
            $(".c-admin-box2 iframe").attr({src: autourl + limurl});
            return true;
        });

        /* 更新房间头像(异步通知)*/
        that.addCall("on_update_roomimg_res", function(img_path) {
            $(".room-head-box img:first").attr({src: "file:///" + img_path + "?t=" + Math.random()});
        });

        /* loading-mask 控制*/
        that.addCall("on_show_loading", function(bshow) {
            if (bshow == true) {
                $(".mask").show();
            } else {
                $(".mask").hide();
            }
        });

        /* 提交房间更改信息*/
        that.addCall("send_room_info", function() {
            var rows = $(".user-info");
            var one_row = rows.find("tr:eq(1)");
            var three_row = rows.find("tr:eq(3)");
            var zonename = one_row.find("td:eq(1) input").val().replace(/\"/g, "\\\"").replace(/\'/g, "\'").replace(/\n/g, "\\n");
            var zonewelcome = $("textarea[name='c-person-text']").val().replace(/\"/g, "\\\"").replace(/\'/g, "\'").replace(/\n/g, "\\n");
            var cardformat = "";
            var roommode = $("#select_id").find("option:selected").val();
            var text = "{ \"zonename\":\"" + zonename + "\",\"zonewelcome\":\"" + zonewelcome + "\",\"cardformat\":\"" + cardformat + "\",\"roommode\":" + roommode + "}";
            return that.formatData(text);
        })

        that.addCall("on_save_roominfo", function(errorCode, error) {
        });

        that.addCall("on_collect_room_res", function(errorCode, error) {
            if (errorCode == 0) {
                $(".collect-normal-ico").addClass("active");
            }
        });
        that.addCall("on_uncollect_room_res", function(errorCode, error) {
            if (errorCode == 0) {
                $(".collect-normal-ico").removeClass("active");
            }
        });

        that.addCall("display_dip", function() {
            $(".tip").css('display', 'none');
        });

        that.addCall("on_autologin_darklistsetting", function() {
//            var autourl = that.room_ref.get_darkmgr();
//            $(".c-admin-box2 iframe").attr({src: autourl});
            return true;
        });

        that.room_ref = curData;//roominfomanager;

        that.sup().constructor(curData);

        that.initPage();
        that.initEvent();
    })
});