Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");

    self.message_ref = null;
    self.sum_num = 0;
    self.initPage = function () {
        this.bindMessageInfo();
    }
    self.bindMessageInfo = function () {
        var json_data = this.message_ref.getunreadmsg();
        var sum_nums = 0;
        if($(".content > ul > li").length > 0) {
            $(".content > ul > li").remove();
        }
        var d = this.formatData(json_data);
        $(d).each(function () {
            sum_nums = sum_nums + parseInt(this.num);
            var items = Array();
            items.push('<div class="left">');
            if(this.type == 2) {
                items.push('<div><span class="name" name="{{:name}}">房间广播 ( 来自 : {{:id}} )</span></div>');
            } else {
                items.push('<div><span class="name">{{:name}}</span></div>');
            }
            items.push('<div><span class="message">{{:lastmsg}}</span></div>');
            items.push('</div>');
            items.push('<div class="right">');
            items.push('<span class="number none" style="display:block;" rol_id="{{:id}}" rol_num="{{:number}}" rol_type="{{:type}}">{{:number}}</span>');
            items.push('<span class="view" rol_id="{{:id}}" style="display:none;" rol_num="{{:number}}" rol_type="{{:type}}"></span>');
            items.push('</div>');
            var text = items.join("").replace(/\{\{\:number\}\}/g, this.num).replace(/\{\{\:name\}\}/g, this.name).replace(/\{\{\:lastmsg\}\}/g, this.lastmsg).replace(/\{\{\:id\}\}/g, this.id).replace(/\{\{\:type\}\}/g, this.type);
            $('.content > ul').append("<li>" + text  + "</li>");
        });
        this.sum_num = sum_nums;
        this.message_ref.setCaption("未读消息 ( " + this.sum_num +" )");
    }

    self.initEvent = function(){
        var that = this;
        /*鼠标移动到信息*/
        $(document).delegate(".content ul > li", "mouseenter", function () {
            $(this).find(".number").hide();
            $(this).find(".view").show();
        });

        /*鼠标移开信息*/
        $(document).delegate(".content ul > li", "mouseleave", function () {
            $(this).find(".view").hide();
            $(this).find(".number").show();
        });

        /*点击view删除*/
        $(document).delegate(".view", "click", function (e) {
            e.stopPropagation();
            $(this).closest("li").remove();
            var type = $(this).attr("rol_type");
            var id = $(this).attr("rol_id");
            var number = $(this).attr("rol_num");
            that.sum_num = that.sum_num - number;
            that.message_ref.deleteonemsg(type,id);
            that.message_ref.setCaption("未读消息 ( " + that.sum_num +" )");
        });

        /*点击number查看*/
        $(document).delegate(".content ul > li", "click", function () {
            var type = $(this).find(".number").attr("rol_type");
            var id = $(this).find(".number").attr("rol_id");
            var number = $(this).attr("rol_num");
            that.message_ref.showonemsg( type, id);
            $(this).remove();
            that.sum_num = that.sum_num - number;
            that.message_ref.setCaption("未读消息 ( " + that.sum_num +" )");
        });

        /*点击忽略全部*/
        $(document).delegate(".btn-box span:eq(0)", "click", function () {
            $(".content > ul > li").remove();
            that.message_ref.clearallmsg();
            that.message_ref.setCaption("未读消息 ( 0 )");
        });

        /*点击忽略全部*/
        $(document).delegate(".btn-box span:eq(1)", "click", function () {
            that.message_ref.showallmsg();
            that.message_ref.setCaption("未读消息 ( 0 )");
        });
    }

    self.func(function(curData){
        var that = this;

        that.addCall("MessageNumChange", function(info) {
            that.bindMessageInfo();
        })
        that.message_ref = curData;//unreadmsg;

        that.sup().constructor(curData);
        that.initPage();
        that.initEvent();
    })
})

//Audio.MessageNonRead = Audio.MessageNonRead || {
//    message_ref: null,
//    sum_num:0,
//    initPage: function () {
//        Audio.MessageNonRead.bindMessageInfo();
//    },
//    bindMessageInfo: function () {
//        var json_data = Audio.MessageNonRead.message_ref.getunreadmsg();
//        var sum_nums = 0;
//        if($(".content > ul > li").length > 0) {
//            $(".content > ul > li").remove();
//        }
//        var d = Audio.formatData(json_data);
//        $(d).each(function () {
//            sum_nums = sum_nums + parseInt(this.num);
//            var items = Array();
//            items.push('<div class="left">');
//            if(this.type == 2) {
//                items.push('<div><span class="name" name="{{:name}}">房间广播 ( 来自 : {{:id}} )</span></div>');
//            } else {
//                items.push('<div><span class="name">{{:name}}</span></div>');
//            }
//            items.push('<div><span class="message">{{:lastmsg}}</span></div>');
//            items.push('</div>');
//            items.push('<div class="right">');
//            items.push('<span class="number none" style="display:block;" rol_id="{{:id}}" rol_num="{{:number}}" rol_type="{{:type}}">{{:number}}</span>');
//            items.push('<span class="view" rol_id="{{:id}}" style="display:none;" rol_num="{{:number}}" rol_type="{{:type}}"></span>');
//            items.push('</div>');
//            var text = items.join("").replace(/\{\{\:number\}\}/g, this.num).replace(/\{\{\:name\}\}/g, this.name).replace(/\{\{\:lastmsg\}\}/g, this.lastmsg).replace(/\{\{\:id\}\}/g, this.id).replace(/\{\{\:type\}\}/g, this.type);
//            $('.content > ul').append("<li>" + text  + "</li>");
//        });
//        Audio.MessageNonRead.sum_num = sum_nums;
//        Audio.MessageNonRead.message_ref.setCaption("未读消息 ( " + Audio.MessageNonRead.sum_num +" )");
//    }
//};

//function MessageNumChange(info) {
//    Audio.MessageNonRead.bindMessageInfo();
//}
//
//
//
//(function () {
//
//    /*鼠标移动到信息*/
//    $(document).delegate(".content ul > li", "mouseenter", function () {
//        $(this).find(".number").hide();
//        $(this).find(".view").show();
//    });
//
//    /*鼠标移开信息*/
//    $(document).delegate(".content ul > li", "mouseleave", function () {
//        $(this).find(".view").hide();
//        $(this).find(".number").show();
//    });
//
//    /*点击view删除*/
//    $(document).delegate(".view", "click", function (e) {
//        e.stopPropagation();
//        $(this).closest("li").remove();
//        var type = $(this).attr("rol_type");
//        var id = $(this).attr("rol_id");
//        var number = $(this).attr("rol_num");
//        Audio.MessageNonRead.sum_num = Audio.MessageNonRead.sum_num - number;
//        Audio.MessageNonRead.message_ref.deleteonemsg(type,id);
//        Audio.MessageNonRead.message_ref.setCaption("未读消息 ( " + Audio.MessageNonRead.sum_num +" )");
//    });
//
//    /*点击number查看*/
//    $(document).delegate(".content ul > li", "click", function () {
//        var type = $(this).find(".number").attr("rol_type");
//        var id = $(this).find(".number").attr("rol_id");
//        var number = $(this).attr("rol_num");
//        Audio.MessageNonRead.message_ref.showonemsg( type, id);
//        $(this).remove();
//        Audio.MessageNonRead.sum_num = Audio.MessageNonRead.sum_num - number;
//        Audio.MessageNonRead.message_ref.setCaption("未读消息 ( " + Audio.MessageNonRead.sum_num +" )");
//    });
//
//    /*点击忽略全部*/
//    $(document).delegate(".btn-box span:eq(0)", "click", function () {
//        $(".content > ul > li").remove();
//        Audio.MessageNonRead.message_ref.clearallmsg();
//        Audio.MessageNonRead.message_ref.setCaption("未读消息 ( 0 )");
//    });
//
//    /*点击忽略全部*/
//    $(document).delegate(".btn-box span:eq(1)", "click", function () {
//        Audio.MessageNonRead.message_ref.showallmsg();
//        Audio.MessageNonRead.message_ref.setCaption("未读消息 ( 0 )");
//    });
//})();

//window.onload = function () { Audio.MessageNonRead.message_ref = unreadmsg;  Audio.MessageNonRead.initPage(); }
