Class(function(extend, using, self){

    extend("pages/page");
    using("lib/jquery.min.js");
    self.cast_ref = null;
    self.imageInfos = null;

    self.initImageInfos = function () {
        this.imageInfos = [];
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_bizui', '/bizui');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_ziya', '/ziya');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_ziya', '/ciya');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_fendou', '/fendou');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_fennu', '/fennu');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_haixiu', '/haixiu');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_jingkong', '/jingkong');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_kun', '/kun');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_liuhan', '/liuhan');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_liulei', '/liulei');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_nankan', '/nankan');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_nanguo', '/nanguo');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_qinqin', '/qinqin');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_semimi', '/semimi');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shuai', '/shuai');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shuashuai', '/shuashuai');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_tiaopi', '/tiaopi');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_touxiao', '/touxiao');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_koubi', '/koubi');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_weixiao', '/weixiao');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_tu', '/tu');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_yiwen', '/yiwen');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_yun', '/yun');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_zaijian', '/zaijian');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_zhouma', '/zhouma');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_bishi', '/bishi');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_dabing', '/dabing');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_fadai', '/fadai');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_huaixiao', '/huaixiao');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shangxin', '/shangxin');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_jiayou', '/jiayou');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_keai', '/keai');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_jingya', '/jingya');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_kelian', '/kelian');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_qiaoda', '/qiaoda');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shuijiao', '/shuijiao');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_weiqu', '/weiqu');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_yinxian', '/yinxian');
        this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_zhuakuang', '/zhuakuang');
    }
    self.imageInfo = function (name, tag) {
        this.name = name;
        this.tag = tag;
    }
    self.formatDataUrlEmation = function (text) {
        /*处理格式化，图片链接*/
        var arr = [];
        var c = this;
        var str;
        var i;
        var info;
        var reg = /<a gid=\"([0-9]*)\" (.*)(href|herf)=\"ghop\">(.*)<\/a>+/g;
        if (text.indexOf('gid') >= 0) {
            str = text;
            info = str.match(reg);
            if (info !== null) {
                for (i = 0; i < info.length; i++) {
                    arr[i] = info[i];
                    text = text.replace(info[i], "{i*n*r}" + i);
                }
            }
        }

        text = this.encodeHTML(text).replace(/\n/g, "</br>").replace(/\s/g, "&nbsp;");
        if (arr.length > 0) {
            for (i = 0; i < arr.length; i++) {
                text = text.replace("{i * n * r}" + i, arr[i]);
            }
        }
        text = c.formatUrl(text);
        if (text.indexOf('/') >= 0) {
            text = c.formatShortToImage(text);
        }
        return text;
        /*格式化，图片链接处理结束*/
    }
    /* 格式化占位符为图片名称 */
    self.formatShortToImage = function (text) {
        for (var i = 0; i < this.imageInfos.length; i++) {
            text = text.replace(new RegExp(this.imageInfos[i].tag, "gi"), '<img src="static/images/def/' + this.imageInfos[i].name + '.gif">');
        }
        return text;
    }
    /* 格式化超链接 */
    self.formatUrl = function (text) {
        return this.cast_ref.auto_detect_url(text);
    }

    self.initPage = function () {
        this.initImageInfos();
    }

    self.initEvent = function(){
        var that = this;
        /* 用户点击房间超链接 进入 */
        $(document).delegate("a[href='ghop']", "click", function (e) {
            e.stopPropagation();
            var type = $(this).attr("type");
            if (type == "recruit") {
                that.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 1);
            }
            if (type == "jump" || type == undefined) {
                that.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 0);
            }
        });

        /* 用户点击房间超链接 进入 */
        $(document).delegate("a[herf='ghop']", "click", function (e) {
            e.stopPropagation();
            var type = $(this).attr("type");
            if (type == "recruit") {
                that.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 1);
            }
            if (type == "jump" || type == undefined) {
                that.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 0);
            }
        });
    }

    self.func(function(data) {
        var that = this;
        that.addCall("get_identity_img", function(identity_val) {
            var str = "";
            switch (identity_val) {
                case 0:
                    str = "static/images/role/1_19.png";
                    break;
                case 1:
                    str = "static/images/role/1_13.png";
                    break;
                case 4:
                    str = "static/images/role/1_09.png";
                    break;
                case 6:
                    str = "static/images/role/1_07.png";
                    break;
                case 8:
                    str = "static/images/role/1_05.png";
                    break;
                case 16:
                    str = "static/images/role/1_03.png";
                    break;
                case 128:
                    str = "static/images/role/1_01.png";
                    break;
            }
            return str;
        });

        // 房间广播时间显示规则：使用相对时间x，即阅读时间距离发送时间的差值
        // X＜3分钟  显示 “刚刚”
        // 3分钟≤X＜60分钟 显示“**分钟前”
        // 60分钟≤X＜24小时 显示“**小时前”
        // 24≤X    显示“**天前”
        that.addCall("setTime", function(time){
            var $time = $('#time');
            var text = '刚刚';
            var second = new Date()/1000 - time;
            var minute = Math.floor(second / 60);
            if(minute >= 3 && minute < 60){
                text = minute + '分钟前';
            }
            if(minute >= 60 && minute < 1440){
                text = Math.floor(minute / 60) + '小时前';
            }
            if(minute >= 1440){
                text = Math.floor(minute / 1440) + '天前';
            }
            $time.text(text);
        });

        that.addCall("startTimer", function(time){
            time = +time;
            setTime(time);
            setInterval(function(){
                setTime(time);
            } ,10000);
        });

        that.cast_ref = data;

        that.sup().constructor(data)

        that.initPage();
        that.initEvent();


        var send, content, zoonid, identity, img_str;
        send = that.cast_ref.getsender();
        content = that.cast_ref.getcontent();
        content = that.formatDataUrlEmation(content);
        img_str = that.cast_ref.getidentityimg();
        zoonid = that.cast_ref.getzoomid();
        $(".send_name").text(send);
        $(".message").append(content);
        //img_str = get_identity_img(identity);
        $(".send_image").attr("src", "static/images/role/" + img_str);
        startTimer(that.cast_ref.get_time());
        that.cast_ref.setCaption("房间广播( 来自:" + zoonid + ")");

    });
});
//
//(function () {
//  window.Audio.BorderCastMsg = Audio.BorderCastMsg || {
//    cast_ref: null,
//    imageInfos: null,
//    initImageInfos: function () {
//      this.imageInfos = [];
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_bizui', '/bizui');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_ziya', '/ziya');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_ziya', '/ciya');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_fendou', '/fendou');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_fennu', '/fennu');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_haixiu', '/haixiu');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_jingkong', '/jingkong');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_kun', '/kun');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_liuhan', '/liuhan');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_liulei', '/liulei');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_nankan', '/nankan');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_nanguo', '/nanguo');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_qinqin', '/qinqin');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_semimi', '/semimi');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shuai', '/shuai');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shuashuai', '/shuashuai');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_tiaopi', '/tiaopi');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_touxiao', '/touxiao');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_koubi', '/koubi');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_weixiao', '/weixiao');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_tu', '/tu');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_yiwen', '/yiwen');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_yun', '/yun');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_zaijian', '/zaijian');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_zhouma', '/zhouma');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_bishi', '/bishi');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_dabing', '/dabing');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_fadai', '/fadai');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_huaixiao', '/huaixiao');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shangxin', '/shangxin');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_jiayou', '/jiayou');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_keai', '/keai');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_jingya', '/jingya');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_kelian', '/kelian');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_qiaoda', '/qiaoda');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_shuijiao', '/shuijiao');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_weiqu', '/weiqu');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_yinxian', '/yinxian');
//      this.imageInfos[this.imageInfos.length] = new this.imageInfo('def_zhuakuang', '/zhuakuang');
//    },
//    imageInfo: function (name, tag) {
//      this.name = name;
//      this.tag = tag;
//    },
//    formatDataUrlEmation: function (text) {
//      /*处理格式化，图片链接*/
//      var arr = [];
//      var c = Audio.BorderCastMsg;
//      var str;
//      var i;
//      var info;
//      var reg = /<a gid=\"([0-9]*)\" (.*)(href|herf)=\"ghop\">(.*)<\/a>+/g;
//      if (text.indexOf('gid') >= 0) {
//        str = text;
//        info = str.match(reg);
//        if (info !== null) {
//          for (i = 0; i < info.length; i++) {
//            arr[i] = info[i];
//            text = text.replace(info[i], "{i*n*r}" + i);
//          }
//        }
//      }
//
//      text = Audio.encodeHTML(text).replace(/\n/g, "</br>").replace(/\s/g, "&nbsp;");
//      if (arr.length > 0) {
//        for (i = 0; i < arr.length; i++) {
//          text = text.replace("{i*n*r}" + i, arr[i]);
//        }
//      }
//      text = c.formatUrl(text);
//      if (text.indexOf('/') >= 0) {
//        text = c.formatShortToImage(text);
//      }
//      return text;
//      /*格式化，图片链接处理结束*/
//    }, /* 格式化占位符为图片名称 */
//    formatShortToImage: function (text) {
//      for (var i = 0; i < this.imageInfos.length; i++) {
//        text = text.replace(new RegExp(this.imageInfos[i].tag, "gi"), '<img src="images/def/' + this.imageInfos[i].name + '.gif">');
//      }
//      return text;
//    }, /* 格式化超链接 */
//    formatUrl: function (text) {
//      return this.cast_ref.auto_detect_url(text);
//    },
//    initPage: function () {
//      this.initImageInfos();
//    }
//  };
//  /* 用户点击房间超链接 进入 */
//  $(document).delegate("a[href='ghop']", "click", function (e) {
//    e.stopPropagation();
//    var type = $(this).attr("type");
//    if (type == "recruit") {
//      Audio.BorderCastMsg.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 1);
//    }
//    if (type == "jump" || type == undefined) {
//      Audio.BorderCastMsg.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 0);
//    }
//  });
//
//  /* 用户点击房间超链接 进入 */
//  $(document).delegate("a[herf='ghop']", "click", function (e) {
//    e.stopPropagation();
//    var type = $(this).attr("type");
//    if (type == "recruit") {
//      Audio.BorderCastMsg.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 1);
//    }
//    if (type == "jump" || type == undefined) {
//      Audio.BorderCastMsg.cast_ref.enter_another_group($(this).attr('zid'), $(this).attr('gid'), 0);
//    }
//  });
//
//  function get_identity_img(identity_val) {
//    var str = "";
//    switch (identity_val) {
//      case 0:
//        str = "images/role/1_19.png";
//        break;
//      case 1:
//        str = "images/role/1_13.png";
//        break;
//      case 4:
//        str = "images/role/1_09.png";
//        break;
//      case 6:
//        str = "images/role/1_07.png";
//        break;
//      case 8:
//        str = "images/role/1_05.png";
//        break;
//      case 16:
//        str = "images/role/1_03.png";
//        break;
//      case 128:
//        str = "images/role/1_01.png";
//        break;
//    }
//    return str;
//  }
//
//  // 房间广播时间显示规则：使用相对时间x，即阅读时间距离发送时间的差值
//  // X＜3分钟  显示 “刚刚”
//  // 3分钟≤X＜60分钟 显示“**分钟前”
//  // 60分钟≤X＜24小时 显示“**小时前”
//  // 24≤X    显示“**天前”
//  function setTime(time){
//    var $time = $('#time');
//    var text = '刚刚';
//    var second = new Date()/1000 - time;
//    var minute = Math.floor(second / 60);
//    if(minute >= 3 && minute < 60){
//      text = minute + '分钟前';
//    }
//    if(minute >= 60 && minute < 1440){
//      text = Math.floor(minute / 60) + '小时前';
//    }
//    if(minute >= 1440){
//      text = Math.floor(minute / 1440) + '天前';
//    }
//    $time.text(text);
//  }
//
//  function startTimer(time){
//    time = +time;
//    setTime(time);
//    setInterval(function(){
//      setTime(time);
//    } ,10000);
//  }
//
//  window.onload = function () {
//    Audio.BorderCastMsg.cast_ref = broadcastinfo;
//    Audio.BorderCastMsg.initPage();
//    var send, content, zoonid, identity, img_str;
//    send = Audio.BorderCastMsg.cast_ref.getsender();
//    content = Audio.BorderCastMsg.cast_ref.getcontent();
//    content = Audio.BorderCastMsg.formatDataUrlEmation(content);
//    img_str = Audio.BorderCastMsg.cast_ref.getidentityimg();
//    zoonid = Audio.BorderCastMsg.cast_ref.getzoomid();
//    $(".send_name").text(send);
//    $(".message").append(content);
//    //img_str = get_identity_img(identity);
//    $(".send_image").attr("src", "images/role/" + img_str);
//    startTimer(broadcastinfo.get_time());
//    Audio.BorderCastMsg.cast_ref.setCaption("房间广播( 来自:" + zoonid + ")");
//  };
//
//
//})();

