/**
 * @author pei-qiao.peng
 * @date   2015/1/5.
 * @email  ppq1991@gmail.com
 * @github https://github.com/ppq1991/
 * @blog   http://pengpeiqiao.tk/
 */

Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");
    // define

    var $document = $(document);
    var $award = $('#div-award');
    var $box = $('.popup-Box');
    var $sign = $(".user-sign-info");
    var $flower = $(".card-flower-number");
    var $lvl = $(".user-mic-level");
    var $upgrade = $(".user-mic-upgrade-level");
    var $nick = $(".user-nickname");
    var $locationIco = $(".user-location-button");
    var $location = $(".user-location");
    var $micTime = $(".user-mic-times");
    var $report = $(".card-report-info");
    var $offMic = $(".nonWheat");
    var $offMicBg = $offMic.find('.microphone');
    var $offMicContent = $offMic.find('.content');
    //var $offMicDesc = $offMic.find('.desc');
    var $offMicBtn = $(".content .lv1 button");
    var $onMic = $(".onWheat");
    //var $freeMicBg = $(".user-set-header");
    var $emptyMicBg = $(".user-default-header");
    var $slideBox = $('#slide-box');
    var Slide = {};
    var isReport = false;
    var cache_bg = '';

    Slide = {
        data: [],
        index: 0,
        isHover: false,
        timer: 0,
        ref: [],
        load: function (imgs) {
            if (imgs && imgs.length > 0) {
                this.init();
                this.data = imgs;
                for (var i = 0, len = imgs.length; i < len; i++) {
                    this.ref[i] = $('<img>').addClass('avatar').attr('src', imgs[i].path);
                    $slideBox.prepend(this.ref[i]);
                }
                $slideBox.find('.avatar').hide();
                this.playTo(0);
            } else {
                this.clear();
            }
        },
        clear: function () {
            this.data = [];
            $slideBox.find('.avatar').remove();
            $emptyMicBg.show();
        },
        init: function () {
            $slideBox.find('img').hide();
            $slideBox.find('.avatar').remove();
            this.index = 0;
            this.startTimer();
        },
        startTimer: function () {
            var that = this;
            clearInterval(this.timer);
            this.timer = setInterval(function () {
                that.autoPlay();
            }, 6000);
        },
        hoverListener: function () {
            var that = this;
            $slideBox.on('mouseenter', function () {
                that.isHover = true;
            });
            $slideBox.on('mouseleave', function () {
                that.isHover = false;
            });
        },
        autoPlay: function () {
            if (this.data.length > 1 && !this.isHover) {
                this.playTo(this.index + 1);
            }
        },
        playTo: function (n) {
            if (n >= this.data.length) {
                n = 0;
            }
            this.ref[this.index].fadeOut();
            this.ref[n].fadeIn();
            this.index = n;
        },
        getCurrentIndex: function () {
            return this.data[this.index].index;
        },
        getCurrentUrl: function () {
            return this.data[this.index].path;
        }
    };
    self.card_ref = null;
    self.initEvent = function(){
        var that = this;
        $document.on("click", ".card-report-info", function () {
            if (isReport) {
                that.card_ref.report(Slide.getCurrentIndex(), Slide.getCurrentUrl());
            }
        });

        $document.on("click", ".user-enter-mic", function () {
            if (!$(this).hasClass('disabled')) {
                that.card_ref.reqmic();
            }
        });
    }

    self.func(function(curData){

        this.sup().constructor(curData);

        this.card_ref = curData;

        this.addCall("onload", function () {
            Slide.hoverListener();
        });

        // api
        this.addCall("on_set_user_award", function (src, tip) {
            if (src) {
                addAward(src, tip);
            } else {
                clearAward();
            }
        })

        this.addCall("on_set_user_backgroud", function (src) {
            if (src) {
                if (src !== cache_bg) {
                    cache_bg = src;
                    $box.css('background-image', 'url("file:///' + src + '")');
                }
            } else {
                $box.css('background-image', '');
                cache_bg = src;
            }
        });

        this.addCall("on_set_user_sign", function (sign) {
            $sign.html($('<div>').text(sign).html().replace(/\s/g, "&nbsp;"));
        });

        this.addCall("on_set_flower", function (number) {
            $flower.text(number);
        })

        this.addCall("on_set_user_mic_level", function (level) {
            if (level > 0) {
                $lvl.text(level);
            }
        });

        this.addCall("on_set_user_mic_level_tips" , function (level, exp) {
            var title;
            if (level === 0) {
                title = "等级数据正在获取中...";
            } else {
                title = "当前等级：" + level + "，升级还需" + exp + "经验";
            }
            $upgrade.attr("title", title);
        });

        this.addCall("on_set_user_nick_name" , function (name) {
            $nick.text(name);
        });

        this.addCall("on_set_user_location", function (location) {
            var city = "";
            if (location) {
                var citys = location.split(" ");
				
				if (city.length == 0){
					city = location;
				}
                if (citys.length >= 2) {
                    city = citys[1];
                }
                if (citys.length === 3) {
                    if (citys[1] !== citys[2]) {
                        city = city + " " + citys[2];
                    }
                }
            }
            if (city) {
                $locationIco.show();
                $location.text(replaceLongCityName(city));
            }
            else {
                $locationIco.hide();
            }
        });

        this.addCall("on_set_mic_times" , function (times) {
            $micTime.text(times + "s");
        });

        this.addCall("on_set_report_status" , function (status) {
            isReport = status;
            if (status) {
                $report.show();
            } else {
                $report.hide();
            }
        });

        this.addCall("on_set_images" , function (item) {
            var imgs = [];
            if (item) {
                var index = 0, path = "", image = "", images = item.split("|");
                for (var i = 0; i < images.length; i++) {
                    image = images[i].split("+");
                    if (image.length === 2) {
                        index = parseInt(image[0]);
                        path = "file:///" + image[1];
                        imgs.push({'index': index, 'path': path});
                    }
                }
                //Audio.Card.loopPlay(imgs);
                Slide.load(imgs);
            }
            else {
                //Audio.Card.showDefault();
                Slide.clear();
            }
        });

        /* 自由模式下 */
        this.addCall("on_set_free_mic", function () {
            initMic();
            $offMic.show();
            $offMicBg.addClass('free-mic-mode-background');
            $offMicContent.hide();
            //$offMicDesc.text("名片只在麦序模式下显示！");
        });

        /* 麦序模式 无人上麦 */
        this.addCall("on_set_nobody", function () {
            initMic();
            $offMic.show();
            $offMicContent.show();
            //$offMicDesc.text("当前麦上无人，机不可失哦！");
            $offMicBtn.removeClass("disabled");
        });

        /* 麦序模式 禁麦 */
        this.addCall("on_set_forbid_mic", function () {
            initMic();
            $offMic.show();
            $offMicContent.show();
            //$offMicDesc.text("当前麦上无人，机不可失哦！");
            $offMicBtn.addClass("disabled");
        })

        /* 麦序模式 已经上麦 */
        this.addCall("on_set_use_mic", function () {
            $onMic.show();
            $offMic.fadeOut();
        });

        /* 进入动画 */
        this.addCall("on_load_animation", function (n) {
            var temp = $('body');
            n = n || 500;
            temp.css({
                position: 'relative',
                top: '-245px'
            }).animate({
                top: 0
            }, n);
        });

        this.addCall("addAward", function(src, tip) {
            $award.append($('<img>').attr('src', 'file:///' + src).attr('title', tip));
        });

        this.addCall("clearAward", function() {
            $award.html('');
        });

        this.addCall("replaceLongCityName", function(a) {
            return a.replace(/中国/g, "").replace(/特别行政区/g, "").replace(/自治区/g, "").replace(/壮族/g, "").replace(/回族/g, "").replace(/维吾尔族/g, "").replace(/省/g, "").replace(/市/g, "").replace(/县/g, "");
        });

        this.addCall("initMic", function() {
            $offMic.hide();
            $offMicBg.removeClass('free-mic-mode-background');
            //$offMicContent.hide();
            $onMic.hide();
        });

        this.initEvent();
    });

});
