/**
 * @author pei-qiao.peng
 * @date   2015/1/15.
 * @email  ppq1991@gmail.com
 * @github https://github.com/ppq1991/
 * @blog   http://pengpeiqiao.tk/
 */

Class(function (extend, using, self) {
  'use strict';
  extend("pages/page");
  using("lib/jquery.min.js");

  var core = using('pages/chat/core').New();
  var model = using('pages/chat/msgFormat').New();
  var fontStyle = using('pages/chat/font-style').New();
  var dfa = using('pages/chat/dfa').New();
  var $chat = $('#chat-container');
  var $btnSend = $('#btn-send');
  var isBtnEnabled = true;
  core.bind($chat);


  // API
  window.on_recv_msg = function (t, m) {
    m = JSON.parse(decodeURIComponent(m));
    if (t === 0 || t === '0') {
      core.add(model.getPmMsg(m));
    }
    if (t == 1) {
      core.add(model.getSysMsg(m.iconindex, m.rgbvalue, m.content));
    }
  };
  window.on_enter_send_msg = function () {
    if(isBtnEnabled){
      var msg = window.inputbox.get_text_clear();
      var json = fontStyle.getStyle();

      if (msg) {
        core.lock(false);
        window.privatechat.send_msg(json, msg);
      }
    }
  };
  window.on_expand_inputbox = function (n) {
    core.setInputBoxHeight(n);
  };
  window.on_page_close = function(){
    core.clear();
    core.lock(false);
  };
  window.insert_content_richedit = function(html){
    dfa.run(window.privatechat.base64_decode(html));
  };
  window.on_enable_btn = function(isEnabled){
    isBtnEnabled = isEnabled;
    if(isEnabled){
      $btnSend.removeClass('disabled');
    }else{
      $btnSend.addClass('disabled');
    }
  };

  // listener
  $btnSend.click(function(){
    if(!$(this).hasClass('disabled')){
      window.on_enter_send_msg();
    }
  });

  window.on_process_key_up = function(){

  };

  window.on_process_key_down = function(){

  };

  // functions

  function pageInit() {
    core.init();
    fontStyle.run(window.privatechat);
    dfa.bindQT(window.privatechat);
    window.privatechat.notify_web_finished();
    window.inputbox.set_hinttext("请输入聊天内容(按Ctrl+Enter换行)");
  }

  self.func(function(){
      pageInit();
  })

});