﻿/**
 * @author pei-qiao.peng
 * @date   2015/1/15.
 * @email  ppq1991@gmail.com
 * @github https://github.com/ppq1991/
 * @blog   http://pengpeiqiao.tk/
 */

Class(function (extend, using, self) {
    'use strict';

    extend("pages/page");
    using("lib/jquery.min.js");

    var core = using('pages/chat/core').New();
    var model = using('pages/chat/msgFormat').New();
    var fontStyle = using('pages/chat/font-style').New();
    var broadcast = using('pages/chat/broadcast').New($('#broadcast-box'), window.chat);
    var dfa = using('pages/chat/dfa').New();

    var cache = using('pages/chat/cache').New();

    var $chat = $('#chat-container');
    var $btnClear = $('#btn-clear');
    var $btnSend = $('#btn-send');
    var isBtnEnabled = true;

    core.bind($chat);
    using('pages/chat/drag').New().run();
    using('pages/chat/flower').New().run();

    $(window).load(function () {
        pageInit();
    });

    // API
    window.on_recv_msg = function (t, m) {
        m = JSON.parse(decodeURIComponent(m));
        if (t === 0 || t === '0') {
            core.add(model.getUserMsg(m));
        }
        if (t == 1) {
            core.add(model.getSysMsg(m.iconindex, m.rgbvalue, m.content));
        }
    };

    window.on_enter_send_msg = function () {
        if (isBtnEnabled) {
            var msg = window.inputbox.get_text_clear();
            var json = fontStyle.getStyle();
            if (msg) {
                addCache(msg);
                core.lock(false);
                window.chat.send_msg(json, msg);
            }
        }
//        core.add(model.getFlowerMsg({
//            giftnum:1,
//            identityimg:"",
//            text:"",
//            userid:"",
//            giftwidth:"",
//            giftheight:"",
//            username:"kslong",
//            gift : "E:\\11Platform\\11Audio\\client(QT)\\bin\\debug\webres\\1005.swf"
//        }))

    };

    window.send_connectmic_confirm = function (content) {
        content = JSON.parse(decodeURIComponent(content));
        core.add(model.getconcatMicMsg(content.name, content.cookie))
    }

    window.on_expand_inputbox = function (n) {
        core.setInputBoxHeight(n);
    };

    window.on_page_close = function () {
        core.clear();
        core.lock(false);
        clearCache();
    };
    var track = [];
    window.anchorRecvFlowerNumsChanged = function (json) {
        var s = decodeURIComponent(json);
        if (s) {
            core.add(model.getFlowerMsg(JSON.parse(s)));
        }
    };

    window.onrecv_flashgift = function(){
        var list = decodeURIComponent(logic.getflashgiftchrunk());
        if (list) {
            list = JSON.parse("["+list+"]");
            for(var i = 0; i < list.length; i ++)
                core.add(model.getFlowerMsg(list[i]));
        }
    }

    window.insert_content_richedit = function (html) {
        dfa.run(window.chat.base64_decode(html));
    };

    window.on_recv_broadcast = function (msg) {
        broadcast.show(msg);
    };

    window.on_enable_btn = function (isEnabled) {
        isBtnEnabled = isEnabled;
        if (isEnabled) {
            $btnSend.removeClass('disabled');
        } else {
            $btnSend.addClass('disabled');
        }
    };
    window.enable_connectmic = function (cookie, enable) {
        $("[cookie='" + cookie + "'] > span").each(function () {
            enable && $(this).removeClass("disabled").addClass("enable");
            !enable && $(this).removeClass("enable").addClass("disabled");
        })
    }

    // concat mic
    $("#chat-container").delegate(".concatMic_ok", "click", function () {
        var cookie = $(this).parent("div").attr("cookie");
        window.chat.connectmic_confirm(true, cookie)
        enable_connectmic(cookie, false)
    }).delegate(".concatMic_cancel", "click", function () {
        var cookie = $(this).parent("div").attr("cookie");
        window.chat.connectmic_confirm(false, cookie)
        enable_connectmic(cookie, false)
    })

    // listener
    $btnClear.click(function () {
        core.clear();
    });

    $btnSend.click(function () {
        if (!$(this).hasClass('disabled')) {
            window.on_enter_send_msg();
        }
    });

    $chat.on('click', '.link-name', function () {
        var sid = $(this).data('sid');
        if (sid) {
            window.chat.trigger_usermenu(sid);
        }
    });

    $chat.on('click', 'a', function () {
        var $this = $(this);
        var type = $this.attr("type");
        var gid = $this.attr('gid');
        if (gid) {
            if (type == "recruit") {
                window.chat.enter_another_group(gid, 1);
            } else {
                window.chat.enter_another_group(gid, 0);
            }
            return false;
        }
    });

    window.on_process_key_up = function () {
        var temp = getCache(true);
        if (temp) {
            window.inputbox.get_text_clear();
            window.inputbox.insert_text(temp);
        }
    };

    window.entergroupnotify = function(roomid){
        var flashHtml = $("#flash-container").html();
        $("#flash-container").html(flashHtml)
    }

    window.on_process_key_down = function () {
        var temp = getCache(false);
        if (temp) {
            window.inputbox.get_text_clear();
            window.inputbox.insert_text(temp);
        }
    };

    window.on_flicker_tip = function (m) {

        window.flicker_tips_flag && off_flicker_tip();

        (window.flicker_tips_flag = setInterval(function () {
            if ($("#btn-hint").hasClass("on")) {
                $("#btn-hint").removeClass("on").addClass("off");
            } else
                $("#btn-hint").addClass("on").removeClass("off");

        }, 500))


        m = JSON.parse(decodeURIComponent(m));
        //格式：
        //m  = {"content":"q11111111111","fontcolor":0,"fontname":"","fontsize":14,"fontstyle":0,"identityimg":"1_03.png","msgtype":0,"recvuserid":0,"recvusername":"","sendtime":446177632,"senduserid":1000000306,"sendusername":"kslong"}
        core.insertToolMsg(model.getCurSpokesManMsg(m).animate({ right: 20 }));
    }

    window.off_flicker_tip = function () {
        clearInterval(window.flicker_tips_flag);
        window.flicker_tips_flag = null;
        $("#btn-hint").addClass("on").removeClass("off");
        $("#curSpokesManMsg").remove();
    };
    
    // functions

    function pageInit() {
        core.init();
        fontStyle.run(window.chat);
        dfa.bindQT(window.chat);
        window.inputbox.set_hinttext("请输入聊天内容(按Ctrl+Enter换行)");

    }

    function addCache(msg) {
        cache.add(msg);
    }

    function clearCache() {
        cache.clear();
    }

    function getCache(pos) {
        return cache.get(pos);
    }

});