Class(function(extend, using, self){

    extend("pages/page");
    using("lib/jquery.min.js");
    using("plugin/switchtab");
    using("plugin/jquery.contextMenu");


    self.user_ref = null;
    self.on_change = 0; /* 用户点击确定按钮的时候如果传入参数 0 则不做处理 1 则做处理 */
    self.room_id = 0;
    self.initPage = function () {
        /* 初始化选择默认页面li */
        // var default_index = this.user_ref.get_show_index();
        // select_default_li(default_index);

        this.log_trace(this.user_ref, "Ta initPage  start");
        this.log_trace(this.user_ref, "Ta bindMyUserInfo  start");
        /* 绑定用户信息 */
        this.bindMyUserInfo();
        this.log_trace(this.user_ref, "Ta bindMyUserInfo  end");
        this.log_trace(this.user_ref, "Ta initMyRoomInfo  start");
        /* 初始化我的房间信息 */
        this.initMyRoomInfo();

        this.log_trace(this.user_ref, "Ta initMyRoomInfo  end");
        this.log_trace(this.user_ref, "Ta bindMyRoomInfo  start");

        /* 绑定我的房间信息 */
        this.bindMyRoomInfo(1, 0);
        this.log_trace(this.user_ref, "Ta bindMyRoomInfo  end");

        this.log_trace(this.user_ref, "Ta contextMenu newsBar  start");
        $(".set-btn-box li").SwitchTab({  // $('.newsBar a') 点击元素
            showObj: '.set-content',        // 需显示的内容（必填项）
            mouseEvent: 'click',    // 鼠标事件设定，默认：click
            currentClass: 'active',     //当前tab class
            showEffect: "show"     // 默认show（无效果），fade（渐隐渐现）,slide（窗帘效果）
        });

        this.log_trace(this.user_ref, "Ta contextMenu newsBar  end");
        /**
         * 左键菜单
         */
        this.log_trace(this.user_ref, "Ta left contextMenu  start");
        // $.contextMenu({
        //     selector: '.user-list tr .c-room-info-opt',
        //     trigger: 'left',
        //     callback: function (key, options) {
        //         var id = $(this).attr("roomid");
        //         switch (key) {
        //             case "join": Audio.User.user_ref.enter_room(id); break;
        //             case "view": Audio.User.user_ref.view_room(id); break;
        //             case "add": Audio.User.user_ref.collect_room(id); break;
        //             case "cancel": Audio.User.user_ref.uncollect_room(id); break;
        //         }
        //     },
        //     animation: {
        //         show: "fadeIn", hide: "fadeOut"
        //     },
        //     items: {
        //         "join": { name: "进入房间", icon: "join" },
        //         "view": { name: "查看房间资料", icon: "view" },
        //         "add": { name: "加入收藏", icon: "addCollect" },
        //         "cancel": { name: "取消收藏", icon: "addCollect" }
        //     }
        // });
        this.log_trace(this.user_ref, "Ta left contextMenu  end");
        this.log_trace(this.user_ref, "Ta initPage  end");
    }
    /* 绑定用户信息 */
    self.bindMyUserInfo = function () {
        var info = this.user_ref.get_user_info();
        if (info) {
            $(".head-box img:first").attr("src", "file:///" + info.szImgExt);
            var u = $(".user-info");
            u.find(".user-name").text(info.wszUserName);
            u.find(".user-nick-name").text(info.wszNickName);
            u.find(".user-credit").text(parseInt(info.uExperience / 60));
            u.find(".user-sign-info").text(info.sign);
            u.find(".popularity").text(info.popularity);
            // 魅力值
            $('#td-charm').text(Math.round(info.charm));

            // 勋章(数组)
            this.addAward(info.award, info.awardtips);

            var level = parseInt(Math.sqrt(info.uExperience / 60));
            var level_class = " span:first";
            this.change_class_by_level(level, level_class);
            u.find(".Integral span:first strong").text(level);
            if (info.bUserSex == 1) {
                u.find(".c-select-sex").text("男");
            } else {
                u.find(".c-select-sex").text("女");
            }
            var birthDay = new Date(info.szBirthDate.replace("00:00:00", "").replace(" ", ""));
            var year = birthDay.getFullYear();
            var month = birthDay.getMonth() + 1;
            var day = birthDay.getDate();
            if (isNaN(year)) {
                year = 0;
            }
            if (isNaN(month)) {
                month = 0;
            }
            if (isNaN(day)) {
                day = 0;
            }
            var birth_day = year + " 年 " + month + " 月 " + day + " 日";
            //var user_age = info.uAge;
            var user_age = 0;
            if (user_age == 0) {
                var d = new Date();
                var now_year = d.getFullYear();
                user_age = now_year - year;
            }
            u.find(".c-age").text(user_age);
            u.find(".show_area .c-localtion").text(this.trim(this.replaceLongCityName(info.location)));
            $(".c-birthday").text(birth_day);
            date_sx(month, day);
        }
    }
    /* 设置应用的状态 */
    self.settingApply = function (apply_status) {
        if (apply_status) {
            $(".c-btn-apply").removeAttr("disabled");
            this.on_change = 1;
        } else {
            $(".c-btn-apply").attr("disabled", "disabled");
            this.on_change = 0;
        }
    }
    self.addAward = function (arr, tips) {
        var $td = $('#td-award').html('');
        var i = 0;
        var len = arr.length;
        for (i = 0; i < len; i++) {
            $td.append($('<img>').attr('src', 'file:///' + arr[i]).attr('title', tips[i]));
        }
    }

    self.total_count = 0;
    self.page_size = 0;
    self.page_index = 0;
    self.page_count = 0;
    self.page_index_sort_key = 0;
    self.initMyRoomInfo = function () {
        this.total_count = this.user_ref.get_myroom_count();
        if (this.total_count % 6 == 0) {
            this.page_count = parseInt(this.total_count / 6);
        }
        else {
            this.page_count = parseInt(this.total_count / 6) + 1;
        }
    }
    self.getMyRoomInfo = function (index) {
        return this.user_ref.get_myroominfo_by_index(index);
    }
    // 绑定房间信息
    self.bindMyRoomInfo = function (page_index, sort_key) {
        var items = [];
        items.push('<tr class="c-room-info">');
        items.push('<td><div title="{title}">{name}</div></td>');
        items.push('<td>{roomid}</td>');
        items.push('<td><img src="static/images/role/{image}" alt="" /></td>');
        items.push('<td class="c-room-info-opt" indentity="{indentity}" roomid="{roomid}"><span class="down-arrow-ico"></span></td>');
        items.push('</tr>');
        var infos = [];
        if (sort_key == 0) {
            this.page_index_sort_key = 0;
            for (var i = (page_index - 1) * 6; i < page_index * 6; i++) {
                if (i < this.total_count) {
                    var text = items.join("");
                    var info = this.getMyRoomInfo(i);
                    var title = info.zonename;
                    infos.push(text.replace(/\{title\}/g, title.replace(/\"/g, "\'")).replace(/\{name\}/g, this.encodeHTML(info.zonename)).replace(/\{roomid\}/g, info.zoneid).replace(/\{image\}/g, info.idtimage).replace(/\{indentity\}/g, info.indentity));
                }
            }
        }

        if (sort_key == 1) {
            this.page_index_sort_key = 1;
            var start_count = this.total_count - (page_index - 1) * 6 - 1;
            var end_count = this.total_count - page_index * 6 - 1;
            if (end_count < 0) {
                end_count = 0;
            }
            for (var i = start_count; i >= end_count; i--) {
                var text = items.join("");
                var info = this.getMyRoomInfo(i);
                infos.push(text.replace(/\{name\}/g, this.encodeHTML(info.zonename)).replace(/\{roomid\}/g, info.zoneid).replace(/\{image\}/g, info.idtimage).replace(/\{indentity\}/g, info.indentity));
            }
        }

        this.page_index = page_index;
        $(".user-list tbody").remove();
        $(".user-list colgroup").after("<tbody>" + infos.join("") + "</tbody>");
    }

    self.initEvent = function(){
        var that = this;
        $(document).delegate(".c-room-info", "click", function (e) {
            $(".c-room-info").each(function () {
                $(this).removeClass("active");
            });
            $(this).addClass("active");
        });

        $(document).delegate(".c-room-info-opt", "mouseenter", function (e) {
            var id = $(this).attr("roomid");
            var c = $(".context-menu-list");
            if (that.user_ref.is_collected_room(id)) {
                if (c.length > 0) {
                    c.children().eq(2).hide();
                    c.children().eq(3).show();
                }
            }
            else {
                if (c.length > 0) {
                    c.children().eq(2).show();
                    c.children().eq(3).hide();
                }
            }
        });

        /* 上一页 */
        $(document).delegate(".paging-box a:eq(0)", "click", function () {
            if (that.page_index <= 1) {
                return;
            }
            var sort_key = that.page_index_sort_key;
            switch (sort_key) {
                case 0:
                    that.bindMyRoomInfo(--that.page_index, 0);
                    break;
                case 1:
                    that.bindMyRoomInfo(--that.page_index, 1);
                    break;
            }
        });

        /* 下一页 */
        $(document).delegate(".paging-box a:eq(1)", "click", function () {
            if (that.page_index == that.page_count) {
                return;
            }
            var sort_key = that.page_index_sort_key;
            switch (sort_key) {
                case 0:
                    that.bindMyRoomInfo(++that.page_index, 0);
                    break;
                case 1:
                    that.bindMyRoomInfo(++that.page_index, 1);
                    break;
            }
        });

        $(document).delegate(".c-btn-cancel", "click", function () {
            that.user_ref.btn_cancel_click();
        });


        //双击进房间
        $(document).delegate(".c-room-info", "dblclick", function () {
            var roomid = $(this).find(".c-room-info-opt").attr("roomid");
            that.user_ref.enter_room(roomid);
        });


        $(document).delegate(".c-room-info-opt", "click", function (e) {
            e.stopPropagation();
            var menu = $('.user-context-menu-item');
            that.room_id = $(this).attr("roomid");
            if (that.user_ref.is_collected_room(that.room_id)) {
                if (menu.length > 0) {
                    menu.find('a:eq(2)').hide();
                    menu.find('a:eq(3)').show();
                }
            }
            else {
                if (menu.length > 0) {
                    menu.find('a:eq(2)').show();
                    menu.find('a:eq(3)').hide();
                }
            }
            var menu_top = $(this).offset().top + 17;
            var $win = $(window);
            var bottom = $win.height();
            var height = menu.height();
            if (menu_top + height > bottom) {
                menu_top -= height;
                menu.css({top: menu_top, left: 386}).show();
            } else {
                menu.css({top: menu_top, left: 386}).show();
            }
        }).delegate('.c-room-info-opt', 'mouseleave', function () {
            that.tipid && clearTimeout(that.tipid), that.tipid = setTimeout(function () {
                $('.user-context-menu-item').hide();
            }, 200);
        }).delegate('.user-context-menu-item', 'mouseenter', function () {
            that.tipid && clearTimeout(that.tipid);
        }).delegate('.user-context-menu-item', 'mouseleave', function () {
            $('.user-context-menu-item').hide();
        });

        $(document).delegate(".user-context-menu-item a", "click", function () {
            var key = $(this).attr("item");
            switch (key) {
                case "join":
                    that.user_ref.enter_room(that.room_id);
                    break;
                case "view":
                    that.user_ref.view_room(that.room_id);
                    break;
                case "add":
                    that.user_ref.collect_room(that.room_id);
                    $('.user-context-menu-item').hide();
                    break;
                case "cancel":
                    that.user_ref.uncollect_room(that.room_id);
                    $('.user-context-menu-item').hide();
                    break;
            }
        });

        /* 我的房间身份排序切换*/
        $(document).delegate(".c-down-arrow-ico", "click", function () {
            $(".user-list-box .c-room-info").remove();
            $("span[rol='c-arrow-ico']").addClass("c-up-arrow-ico").addClass("up-arrow-ico").removeClass("down-arrow-ico").removeClass("c-down-arrow-ico");
            that.initMyRoomInfo();
            /* 绑定我的房间信息 */
            that.bindMyRoomInfo(1, 1);
        });

        /* 我的房间身份排序切换*/
        $(document).delegate(".c-up-arrow-ico", "click", function () {
            $(".user-list-box .c-room-info").remove();
            $("span[rol='c-arrow-ico']").addClass("c-down-arrow-ico").removeClass("c-up-arrow-ico").removeClass("up-arrow-ico").addClass("down-arrow-ico");
            that.initMyRoomInfo();
            /* 绑定我的房间信息 */
            that.bindMyRoomInfo(1, 0);
        });
    }

    self.func(function(curData){
        var that = this;
        /* 加载发生错误添加默认头像 */
        that.addCall("get_age", function() {

        });

        /* 加载发生错误添加默认头像 */
        that.addCall("add_default_img", function() {
            var my_local_info = that.user_ref.get_user_info();
            if (my_local_info.bUserSex == 1) {
                $(".head-box img:first").attr({src: "static/images/hall/pic.png"});
            }
            else {
                $(".head-box img:first").attr({src: "static/images/hall/female.png"});
            }
        });

        /* 个人头像修改成功刷新个人头像 */
        that.addCall("on_refresh_userimage", function(imgPath) {
            $(".head-box img:first").attr("src", "file:///" + imgPath + "?t=" + Math.random());
        });

        /* loading-mask 控制*/
        that.addCall("on_show_loading", function(bshow) {
            if (bshow == true) {
                $(".mask").show();
            } else {
                $(".mask").hide();
            }
        });

        /* 初始化选择默认页面li */
        that.addCall("select_default_li", function(index) {
            if (index != 0) {
                index_default = index + 1;
                $(".set-btn-box ul li:eq(0)").removeClass("active");
                $(".set-btn-box ul li:eq(" + index + ")").addClass("active");
                $("div[index='1']").css('display', 'none');
                $("div[index=" + index_default + "]").css('display', 'block');
            }
        });

        that.addCall("date_sx", function(m, d) {
            var result = '';
            var XZDict = '摩羯宝瓶双鱼白羊金牛双子巨蟹狮子处女天秤天蝎射手';
            var Zone = [1222, 122, 222, 321, 421, 522, 622, 722, 822, 922, 1022, 1122, 1222];
            if ((100 * m + d) >= Zone[0] || (100 * m + d) < Zone[1])
                var i = 0;
            else
                for (var i = 1; i < 12; i++) {
                    if ((100 * m + d) >= Zone[i] && (100 * m + d) < Zone[i + 1])
                        break;
                }
            result = XZDict.substring(2 * i, 2 * i + 2) + '座';
            $(".constellation").text(result);
        });


        that.user_ref = curData; //userinfo;

        that.sup().constructor(curData);

        that.initPage();
        that.initEvent();

    })
})