Class(function(extend, using, self){

    extend("pages/page");
    using("lib/jquery.min.js");

    self.room_ref = null;
    self.initPage = function () {
        this.log_trace(roominfo, "room_ref bindRoomInfo  start");
        this.bindRoomInfo();
        this.log_trace(roominfo, "room_ref bindRoomInfo  end");
    }
    // 绑定房间信息
    self.bindRoomInfo = function () {
        var room_info = this.room_ref.get_room_info();
        var img = $("img:first");
        var rows = $(".info");
        var zonename = $(".room-name div");
        var zoneid = rows.find("tr:eq(0)");
        var zoneexp = rows.find("tr:eq(0)");
        var cardformat = rows.find("tr:eq(1)");
        var img_url = room_info.zoneimg;
        img.attr({src: "file:///" + img_url });
        zonename.text(room_info.zonename);
        zoneid.find("td:eq(1)").text(room_info.zoneid);
        zoneexp.find("td:eq(3)").text(parseInt(room_info.zoneexp/1440));
        cardformat.find("td:eq(1)").text(room_info.cardformat);
        get_room_collect_info();
    }
    // 加入收藏
    self.addFavorite = function () {
        this.room_ref.collect_room();
    }
    // 取消收藏
    self.removeFavorite = function () {
        this.room_ref.uncollect_room();
    }
    // 设置飞机票地址
    self.getAirplaneAddress = function () {
        this.room_ref.get_airplane_address();
    }
    self.initEvent = function(){
        var that = this;
        /* 	获取飞机票地址 3s 后消失*/
        $(document).delegate("span[rol='air']", "click", function (e) {
            e.stopPropagation();
            that.getAirplaneAddress();
            $(".tip").css('display','block');
            var t=setTimeout("display_dip()",3000);
        });

        /* 	收藏或者取消房间 */
        $(document).delegate("span[rol='collect']", "click", function (e) {
            e.stopPropagation();
            if ($(this).hasClass("active")) {
                that.removeFavorite();
            }
            else {
                that.addFavorite();
            }
        });

        /*更新按钮*/
        $(document).delegate(".btn-box button:eq(0)", "click", function () {
            that.bindRoomInfo();
        });

        /*取消按钮*/
        $(document).delegate(".btn-box button:eq(1)", "click", function () {
            that.room_ref.btn_close_click();
        });
    }
    self.func(function(curData){
        var that = this;
        /*查询房间收藏或者取消收藏 */
        that.addCall("get_room_collect_info", function() {
            var flag = that.room_ref.is_collected_room();
            if(flag){
                $(".collect-normal-ico").addClass("active");
                $("span[rol='collect']").attr('title','取消收藏');
            }else{
                $(".collect-normal-ico").removeClass("active");
                $("span[rol='collect']").attr('title','加入收藏');
            }
        });


        that.addCall("on_collect_room_res", function(errorCode,error) {
            if(errorCode == 0) {
                $(".collect-normal-ico").addClass("active");
                $("span[rol='collect']").attr('title','取消收藏');
            }
        });

        that.addCall("on_uncollect_room_res", function(errorCode,error){
            if(errorCode == 0) {
                $(".collect-normal-ico").removeClass("active");
                $("span[rol='collect']").attr('title','加入收藏');
            }
        })

        that.addCall("display_dip", function() {
            $(".tip").css('display','none');
        });

        that.room_ref = curData;//roominfo;
        that.sup().constructor(curData);


        that.initPage();
        that.initEvent();

    })
})

//Audio.RoomInfo = Audio.RoomInfo || {
//    room_ref: null,
//    initPage: function () {
//        Audio.log_trace(roominfo, "room_ref bindRoomInfo  start");
//        Audio.RoomInfo.bindRoomInfo();
//        Audio.log_trace(roominfo, "room_ref bindRoomInfo  end");
//    },/*绑定房间信息*/
//    bindRoomInfo: function () {
//        var room_info = this.room_ref.get_room_info();
//        var img = $("img:first");
//        var rows = $(".info");
//        var zonename = $(".room-name div");
//        var zoneid = rows.find("tr:eq(0)");
//        var zoneexp = rows.find("tr:eq(0)");
//        var cardformat = rows.find("tr:eq(1)");
//        var img_url = room_info.zoneimg;
//        img.attr({src: "file:///" + img_url });
//        zonename.text(room_info.zonename);
//        zoneid.find("td:eq(1)").text(room_info.zoneid);
//        zoneexp.find("td:eq(3)").text(parseInt(room_info.zoneexp/1440));
//        cardformat.find("td:eq(1)").text(room_info.cardformat);
//        get_room_collect_info();
//    },/* 加入收藏 */
//    addFavorite: function () {
//        this.room_ref.collect_room();
//    },/* 取消收藏 */
//    removeFavorite: function () {
//        this.room_ref.uncollect_room();
//    },/* 设置飞机票地址 */
//    getAirplaneAddress: function () {
//        this.room_ref.get_airplane_address();
//    }
//};

///*查询房间收藏或者取消收藏 */
//function  get_room_collect_info() {
//    var flag = Audio.RoomInfo.room_ref.is_collected_room();
//    if(flag){
//        $(".collect-normal-ico").addClass("active");
//        $("span[rol='collect']").attr('title','取消收藏');
//    }else{
//        $(".collect-normal-ico").removeClass("active");
//        $("span[rol='collect']").attr('title','加入收藏');
//    }
//}
//
//
//function on_collect_room_res(errorCode,error) {
//    if(errorCode == 0) {
//        $(".collect-normal-ico").addClass("active");
//        $("span[rol='collect']").attr('title','取消收藏');
//    }
//}
//function on_uncollect_room_res(errorCode,error){
//    if(errorCode == 0) {
//        $(".collect-normal-ico").removeClass("active");
//        $("span[rol='collect']").attr('title','加入收藏');
//    }
//}
//
//function display_dip() {
//    $(".tip").css('display','none');
//}
//
//(function () {
//
//    /* 	获取飞机票地址 3s 后消失*/
//    $(document).delegate("span[rol='air']", "click", function (e) {
//        e.stopPropagation();
//        Audio.RoomInfo.getAirplaneAddress();
//        $(".tip").css('display','block');
//        var t=setTimeout("display_dip()",3000);
//    });
//
//    /* 	收藏或者取消房间 */
//    $(document).delegate("span[rol='collect']", "click", function (e) {
//        e.stopPropagation();
//        if ($(this).hasClass("active")) {
//            Audio.RoomInfo.removeFavorite();
//        }
//        else {
//            Audio.RoomInfo.addFavorite();
//        }
//    });
//
//    /*更新按钮*/
//    $(document).delegate(".btn-box button:eq(0)", "click", function () {
//        Audio.RoomInfo.bindRoomInfo();
//    });
//
//    /*取消按钮*/
//    $(document).delegate(".btn-box button:eq(1)", "click", function () {
//        Audio.RoomInfo.room_ref.btn_close_click();
//    });
//
//})();

//window.onload = function () { Audio.RoomInfo.room_ref = roominfo;Audio.RoomInfo.initPage();}