(function ($) {

    'use strict';

    var $win = $(window);
    var $body = $('body');
    var $number = $('#room-info-number');
    var $lag = $('#room-info-lag');
    //var $titleBox = $('#room-name-box');
    var $title = $('#room-name');
    var $input = $('#room-name-input');
    var $mask = $('#mask');
    var $notice = $('#room-desc');
    var resizeTimer = 0;
    // 用户是否拥有编辑权限
    var isEditable = false;
    var isEditingDesc = false;
    var QT_input;
    var QT_title;

    // api
    window.onload = function () {
        QT_title = window.videotitle;
        QT_input = window.inputbox;

        setTitle(QT_title.groupName());
        setNumber(QT_title.groupOnlineFens());
        setLag(QT_title.networkDelay());
        setNotice(QT_input.text());

        // init QT input box
        QT_input.fontsize = 12;
    };

    window.clear = function () {
        setTitle('');
        setNotice('');
        $title.show();
        $mask.hide();
        isEditable = false;
        showQTInput(false);
    };

    window.on_set_notice_auth = function (b) {
        if (typeof b === "boolean") {
            isEditable = b;
        }
        if (typeof b === "string") {
            isEditable = b === 'true';
        }
        if (isEditable) {
            $body.addClass('edit');
        } else {
            $body.removeClass('edit');
        }
    };

    window.on_set_notice_info = function (t) {
        if (t) {
            $notice.removeClass('empty').show();
            setNotice(formatHTML(window.notice.base64decode_string(t)));
        } else {
            $notice.html('<span>点击编辑</span>').addClass('empty');
        }

    };

    window.refresh_network_delay = function (n) {
        setLag(n);
    };

    window.refresh_group_name = function (t) {
        setTitle(window.notice.base64decode_string(t));
    };

    window.refresh_online_fens = function (n) {
        setNumber(n);
    };

    window.on_resetting = function () {
        showQTInput(false);
    };

    window.on_save_notice_info = function () {
        showQTInput(false);
    };

    // listeners
    $title.on('click', function () {
        if (isEditable) {
            $input.val($title.text()).width($title.width());
            $title.hide();
            $mask.show();
            $input.focus();
        }

    });

    $mask.on('click', function (e) {
        if (e.target.className === 'mask') {
            saveTitle();
        }
    });

    $input.on('keydown', function (e) {
        if (e.keyCode === 13) {
            saveTitle();
        }
    });

    $notice.on('click', function () {
        if (isEditable) {
            showQTInput(true);
            setTimeout(function () {
                isEditingDesc = true;
            }, 100);
        }
        return false;
    });

    $body.on('click', function () {
        if (isEditingDesc) {
            showQTInput(false);
        }

        return false;
    });

    $input.focus(function(){
        return false;
    });
    // 性能杀手
    $win.on('resize', function () {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(function () {
            refreshInputPosition();
            resizeTitle();
        }, 300);
    }).on("blur", function(e){
        $title.css("display") == 'none' && saveTitle();
    });

    $notice.on('click', 'a', function () {
        var $this = $(this);
        var type = $this.attr("type") || '';
        if (type === "recruit") {
            window.chat.enter_another_group($this.attr('gid'), 1);
            return false;
        }
        if (type === "jump" || type === undefined) {
            window.chat.enter_another_group($this.attr('gid'), 0);
            return false;
        }
    });


    function setNumber(n) {
        $number.text(n+"(含网页)");
    }

    function setLag(n) {
        var text;
        var isTest = QT_title.internal || false;
        if (n === 0) {
            text = ' -- ';
        }
        if (isTest) {
            if (n > 0 && n < 2300) {
                text = n + 'ms(优秀)';
            }
            if (n >= 2300 && n < 3000) {
                text = n + 'ms(良好)';
            }
            if (n >= 3000 && n < 5000) {
                text = n + 'ms(一般)';
            }
            if (n >= 5000) {
                text = n + 'ms(较差)';
            }
        } else {
            if (n > 0 && n < 2300) {
                text = ' 优秀';
            }
            if (n >= 2300 && n < 3000) {
                text = ' 良好';
            }
            if (n >= 3000 && n < 5000) {
                text = ' 一般';
            }
            if (n >= 5000) {
                text = ' 较差';
            }
        }

        $lag.text(text);
    }

    function setTitle(t) {
        $title.text(t);
        resizeTitle();
    }

    function saveTitle() {
        var t = $input.val().trim();

        $title.text(t).show();
        $mask.hide();
        QT_title.setGroupName(t);
    }

    function resizeTitle() {
        //var max = $win.width() - 350;
        //if($title.width() > max){
        //  $title.width(max);
        //}else{
        //  $title.width('');
        //}
    }

    function setNotice(t) {
        $notice.html(t);
    }

    function saveDesc() {
        isEditingDesc = false;
        QT_input.hide();
    }

    function showQTInput(b) {
        if (b) {
            refreshInputPosition();
            window.notice.show_edit_inputbox();
            QT_input.show();
            QT_input.set_foucs();
        } else {
            saveDesc();
        }
    }

    function refreshInputPosition() {
        QT_input.set_input_rect($win.width() - 279, 3, 268, 62);
    }

    function formatHTML(content) {
        var links = [];
        var i = 0;
        if (content.indexOf('gid') >= 0) {
            var regexp = /<a gid=\"([0-9]*)\" (.*)(href|herf)=\"ghop\">(.*)<\/a>+/g;
            var matchs = content.match(regexp);
            if (matchs) {
                for (i = 0; i < matchs.length; i++) {
                    links[i] = matchs[i];
                    content = content.replace(matchs[i], "{t$e#x@t!}" + i);
                }
            }
        }
        content = antiXss(content).replace(/\n/g, "<br/>").replace(/\s/g, "&nbsp;");
        if (links.length > 0) {
            for (i = 0; i < links.length; i++) {
                content = content.replace("{t$e#x@t!}" + i, links[i]);
            }
        }
        return window.notice.auto_detect_url(content);
    }

    function antiXss(t) {
        return $('<div>').text(t).html();
    }

    var isbroadcastEnable = true;
    // room-broadcast
    var num_broadcast = window.notice.get_boardcast_timesleft() || 0;
    $("#room-broadcast span").html(num_broadcast);
    $("#room-broadcast").click(function(){
        isbroadcastEnable && window.notice.send_playstart_boardcastfans();
    }).hover(function(){
        $(this).find(".tip").show();
    }, function(){
        $(this).find(".tip").hide();
    })
    // 更新广播次数
    window.update_boa_rdcast_timesleft = function(n){
        $("#room-broadcast span").html(n);
    }
    //按钮禁用\可用态
    window.enable_boardcastfans_btn = function(b) {
        isbroadcastEnable = b;
        !b && $("#room-broadcast").addClass("disable")
        b && $("#room-broadcast").removeClass("disable")
    }
    // 显示或隐藏
    window.visible_boardcastfans_btn = function(b){
        b && $("#room-broadcast").show();
        !b && $("#room-broadcast").hide();
        enable_boardcastfans_btn(num_broadcast)
    }

    $("#room-exit").click(function(){
        window.videotitle.exit2welcome();
    })

    //num_broadcast && visible_boardcastfans_btn(true)
})(jQuery);