Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");

    self.video_ref = null;
    self.initPage = function () {
        this.bindVideoInfo();
    }
    /* 绑定视频信息 */
    self.bindVideoInfo = function () {
        document.getElementById("object-video").set_parent(this.video_ref.get_main_wnd());
    }
    var __initVideoContainer = function() {
        var contHeight = $(window).height() - $(".video-title").height() - $(".video-bottom").height() - 20 /* wrap padding */
        var paddingTop = (contHeight - $(".video-live").height())/2;

        // 设置容器大小
        $(".video-container").css({
            height: contHeight
        });

        // 若该提示显示, 则设置提示居中
        if(!$(".video-live").hasClass(".display-none")) {
            $(".video-live").css({
                paddingTop: paddingTop
            });
        }
    }
    self.initEvent = function(){
        var that = this;
        /*开始直播*/
        $(document).delegate(".video-play>span.playBtn", "click", function () {
            that.video_ref.OnGamePlay();
        });
        //上麦直播
        $(document).delegate(".video-desc>span", "click", function () {
            that.video_ref.on_click_mic_on();
        });
        //视频预览
        $(document).delegate(".video-play>span.viewBtn", "click", function () {

            that.video_ref.OnGamePlayPreView();
        });
        //停止预览
        $(document).delegate(".video-close>span.closeBtn", "click", function () {
            that.video_ref.OnStopGamePlayPreView();
        });
        //停止直播
        $(document).delegate(".video-play-stop>span.closePlay", "click", function () {
            that.video_ref.OnStopGamePlay();
        });
        //视频设备切换
        $(document).delegate("select[name='c-select-mic']", "change", function () {
            var value = $(this).val();
            that.video_ref.OnVedioDeviceChange(value);
        });

        // Resize窗口尺寸, 刷新容器大小
        $(window).on("resize", function() {
            __initVideoContainer();
            var video_height = $(".video-container").height();
            var video_width = $(".video-container").width();

            document.getElementById("object-video").resize_player(video_width, video_height);
        });
    }

    self.func(function(curData){
        var that = this;
        //清空所有元素
        that.addCall("on_clear_screen", function() {
            $(".video-common").hide();
            document.getElementById("object-video").set_visible(false);
        });

        //显示暂无直播，您可以上麦直播，且上麦直播是个链接
        that.addCall("on_display_can_mic_on", function() {
            $(".video-common").hide();
            $(".video-live").show();
            $(".video-desc").show();
        });

        //您已上麦，请等待成为首麦方可直播
        that.addCall("on_display_wait_first_mic", function() {
            $(".video-common").hide();
            $(".video-wait-first-mic").show();
        });

        //true:显示视频直播 和 视频预览两个按钮
        //false:仅仅显示视频直播按钮
        that.addCall("on_display_play_btn", function(bTwoBtn) {
            $(".video-common").hide();
            $(".video-live").show();
            if (bTwoBtn == true) {
                $(".video-play").show();
            } else {
                $(".video-play").show();
                $(".playBtn").css("marginLeft", 12);
                $(".viewBtn").hide();
            }
        });
        /*获取播放器宽高，以及初始位置*/
        that.addCall("get_player_rect", function() {
            var play_obj = {};
            var video_container = $(".video-container");
            play_obj.ntop = video_container.offset().top;
            play_obj.nleft = video_container.offset().left;
            play_obj.nwidth = video_container.width();
            play_obj.nheight = video_container.height();
            return play_obj;
        });

        //显示视频预览的效果&&显示视频窗口插件
        //显示下拉框切换视频设备
        //显示停止预览按钮
        that.addCall("on_display_video_preview", function() {
            var video_list = that.video_ref.get_vedio_device_list();
            if (video_list.length == 0) {
                return;
            }
            $(".video-common").hide();
            var c = $(".video-close");
            var select_mic = c.find("select[name='c-select-mic']");
            select_mic.empty();
            for (var i = 0; i < video_list.length; i++) {
                select_mic.append("<option value=\"" + i + "\">" + video_list[i] + "</option>");
            }
            c.show();
            document.getElementById("object-video").set_visible(true);

        });

        //显示视频窗口插件
        //参数显示停止直播按钮
        that.addCall("on_display_video_box", function(flag) {
            $(".video-common").hide();
            $(".video-live").hide();
            document.getElementById("object-video").set_visible(true);
            if (flag == true) {
                document.getElementById('c-id-video-play-stop').style.display = "block";
                $(".colspan").css("visibility", "hidden");
            }
        })

        //显示直播还没有开始哦
        that.addCall("on_display_paly_not_started", function() {
            $(".video-common").hide();
            $(".video-live").show();
            $(".video-wait-play").show();
        });

        //显示主播正在准备直播，请稍候...
        that.addCall("on_display_paly_on_starting", function() {
            $(".video-common").hide();
            $(".video-live").show();
            $(".video-connect").show();
        });

        //直播画面正在拼命加载...
        that.addCall("on_display_paly_loading", function() {
            $(".video-common").hide();
            $(".video-live").show();
            $(".video-play-loading").show();
        });

        //等待直播...
        that.addCall("on_display_paly_waiting", function() {
            $(".video-common").hide();
            $(".video-live").show();
            $(".video-play-waiting").show();
        });


        //初始化摄像头设备列表
        that.addCall("on_init_video_info", function(videoIndexSel) {

        });

        that.addCall("get_video_wnd", function() {
            return document.getElementById("object-video").getHwnd();
        });
        //刷新房间名称
        that.addCall("refresh_group_name", function(groupname) {
            var group_name = that.video_ref.base64decode_string(groupname);
            group_name = that.trim(group_name);
            var name_length = group_name.length;
            if (name_length > 10) {
                group_name = group_name.substr(0, 10) + "···";
            }
            $(".title").text(group_name);
        });
        //刷新房间在线人数
        that.addCall("refresh_group_num", function(usernum) {
            $(".count").text("（" + usernum + "）");
        });

        that.addCall("updateTitle", function(title, count) {
            $(".title").text(title);
            $(".count").text("（" + count + "）");
        });

        that.addCall("updateVideoDim", function(w, h) {
            $(".video").css({ // 更新视频窗口容器尺寸
                width: w,
                height: h
            });
        });

        // 初始化容器尺寸
        __initVideoContainer();

        that.video_ref = curData;//videoview;
        that.sup().constructor(curData);

        that.initPage();
        that.initEvent();
        $(".video-plugin").css("visibility", "visible");
    })
});

