Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");


    self.anchor_ref = null;
    self.anchor_id = 0;
    self.anchor_img = null;
    self.anchor_sex = 0;
    self.initPage = function () {
        this.bindAnchorInfo();
    }
    // 绑定主播信息
    self.bindAnchorInfo = function () {
        var anchor_info = this.anchor_ref.roleInfo();

        this.anchor_id = anchor_info.userid;
        this.anchor_img = anchor_info.image;
        this.anchor_sex = anchor_info.sex;
        var order_status = anchor_info.subscribeenable;
        var order_btn_status = anchor_info.subscribebtn;
        this.updateSubScribeStatus(order_btn_status);
        this.updateSubBtnStatus(order_status);

       // $(".subscribe-count").text(order_nums);

        $(".anchor-name").text(anchor_info.username);
        $(".subscribe-count").text(anchor_info.subscribenums);
        $(".anchor-rose>span").text(anchor_info.flowernums);
        $(".anchor-heart>span").text(anchor_info.heartnums);
        $(".anchor-header img:first").attr({src: "file:///" + anchor_info.image + "?t=" + Math.random()});


    }
    // 更新订阅数量
    self.updateSubscribe = function (count) {
        $(".subscribe-count").text(count);
    }
    // 更新玫瑰数量
    self.updateRose = function (count) {
        $(".anchor-rose>span").text(count);
    }
    // 更新人气数量
    self.updateHeart = function (count) {
        $(".anchor-heart>span").text(count);
    }
    /* 更新订阅状态 */
    self.updateSubScribeStatus = function (flag) {
        if (flag == true) {
            $(".subscribe").addClass("none");
            $(".anchor-subscribe").text("取消订阅");
        } else {
            $(".subscribe").removeClass("none");
            $(".anchor-subscribe").text("订阅");
        }
    }

    /*订阅按钮是否可用*/
    self.updateSubBtnStatus = function (flag) {
        if (flag == false) {
            $(".anchor-subscribe").addClass("disabled");
        } else {
            $(".anchor-subscribe").removeClass("disabled");
        }
    }
    self.initEvent = function(){
        var that = this;

        /*点击订阅按钮*/
        $(document).delegate(".anchor-subscribe", "click", function () {

            var str = $(this).text();

            if(!$(this).hasClass('disabled')){
                if (str == "订阅") {
                    that.anchor_ref.setOrder(true);
                } else {
                    that.anchor_ref.setOrder(false);
                }
            }
        });
    }
    self.func(function(curData){

        var that = this;

        /*异步回调，更新订阅数量*/
        that.addCall("setAnchorOrderNums", function(count) {
            that.updateSubscribe(count);
        });

        /*异步回调，更改订阅状态*/
        that.addCall("setSelfOrderStatus",function (flag) {
            that.updateSubBtnStatus(true);
            that.updateSubScribeStatus(flag);
        });
        /*异步回调，更新鲜花数量*/
        that.addCall("flowerNumsChanged", function(count) {
            that.updateRose(count);
        });
        /*异步回调，更新人气数量*/
        that.addCall("update_sub_scribe", function(count) {
            that.updateHeart(count);
        });
        that.addCall("exitRoomBtnStatus", function() {
            that.updateSubBtnStatus(false);
        });

        /*头像修改状态*/
        that.addCall("roleHeaderChanged", function(roleid) {
            if (roleid == 0) {
                //初始化状态
                $(".subscribe-count").text(0);
                $(".anchor-rose>span").text(0);
                $(".anchor-heart>span").text(0);
                $(".anchor-name").text("");
                that.updateSubBtnStatus(false);
                $(".anchor-header img:first").attr({src: "static/images/hall/female.png"});
            }
            if (that.anchor_id == roleid) {
                $(".anchor-header img:first").attr({src: "file:///" + that.anchor_img + "?t=" + Math.random()});
            }
        });
        /**/
        that.addCall("setanchorinfo", function(m) {
            var o = that.formatData(that.decode(m));
            that.anchor_id = o.userid;
            that.anchor_sex = o.sex;
            that.anchor_img = o.image;
            var order_status = o.subscribeenable;
            var order_btn_status = o.subscribebtn;
            $(".anchor-name").text(o.username);
            $(".subscribe-count").text(o.subscribenums);
            $(".anchor-rose>span").text(o.flowernums);
            that.updateHeart(o.heartnums);
            //$(".anchor-heart>span").text(o.heartnums);
            that.updateSubScribeStatus(order_btn_status);
            that.updateSubBtnStatus(order_status);
            $(".anchor-header img:first").attr({src: "file:///" + o.image + "?t=" + Math.random()});
        });
        /* 加载发生错误添加默认头像 */
        that.addCall("add_default_img", function() {
            if (that.anchor_sex == 1) {
                $(".anchor-header img:first").attr({src: "static/images/hall/pic.png"});
            } else {
                $(".anchor-header img:first").attr({src: "static/images/hall/female.png"});
            }
        });

        that.addCall("heartNumsChanged" , function (number) {
            that.updateHeart(number);
        });

        that.anchor_ref = curData;//roletick;
        that.sup().constructor(curData);


        that.initPage();
        that.initEvent();
    })
})
