Class(function(extend, using, self){

    extend("pages/page");
    using("lib/jquery.min.js");

    // variables
    var $loading = $(".loading-mask");
    var $pass_notice = $(".c-password-notice");
    var $pass = $('.c-room-password');
    var $room_name = $(".c-room-name");
    var $btn = $('.btn');
    var $t1 = $('#title1');
    var $t2 = $('#title2');

    self.room_pass_ref = null;
    self.initPage = function () {
        var room_info = this.room_pass_ref.get_group_info();
        $room_name.text(room_info.groupname);
        if(room_info.group_name_title){
            $t1.text(room_info.group_name_title);
        }
        if(room_info.group_pwd_title){
            $t2.text(room_info.group_pwd_title);
        }
    }

    self.initEvent = function(){
        var that = this;
        $btn.eq(0).on('click', function () {
            var room_pass = $pass.val();
            if (that.isEmpty(room_pass)) {
                $pass_notice.hide().text("密码不为空").show();
            } else {
                that.room_pass_ref.btn_ok_click(room_pass);
            }
        });

        $btn.eq(1).on('click', function(){
            that.room_pass_ref.btn_close_click();
        });

        $pass.on('keydown', function(e){
            if (e.keyCode == 13) {
                var room_pass = $pass.val();
                if (that.isEmpty(room_pass)) {
                    $pass_notice.hide().text("密码不为空").show();
                } else {
                    that.room_pass_ref.btn_ok_click(room_pass);
                }
            }
        });
    }

    self.func(function(curData){
        var that = this;
        /* loading-mask 控制*/
        that.addCall("on_show_loading", function (b) {
            if (b == true) {
                $loading.show();
            } else {
                $loading.hide();
            }
        });

        that.addCall("on_show_password_error", function (text) {
            text = text || "请输入正确的房间密码!";
            $pass_notice.hide().text(text).show();
        });

        that.room_pass_ref = curData;//inputpass;

        that.sup().constructor(curData);

        that.initPage();
        that.initEvent();
    })

})

//(function () {
//  // variables
//  var $loading = $(".loading-mask");
//  var $pass_notice = $(".c-password-notice");
//  var $pass = $('.c-room-password');
//  var $room_name = $(".c-room-name");
//  var $btn = $('.btn');
//  var $t1 = $('#title1');
//  var $t2 = $('#title2');

//  Audio.RoomPass = Audio.RoomPass || {
//    room_pass_ref: null,
//    initPage: function () {
//      var room_info = this.room_pass_ref.get_group_info();
//      $room_name.text(room_info.groupname);
//      if(room_info.group_name_title){
//        $t1.text(room_info.group_name_title);
//      }
//      if(room_info.group_pwd_title){
//        $t2.text(room_info.group_pwd_title);
//      }
//    }
//  };

//  /* loading-mask 控制*/
//  window.on_show_loading = function (b) {
//    if (b == true) {
//      $loading.show();
//    } else {
//      $loading.hide();
//    }
//  };
//
//  window.on_show_password_error = function (text) {
//    text = text || "请输入正确的房间密码!";
//    $pass_notice.hide().text(text).show();
//  };

//  $btn.eq(0).on('click', function () {
//    var room_pass = $pass.val();
//    if (Audio.isEmpty(room_pass)) {
//      $pass_notice.hide().text("密码不为空").show();
//    } else {
//      Audio.RoomPass.room_pass_ref.btn_ok_click(room_pass);
//    }
//  });
//
//  $btn.eq(1).on('click', function(){
//    Audio.RoomPass.room_pass_ref.btn_close_click();
//  });
//
//  $pass.on('keydown', function(e){
//    if (e.keyCode == 13) {
//      var room_pass = $pass.val();
//      if (Audio.isEmpty(room_pass)) {
//        $pass_notice.hide().text("密码不为空").show();
//      } else {
//        Audio.RoomPass.room_pass_ref.btn_ok_click(room_pass);
//      }
//    }
//  });
//
//  window.onload = function () {
//    Audio.RoomPass.room_pass_ref = inputpass;
//    Audio.RoomPass.initPage();
//  };
//})();

