Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");

    self.cast_ref = null;
    self.radio_flag = 1;
    self.input_box = null;
    self.checkbox_flag = 1;
    self.textarea_flag = 1;

    self.setDisableStatus = function() {
        if((this.radio_flag == 1)  && (this.textarea_flag == 1) && (this.checkbox_flag == 1)  ) {
            $(".popup-Box .btn-box .btn").css("background-color", "#00a2ff");
        } else{
            $(".popup-Box .btn-box .btn").css("background-color", "#C0C0C0");
        }
    }

    self.initEvent = function(){
        var that = this;
        /*
         * 点击img，相邻兄弟节点checked改变状态
         */
        $(document).delegate("img", "click", function () {
            var flag = $(this).prev().is(":checked");
            if(flag == true) {
                $(this).prev().prop('checked', false);
            } else {
                $(this).prev().prop('checked', true);
            }
            that.checkbox_flag = 0;
            $("input[type='checkbox'][name='role']:checked").each(function () {
                that.checkbox_flag = 1;
            });
            that.setDisableStatus();
        });


        /*
         * 点击img，相邻兄弟节点checked改变状态
         */
        $(document).delegate("input[type='checkbox'][name='role']", "click", function () {
            that.checkbox_flag = 0;
            $("input[type='checkbox'][name='role']:checked").each(function () {
                that.checkbox_flag = 1;
            });
            that.setDisableStatus();
        });




        /*
         * 点击label，相邻兄弟节点checked改变状态
         */
        $(document).delegate("label", "click", function () {
            var flag = $(this).prev().is(":checked");
            if(flag == false) {
                $(this).prev().prop('checked', true);
            }
        });




        $(document).delegate(".btn-box button:first", "click", function () {
            var range = that.toInt($("input[type='radio'][name='group']:checked").val());
            var identitys = Array();
            $("input[type='checkbox'][name='role']:checked").each(function () {
                identitys.push($(this).val());
            });
            var identity = identitys.join(",");
            var msg = that.input_box.get_text_clear();
            that.cast_ref.sendmsg(range, identity, msg);//广播发送接口
            that.cast_ref.close();
        });

        // 选择语音播报
        $(document).delegate("#ckVol", "click", function(){
            var range = that.toInt($("input[type='radio'][name='group']:checked").val());

            if ( $("#ckVol").is(":checked") ){
                roleCheckList = new Array();
                $("input[type='checkbox'][name='role']").each(function(){
                    if (!$(this).is(":checked")) {
                        $(this)[0].click();
                        roleCheckList.push(false)
                    } else {
                        roleCheckList.push(true)
                    }
                })

                $("input").not("#ckVol").attr("disabled", true).addClass("disabled");
                // 调用语音接口
                that.cast_ref.audio_broadcast(range, true);
            } else {
                $("input").not("#ckVol").attr("disabled", false).removeClass("disabled");
                for (var i = 0; i < roleCheckList.length; i ++){
                    if (!roleCheckList[i])
                        $("input[type='checkbox'][name='role']").get(i).click();
                }
                // 关闭语音接口
                that.cast_ref.audio_broadcast(range, false);
            }

        });

    }

    self.func(function(data){
        this.cast_ref = data; //roomradio;
        this.input_box = inputbox;

        this.sup().constructor(data);

        this.addCall("showAudioVol", function(vol){
            $(".volunmbar-active").css({ "width": parseInt(vol / 100 * 166) });
        });

        var room_name = this.cast_ref.getroomname();

        $("#group_room").text(room_name);
        $("#border-text").text("");

        this.initEvent();
    });
})