/**
 * @author pei-qiao.peng
 * @date   2015/1/21.
 * @email  ppq1991@gmail.com
 * @github https://github.com/ppq1991/
 * @blog   http://pengpeiqiao.tk/
 */

Class(function (extend, using, self) {
  'use strict';

  var $inputStyle = $('#input-style');
  var $btnEmoji = $('#btn-emoji');
  var $btnColor = $('#style-color');
  var $btnB = $('#style-b');
  var $btnI = $('#style-i');
  var $btnU = $('#style-u');
  var $colorList = $('#style-color-list');
  var $table = $('#emoji-box');
  var $win = $(window);
  var QT;

  var model = using('pages/chat/emoji').New();

  var auth = false;

  var json = {};

  self.run = function (qt) {
    QT = qt;
    init();
  };

  self.getStyle = function () {
    json.fontstyle = QT.get_font_style();
    return JSON.stringify(json);
  };

  window.on_reset_font_info = function(){
    initFontStyle();
  };

  function init() {
    addColorModel();
    addEmojiModel();
    initFontStyle();

    // add listener
    $btnEmoji.click(function () {
      toggle();
    });

    $inputStyle.mouseleave(function () {
      close();
      closeColor();
    });

    $btnColor.click(function () {
      if (!auth) {
        toggleColor();
      }
    });

    $btnB.click(fsClickHandle);
    $btnI.click(fsClickHandle);
    $btnU.click(fsClickHandle);

  }

  function fsClickHandle(){
    if (!auth) {
      $(this).toggleClass('active');
      setCurrentFsStatus();
    }
  }

  function initFontStyle() {
    var info = {};
    if(QT){
      info = QT.get_font_info();
      json.fontstyle = QT.get_font_style();
    }
    json.fontsize = 14;
    json.fontcolor = info.fontColor;
    json.msgtype = 0;
    auth = info.forbidAlter;
    setDisabled(auth);
    setBtnStatus(json.fontstyle);
    setCurrentFsStatus();
    setInputboxColor(json.fontcolor);
  }

  function setInputboxColor(i){
    if(QT){
      window.inputbox.fontcolor = model.colors[i];
      QT.set_font_info(1, i);
      $colorList.children().removeClass('active').eq(i).addClass('active');
    }
  }

  function setBtnStatus(style){
    setFsActive('b', false);
    setFsActive('i', false);
    setFsActive('u', false);
    if (style & 1) {
      setFsActive('b', true);
    }
    if (style & 2) {
      setFsActive('i', true);
    }
    if (style & 4) {
      setFsActive('u', true);
    }
  }

  function setCurrentFsStatus() {
    var status1 = false;
    var status2 = false;
    var status3 = false;
    if ($btnB.hasClass('active')) {
      status1 = true;
    }
    if ($btnI.hasClass('active')) {
      status2 = true;
    }
    if ($btnU.hasClass('active')) {
      status3 = true;
    }
    if(QT){
      QT.set_font_info(2, status1);
      QT.set_font_info(3, status2);
      QT.set_font_info(4, status3);

      window.inputbox.fbold = status1;
      window.inputbox.fitatic = status2;
      window.inputbox.funderline = status3;
    }
  }

  function open() {
    $inputStyle.show();
  }

  function close() {
    $inputStyle.hide();
  }

  function toggle() {
    $inputStyle.toggle();
  }

  function openColor() {
    $colorList.show();
  }

  function closeColor() {
    $colorList.hide();
  }

  function toggleColor() {
    $colorList.toggle();
  }

  function setDisabled(b) {
    if (b) {
      $btnColor.addClass('disabled');
      $btnB.addClass('disabled');
      $btnI.addClass('disabled');
      $btnU.addClass('disabled');
    } else {
      $btnColor.removeClass('disabled');
      $btnB.removeClass('disabled');
      $btnI.removeClass('disabled');
      $btnU.removeClass('disabled');
    }
  }

  function setFsActive(n, b) {
    if (n == 'b') {
      if (b) {
        $btnB.addClass('active');
      } else {
        $btnB.removeClass('active');
      }
    }
    if (n == 'i') {
      if (b) {
        $btnI.addClass('active');
      } else {
        $btnI.removeClass('active');
      }
    }
    if (n == 'u') {
      if (b) {
        $btnU.addClass('active');
      } else {
        $btnU.removeClass('active');
      }
    }
  }

  function addColorModel() {
    var colors = model.colors;
    var li = $colorList.children();
    for (var i = 0; i < 9; i++) {
      li.eq(i).css('background-color', colors[i]);
      addColorClickListener(li.eq(i), i, colors[i]);
    }
  }

  function addColorClickListener($li, i, color) {
    $li.click(function () {
      json.fontcolor = i;
      closeColor();
      setInputboxColor(i);
    });
  }

  function addEmojiModel(){
    var tds = $table.find('td');
    var names = model.names;
    var titles = model.titles;
    var len = names.length;

    for(var i = 0; i < len; i++){
      tds.eq(i).html($('<img>').attr('src', 'static/images/def/def_' + names[i] + '.gif').attr('title', titles[i]));
      addEmojiClickListener(tds.eq(i), '/'+names[i]);
    }
  }

  function addEmojiClickListener($td, img){
    $td.click(function(){
      //alert(QT.get_emofile_onshortcut(img))
      window.inputbox.insert_image(QT.get_emofile_onshortcut(img), img);
      close();
      closeColor();
    });
  }
  self.func(function(){

  })
});