Class(function(extend, using, self){
    extend("pages/page");
    using("lib/jquery.min.js");

    self.info_ref = null;
    self.keymode_type = 0;
    self.init_status = 0;
    self.devide_vol_val = 0;
    self.devide_mic_val = 0;
    self.music_flag = 1;
    self.flag_tag = 1;

    // 绑定初始化
    self.initPage = function () {
        this.init_status = 1;
        this.bindPageInfo();
    }

    // 绑定初始化
    self.bindPageInfo = function (index) {
        var ico_box_vol = $(".voice>span");
        var ico_box_mic = $(".microphone>.ico-box-mic");
        var ico_music_vol = $(".music>.c-ico-music-ing");
        var s_mode = $(".c-click-popup-say-mode");
        var devide_vol_is_disable = this.info_ref.is_mute(0);
        var devide_mic_is_disable = this.info_ref.is_mute(1);
        var music_vol_is_disable = this.info_ref.is_mute(2);
        var audio_key_info = this.info_ref.get_audio_keymode();
        if (devide_vol_is_disable == false) {
            ico_box_vol.addClass("disabled");
        } else {
            ico_box_vol.removeClass("disabled")
                       .removeClass("middle")
                       .removeClass("big")
                       .removeClass("small");
        }

        if (devide_mic_is_disable == false) {
            ico_box_mic.addClass("disabled");
        } else {
            ico_box_mic.removeClass("disabled")
                       .removeClass("middle")
                       .removeClass("small");
        }

        if (music_vol_is_disable == true) {
            if(ico_music_vol.hasClass("disabled")) {
                ico_music_vol.removeClass("disabled");
            }
        } else {
            ico_music_vol.addClass("disabled");
        }

        var key_type = audio_key_info.keytype;
        if(key_type == 0) {
            s_mode.prev().removeClass('c-speak-png');
            this.keymode_type = 0;
            s_mode.text("自由说话");
        }

        if(key_type == 1) {
            this.keymode_type = 1;
            s_mode.prev().addClass('c-speak-png');
            key_name = "按" + audio_key_info.keyname + "说话";
            s_mode.text(key_name);
        }
    }
    self.settingMusicStatus = function(status) {
        if(status == 1) {
            this.music_flag = 1;
            $(".music")
                .removeClass("disabled")
                .addClass("disabled")
        } else {
            this.music_flag = 0;
            $(".music").removeClass("disabled")
        }
    }
    self.setMicStatus = function(status) {
        if(status == 1){
            $(".microphone>.ico-box-mic")
                .removeClass("disabled")
                .removeClass("middle")
                .removeClass("small");
        }
    }

    self.func(function(curData){
        var that = this;
        that.addCall("vol_status", 0);
        that.addCall("mic_status", 0);

        // 初始化改变静音状态(异步)
        that.addCall("volumeNewState", function( type, state) {
            var ico_box_vol = $(".voice>span");
            var ico_box_mic = $(".microphone>.ico-box-mic");
            var ico_music_vol = $(".music>.c-ico-music-ing");
            if (type == 0) {
                if(state == 0) {
                    ico_box_vol.addClass("disabled");
                } else {
                    ico_box_vol.removeClass("disabled").removeClass("middle").removeClass("big").removeClass("small");
                }
            }
            if (type == 1) {
                if(state == 0) {
                    ico_box_mic.addClass("disabled");
                } else {
                    ico_box_mic.removeClass("disabled").removeClass("middle").removeClass("small");
                }
            }
            if (type == 2) {
                if(state == 0) {
                    ico_music_vol.removeClass("disabled");
                } else {
                    ico_music_vol.addClass("disabled");
                }
            }

        });


        that.addCall("change_popup_music_status", function() {
            var click_popup_val = $("span.c-click-popup-music").text();
            if(click_popup_val == "伴奏中") {
                $(".c-click-popup-music").prev().toggleClass('c-music-ing');
                $("span.c-click-popup-music").text("播放伴奏");
            }
        });

        that.addCall("reset_play_music_stauts", function(flag) {
            if (flag == true) {
                var click_popup_val = $("span.c-click-popup-music").text();
                if (click_popup_val == "播放伴奏") {
                    $(".c-click-popup-music").prev().toggleClass('c-music-ing');
                    $("span.c-click-popup-music").text("伴奏中");
                }

                if (click_popup_val == "伴奏中") {
                    $(".c-click-popup-music").prev().toggleClass('c-music-ing');
                    $("span.c-click-popup-music").text("播放伴奏");
                }
            }
        });

        // 用于刷新麦克风和扬声器的动态音量值
        that.addCall("on_refresh_device_dynamic_vol", function (type, vol) {
            if(type == 0) {
                if(vol == 0) {
                    $(".voice>span").removeClass("middle").removeClass("big").removeClass("small");
                }
                if(vol > 0 && vol < 10) {
                    $(".voice>span").removeClass("disabled").removeClass("middle").removeClass("big").addClass("small");
                }
                if(vol >= 10 && vol < 30 ) {
                    $(".voice>span").removeClass("disabled").removeClass("small").removeClass("big").addClass("middle");
                }
                if(vol >= 30 ) {
                    $(".voice>span").removeClass("disabled").removeClass("small").removeClass("middle").addClass("big");
                }
                //设置扬声器状态setSpeakerPercent(vol);
            }

            if(type == 1) {
                if(vol == 0) {
                    $(".microphone > .ico-box-mic").removeClass("middle").removeClass("small");
                }
                if(vol > 0 && vol < 50) {
                    $(".microphone > .ico-box-mic").removeClass("disabled").removeClass("middle").addClass("small");
                }
                if(vol >= 50 && vol <= 100 ) {
                    $(".microphone > .ico-box-mic").removeClass("disabled").removeClass("small").addClass("middle");
                }
            }

            if(type == 2) {
                // 设置麦克风状态setMicPercent(vol);
            }
        });

        // 重置界面状态
        that.addCall("resetStatus", function () {
            that.bindPageInfo();
        })

        // 切换模式(异步调用)
        that.addCall("on_update_keymode", function ( key_type, key_code, key_name) {
            var s_mode = $(".c-click-popup-say-mode");
            if(key_type == 0) {
                if(that.keymode_type == 1) {
                    s_mode.prev().removeClass('c-speak-png');
                    that.keymode_type = 0;
                }
                s_mode.text("自由说话");
            }

            if(key_type == 1) {
                if(that.keymode_type == 0) {
                    s_mode.prev().addClass('c-speak-png');
                    that.keymode_type = 1;
                }
                keyname = "按" + key_name + "说话";
                s_mode.text(keyname);
            }
        })

        that.addCall("notify_mic_mode", function (mode) {
            if(mode == 1 )
            {
                $(".music").attr("title","仅在麦序模式下方可播放伴奏");
                that.settingMusicStatus(1);
            } else if( mode == 3 && that.music_flag == 1) {
                //在麦序模式下且不可以点击状态（不再麦序首位和不是控麦）
                $(".music").attr("title","须处于麦序首位或控麦状态才可播放伴奏");
                that.settingMusicStatus(1);
            }
        })

        that.addCall("change_music_button_state", function (type, state) {
            if(state == 1) {
                $(".music").attr("title","");
                that.settingMusicStatus(0);} else{$(".music").attr("title","须处于麦序首位或控麦状态才可播放伴奏");
                that.settingMusicStatus(1);
            }
        })


        // 更改系统设置刷新麦克风和扬声器的音量值
        that.addCall("on_refresh_audio_volume", function  (type, vol) {
            if(type == 0) {
                if($(".voice > span").hasClass("disabled")) {
                    $(".voice > span").removeClass("disabled");
                }
            }
            if(type == 1) {
                if($(".microphone>.ico-box-mic").hasClass("disabled")) {
                    $(".microphone>.ico-box-mic").removeClass("disabled");
                }
            }
            if(type == 2) {
                if($(".music>.c-ico-music-ing").hasClass("disabled")) {
                    $(".music>.c-ico-music-ing").removeClass("disabled");
                }
            }
        })

        // message 房间底部
        that.addCall("msgflash", function ( flag)  {
            if(flag == 0) {
                $(".message").find("#infos").hide();
                $(".message").find(".anim").hide();
            }

            if(flag == 1) {
                $(".message").find("#infos").show();
                $(".message").find(".anim").hide();
            }

            if(flag == 2) {
                $(".message").find("#infos").show();
                $(".message").find(".anim").show();
            }
        })

        this.info_ref = curData;;
        this.sup().constructor(curData);

        this.initPage();
        this.initEvent();

    })

    self.initEvent = function(){
        var that = this;
        // 音量条显示
        $(document).delegate(".ico-box-vol", "mouseenter", function () {
            that.info_ref.btnSlider_show(0);
        })

        // 音量条显示
        $(document).delegate(".ico-box-vol", "mouseleave", function () {
            that.info_ref.btnSlider_hide(0);
        })

        // 音量静态状态切换
        $(document).delegate(".ico-box-vol", "click", function () {
            if($(".voice > span").hasClass("disabled")) {
                $(".voice > span").removeClass("disabled");
                that.info_ref.set_mute( 0, true);
            } else{
                $(".voice > span").removeClass("small").removeClass("middle").removeClass("big").addClass("disabled");
                that.info_ref.set_mute( 0, false);
            }
        });


        /* 麦克风静音状态转换*/
        $(document).delegate(".ico-box-mic", "mouseenter", function () {
            that.info_ref.btnSlider_show(1);
        });

        /* 麦克风静音状态转换*/
        $(document).delegate(".ico-box-mic", "mouseleave", function () {
            that.info_ref.btnSlider_hide(1);
        });

        /* 麦克风静音状态转换*/
        $(document).delegate(".ico-box-mic", "click", function () {
            if($(".microphone>.ico-box-mic").hasClass("disabled")) {
                $(".microphone>.ico-box-mic").removeClass("disabled");
                that.info_ref.set_mute( 1, true);
            } else{
                $(".microphone>.ico-box-mic").removeClass("small").removeClass("middle").addClass("disabled");
                that.info_ref.set_mute( 1, false);
            }
        });

        /* 播放伴奏状态转换(进入)*/
        $(document).delegate(".c-ico-music-ing", "mouseenter", function () {
            that.info_ref.btnSlider_show(2);
        });

        /* 播放伴奏状态转换(移开)*/
        $(document).delegate(".c-ico-music-ing", "mouseleave", function () {
            that.info_ref.btnSlider_hide(2);
        });

        /* 播放伴奏状态(点击)*/
        $(document).delegate(".c-ico-music-ing", "click", function () {
            if(that.music_flag == 1) {return;}
            var music_vol_is_disable = that.info_ref.is_mute(2);
            var ico_music_vol = $(".music>.c-ico-music-ing");
            if (music_vol_is_disable == true) {
                ico_music_vol.addClass("disabled");
                that.info_ref.set_mute( 2, false);
            } else {
                if(ico_music_vol.hasClass("disabled")) {
                    ico_music_vol.removeClass("disabled");
                }
                that.info_ref.set_mute( 2, true);
            }
        });



        /*改变伴奏状态*/
        $(document).delegate(".c-click-popup-music", "click", function () {
            if(that.music_flag == 1) {return;}
            var click_popup_val = $("span.c-click-popup-music").text();
            var flag = that.info_ref.btn_play_bgmusic_click();
            if(flag == true) {
                if(click_popup_val == "播放伴奏") {
                    $(this).prev().toggleClass('c-music-ing');
                    $("span.c-click-popup-music").text("伴奏中");
                }

                if(click_popup_val == "伴奏中") {
                    $(this).prev().toggleClass('c-music-ing');
                    $("span.c-click-popup-music").text("播放伴奏");
                }
            }
        });

        /*改变说话方式状态*/
        $(document).delegate(".c-click-popup-say-mode,.c-speak-click-png", "click", function () {
            that.info_ref.change_audio_keymode();
            var audio_key_info = that.info_ref.get_audio_keymode();
            var key_type = audio_key_info.keytype;
            if(key_type == 0) {
                if(that.keymode_type == 1) {
                    $(".c-speak-click-png").removeClass('c-speak-png');
                    that.keymode_type = 0;
                }
                $(".c-click-popup-say-mode").text("自由说话");
            }

            if(key_type == 1) {
                if(that.keymode_type == 0) {
                    that.keymode_type = 1;
                    $(".c-speak-click-png").addClass('c-speak-png');
                }
                key_name = "按" + audio_key_info.keyname + "说话";
                $(".c-click-popup-say-mode").text(key_name);
            }
        });


        /* 点击显示语音检测按钮事件*/
        $(document).delegate(".c-ico-box-arrow", "click", function () {
            that.info_ref.btn_audio_check_click();
        });

        /*点击显示播放器列表按钮*/
        $(document).delegate(".music .c-click-popup", "click", function () {
            if(that.music_flag == 1) {return;}
            that.info_ref.btn_play_device_click();
        });


        /*点击下拉出按键模式菜单按钮*/
        $(document).delegate(".speak .c-popup-type", "click", function () {
            that.info_ref.btn_key_mode_click();
        });



        /* 点击查看未读信息 (message)  */
        $(document).delegate(".message_af", "click", function () {
            that.info_ref.showunreadmsg(40);
        });
    }

});