/**
 * @author pei-qiao.peng
 * @date   2015/1/16.
 * @email  ppq1991@gmail.com
 * @github https://github.com/ppq1991/
 * @blog   http://pengpeiqiao.tk/
 */
Class(function(extend, using, self){

  var $drag = $('#drag');
  var $dragChildren = $drag.children();
  var $dragPost = $('#drag-post');
  var $dragMic = $('#drag-mic');
  var $dragToggle = $('#drag-toggle');

  var isAnimating = false;

  var addDragPostListener = function(){
    $dragPost.click(function(){
        if(!isAnimating){
            var $this = $(this);
            slideUpAll();
            $this.addClass('active');
            isAnimating = true;
            setTimeout(function(){
                isAnimating = false;
            }, 500);
            window.chat.pull_down(true);
            window.chat.notice_card_switch(1);
            $dragToggle.hasClass('down') && $dragToggle.click()
        }
    });
  }

  var addDragMicListener = function(){
        $dragMic.click(function(){
            if(!isAnimating){
                var $this = $(this);
                slideUpAll();
                $this.addClass('active');
                isAnimating = true;
                setTimeout(function(){
                    isAnimating = false;
                }, 800);
                window.chat.pull_down(true);
                window.chat.notice_card_switch(0);
                $dragToggle.hasClass('down') && $dragToggle.click()
            }
        });
    }

  var addDragToggleListener = function(){
        $dragToggle.click(function(){
            var $this = $(this);
            $this.toggleClass('down');
            window.chat.pull_down(!$this.hasClass('down'));

        });
  }
  var addDragListener = function(){
    addDragPostListener();
    addDragMicListener();
    addDragToggleListener();
  }

  var slideUpAll = function(){
    $dragChildren.removeClass('active');
  }

  self.run = function(){
    addDragListener();
  };

  self.func(function(){
      // n 从左到右 0,1,2 -> 开黑, 公告, 名片, true 显示, false 隐藏
      window.on_show_card = function (n, b) {
          if(n === 1){
              if(b){
                  $dragPost.show();
              }else{
                  $dragPost.hide();
              }
          }
          if(n === 2){
              if(b){
                  $dragMic.show();
              }else{
                  $dragMic.hide();
              }
          }
      };

      window.on_set_animate = function (n) {
          window.chat.pull_down(true);
          if(n == 0){
              slideUpAll();
              $dragPost.addClass('active');
          }
          if(n == 1){
              slideUpAll();
              $dragMic.addClass('active');
          }
      };

      window.on_set_dropdown_status = function(n){
          if(n == 0){
              $dragToggle.addClass('down');
          }
          if(n == 1){
              $dragToggle.removeClass('down');
          }
      };
  })


});