/**
 * @author pei-qiao.peng
 * @date   2015/1/15.
 * @email  ppq1991@gmail.com
 * @github https://github.com/ppq1991/
 * @blog   http://pengpeiqiao.tk/
 */

Class(function(extend, using, self){
  'use strict';

  var DEFAULT = {
    chatWindowClassName : 'ac-chat'
  };

  var $win = $(window);
  var $inputContainer = $('#input-container');
  var $inputBox = $('#input-box');
  var $chatWindow;
  var msgCount = 0;
  var inputBoxHeight = 0;
  var scrollLock = false;
  var lazyTimer = 0;

  //require('style/style.css');

  self.bind = function($selector){
    $chatWindow = $selector;
    $chatWindow.addClass(DEFAULT.chatWindowClassName);
    $chatWindow.on('mousewheel, scroll', function(){
      setTimeout(function(){
        scrollLock = !isScrollBottom();
      }, 50);
    });
  };



  self.config = function(config){
    DEFAULT = $.extend({}, DEFAULT, config);
  };

  self.add = function(model){
    $chatWindow.append(model);
    addCount();
    scrollToBottom();
  };

  self.insertToolMsg = function(model){
      $("#input-tools").append(model);
  }

  self.init = function(){
    resetContainer();
    resetInput();
    clear();
    clearInputText();
  };

  self.clear = function(){
    clear();
  };

  self.resetInputBox = function(){
    resetInput();
  };

  self.setInputBoxHeight = function (h) {
    var offset = inputBoxHeight - h;
    if(offset > 1 || offset < -1){
      inputBoxHeight = h;
      setInputHeight(h);
    }
  };

  self.lock = function(b){
    scrollLock = b;
  };

    // private functions
  var scrollToBottom = function(){
    if(!scrollLock){
        $chatWindow.scrollTop(getScrollHeight());
    }
    return false;
  }

  var addCount = function(){
        var ref, height, scroll;
        msgCount++;
        if(msgCount > 200){
            scroll = getScrollTop();
            ref = $chatWindow.children().eq(0);
            height = ref.height();
            ref.remove();
            setScrollTop(scroll - height);
            msgCount--;
        }
  }

  var getScrollHeight = function(){
    return $chatWindow.get(0).scrollHeight;
  }

  var isScrollBottom = function(){
    return $chatWindow.scrollTop() >= ( getScrollHeight() - $chatWindow.height() );
  }

  var resetContainer = function(){
    $chatWindow.height($win.height() - $inputContainer.height());
    scrollToBottom();
  }

  var clearInputText = function (){
        if(window.inputbox){
            window.inputbox.get_text_clear();
        }
  }

  var resetInput = function(){
    var offset = $inputBox.offset();
    if(window.inputbox){
        window.inputbox.set_input_rect(offset.left, offset.top, $inputBox.width() - 60, 31);
    }
  }

  var setInputHeight = function(h){
        $inputBox.height(h);
        resetContainer();
        var offset = $inputBox.offset();
        window.inputbox.set_input_rect(offset.left, offset.top, $inputBox.width() - 60, h);
  }

  var clear = function(){
      $chatWindow.html('');
      msgCount = 0;
  }

  var getScrollPercent = function(){
    return getScrollTop() / getScrollHeight();
  }

  var setScrollTop = function(n){
    $chatWindow.scrollTop(n);
  }

  var getScrollTop = function(){
    return $chatWindow.scrollTop();
  }

  // listeners
  $win.load(function(){

  });

  self.func(function(){
      $win.resize(function(){
          resetContainer();
          resetInput();
          scrollToBottom();
      });
  })
});