/**
 * @author pei-qiao.peng
 * @date   2015/1/22.
 * @email  ppq1991@gmail.com
 * @github https://github.com/ppq1991/
 * @blog   http://pengpeiqiao.tk/
 */

Class(function (extend, using, self) {
  'use strict';

  var Plugin = function ($box, QT) {
    this.$box = $box;
    this.QT = QT;
    this.init();
    this.timer = [];
    this.lastTime = 5000;
    this.delay = 500;
  };

  Plugin.prototype = {
    init: function () {
      var that = this;
      this.$box.addClass('ac-broadcast').css({
        "white-space":"nowrap",
        "text-overflow":"ellipsis",
        "-o-text-overflow":"ellipsis",
        "overflow": "hidden"
    });
      //require('style/broadcast.css');
      this.$box.on('click', function () {
        that.QT.show_last_broadcast();
        that.hide();
      });
    },
    show: function (text) {
      var that = this;
      this.clearTimer();
      this.$box.text(text).show().css('opacity', 1);
      this.timer[1] = setTimeout(function () {
        that.hide();
      }, this.lastTime);
    },
    hide: function () {
      var that = this;
      this.$box.css('opacity', 0);
      this.timer[0] = setTimeout(function () {
        that.$box.hide();
      }, this.delay);
    },
    clearTimer: function () {
      clearTimeout(this.timer[0]);
      clearTimeout(this.timer[1]);
    }
  };

  self.func(function($box, QT){
      return new Plugin($box, QT);
  })

});