﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using QQPlus.Framework.SDK;

namespace QQPlus.DemoPlugin
{
    public class Class1 : Plugin
    {
        public Class1()
        {
            this.Id = "QQPlus.DemoPlugin";
            this.PluginName = "演示插件";
            this.Description = "报时功能";
            this.Author = "QQPlus";

        }

        public override bool Install()
        {
            //这里在安装插件时执行，可以在这里初始化数据库

            return base.Install();
        }

        public override bool Start()
        {
            //安装成功后或者下次启动机器人时执行，可以在这里初始化插件一些信息，例如放入数据载入内存


            //初始化sdk，订阅自己感兴趣的事件，比如收到qq消息、群消息、抖动等
            sdk = new QQClientSDK();
            sdk.ReceiveNormalIM += new EventHandler<ReceiveNormalIMQQEventArgs>(sdk_ReceiveNormalIM);
            sdk.ReceiveClusterIM += new EventHandler<ReceiveClusterIMQQEventArgs>(sdk_ReceiveClusterIM);

            return base.Start();
        }

        void sdk_ReceiveClusterIM(object sender, ReceiveClusterIMQQEventArgs e)
        {
            if (e.Message == "时间")
                client.SendClusterMessage(e.Cluster.ExternalId, DateTime.Now.ToString());
        }

        void sdk_ReceiveNormalIM(object sender, ReceiveNormalIMQQEventArgs e)
        {
            if (e.Message == "时间")
            {
                client.SendMessage(e.QQ, DateTime.Now.ToString());
            }


            //还可以增加其他方法，比如获取5个成员
            if (e.Message == "5")
            {
                var friends = client.User.Friends.Take(5).ToList();
                StringBuilder sb = new StringBuilder();
                friends.ForEach(f => sb.AppendLine(f.ToString()));
                client.SendMessage(e.QQ, sb.ToString());

                //如果此插件处理完毕，不需要后面的插件再处理，则设置：e.Cancel = true;
                e.Cancel = true;
            }

            {
                //示例代码：
                var friends = client.User.Friends;//获取全部好友
                var clusters = client.User.Clusters;//获取全部群
                var cluster = client.User.Clusters.FirstOrDefault(c => c.ExternalId == 123456u);//获取一个群，这里只能获取自己加入的群
                if (clusters != null)
                {
                    var members = cluster.members;//全部群成员
                }

                var friend = client.GetFriend(1111111u);//获取qq信息
                cluster = client.GetCluster(123456u);//获取群信息（这里可以获取机器人没有加入的群，但是tx可能会有频率限制，所以不要频繁使用）

            }
        }

        public override bool Stop()
        {
            //卸载插件时执行（关闭机器人不会执行此函数，所以数据要自己负责随时写入数据库或者文件，不能依赖这里
            return base.Stop();
        }

        public override bool UnInstall()
        {
            //卸载插件时执行，在Stop后执行，如有必要可以在这里清理数据库，建议不要删除数据、数据库，因为只要卸载插件，插件就不会占用机器人的资源，不影响机器人运行

            return base.UnInstall();
        }
    }
}
