﻿using QQPlus.Framework;
using QQPlus.Framework.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace QQPlusDemo
{
    class Program
    {
        static QQClient client;
        static void Main(string[] args)
        {
            uint qq;
            string password;
            Console.Write("请输入QQ：");
            qq = uint.Parse(Console.ReadLine());
            Console.Write("请输入密码：");
            password = Console.ReadLine().Trim();

            client = new QQClient(qq, password);
            client.ReceiveNormalIM += client_ReceiveNormalIM;
            client.LoginStatusChanged += client_LoginStatusChanged;
            client.Login();
            Console.WriteLine("按任意键退出");
            Console.Read();
            client.Logout();
        }

        static void client_LoginStatusChanged(object sender, QQPlus.Framework.SDK.LoginStatusChangedQQEventArgs e)
        {
            if (e.LoginStatus == LoginStatus.NeedVerifyCode)
            {
                Console.Write("请输入验证码（验证码在软件目录下)：");
                string code = Console.ReadLine().Trim();
                client.SendVerifyCode(code);
            }
            else
                Console.WriteLine("{0} {1}", e.LoginStatus, e.Other);
        }

        static void client_ReceiveNormalIM(object sender, QQPlus.Framework.SDK.ReceiveNormalIMQQEventArgs e)
        {
            client.SendMessage(e.QQ, e.Message);
        }
    }
}
