﻿    
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace KuGo.Web.Admin
{
    public partial class OrdersForm : Page
    {       
      protected void Page_Load(object sender, EventArgs e)
      {
          if (!Page.IsPostBack)
          {
              if (Request.Params["id"] != null && Request.Params["id"].Trim() != ""){
                string strId = Request.Params["id"];
                
                int id = Convert.ToInt32(strId);
                 
                ShowInfo(id);
              }else {
                this.OrderIDTextBox.Text = "0";//新建记录
              }
          }
      }
      /// <summary>
      /// 显示一条 数据，为了修改
      /// </summary>
      /// <param name="OrderID">主键</param>
      private void ShowInfo(int OrderID)
      {
          KuGo.Model.Orders model = new KuGo.BLL.OrdersBLL().GetModel(OrderID);
          if (model != null) {
          OrderIDTextBox.Text=model.OrderID.ToString();
        CustomerIDTextBox.Text=model.CustomerID;
        EmployeeIDTextBox.Text=model.EmployeeID.ToString();
        OrderDateTextBox.Text=model.OrderDate.ToString("yyyy-MM-dd HH:mm:ss");
        RequiredDateTextBox.Text=model.RequiredDate.ToString("yyyy-MM-dd HH:mm:ss");
        ShippedDateTextBox.Text=model.ShippedDate.ToString("yyyy-MM-dd HH:mm:ss");
        ShipViaTextBox.Text=model.ShipVia.ToString();
        FreightTextBox.Text=model.Freight.ToString();
        ShipNameTextBox.Text=model.ShipName;
        ShipAddressTextBox.Text=model.ShipAddress;
        ShipCityTextBox.Text=model.ShipCity;
        ShipRegionTextBox.Text=model.ShipRegion;
        ShipPostalCodeTextBox.Text=model.ShipPostalCode;
        ShipCountryTextBox.Text=model.ShipCountry;
                    
          //设置操作状态
          AccessStateHidden.Value = "修改";
        }
      }

      /// <summary>
      /// 保存一条 数据
      /// </summary>
      /// <param name="sender"></param>
      /// <param name="e"></param>
      public void btnSave_Click(object sender, EventArgs e){
          string strErr = ""; 
          if (strErr != ""){
            //请在客户端验证
            return;
          }
          KuGo.Model.Orders model = new KuGo.Model.Orders();
          //
        model.OrderID =(OrderIDTextBox.Text !="")? Convert.ToInt32(OrderIDTextBox.Text): 0;
        model.CustomerID =CustomerIDTextBox.Text;
        model.EmployeeID =(EmployeeIDTextBox.Text !="")? Convert.ToInt32(EmployeeIDTextBox.Text): 0;
        model.OrderDate =(OrderDateTextBox.Text !="")? Convert.ToDateTime(OrderDateTextBox.Text): System.DateTime.Now;
        model.RequiredDate =(RequiredDateTextBox.Text !="")? Convert.ToDateTime(RequiredDateTextBox.Text): System.DateTime.Now;
        model.ShippedDate =(ShippedDateTextBox.Text !="")? Convert.ToDateTime(ShippedDateTextBox.Text): System.DateTime.Now;
        model.ShipVia =(ShipViaTextBox.Text !="")? Convert.ToInt32(ShipViaTextBox.Text): 0;
        model.Freight =(FreightTextBox.Text !="")? Convert.ToInt32(FreightTextBox.Text): 0;
        model.ShipName =ShipNameTextBox.Text;
        model.ShipAddress =ShipAddressTextBox.Text;
        model.ShipCity =ShipCityTextBox.Text;
        model.ShipRegion =ShipRegionTextBox.Text;
        model.ShipPostalCode =ShipPostalCodeTextBox.Text;
        model.ShipCountry =ShipCountryTextBox.Text;
        
        string msginfo = "";
        KuGo.BLL.OrdersBLL bll = new KuGo.BLL.OrdersBLL();
       
        if (AccessStateHidden.Value != "修改"){        
            if (bll.Insert(model)){
              Response.Write(" <script>alert('保存新增数据成功！');window.location.href='OrdersForm.aspx?id=" + model.OrderID.ToString() + "';</script>");
            }else
              msginfo = bll.GetLastError();
        }else{
            if (bll.Update(model)){
              Response.Write("<script>alert('保存修改数据成功！');window.location.href='OrdersForm.aspx?id=" + model.OrderID.ToString() + "';</script>");
        }else{
            msginfo = bll.GetLastError();
        }
        if (msginfo != ""){
          Response.Write("<script>alert('保存失败！');</script>");//
          Response.Write("<script>alert('原因：" + msginfo + "！');</script>");//
        }
      }
    }
    
    public void btnCancle_Click(object sender, EventArgs e){
      Response.Redirect("OrdersList.aspx");
    }
  }
}
  