﻿if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Shippers_Insert]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
    drop procedure [dbo].[Shippers_Insert]
GO
------------------------------------
-- 功能描述：增加一条记录 
-- 所属表格：Shippers[ ]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
DECLARE @ShipperID int -- 运货商ID
    SET @ShipperID = 
DECLARE @CompanyName nvarchar(40) -- 公司名称
    SET @CompanyName =  ' '
DECLARE @Phone nvarchar(24) -- 电话
    SET @Phone =  ' '
 -- 调用存储过程 
 exec [Shippers_Insert] @ShipperID,@CompanyName,@Phone
 */
------------------------------------
CREATE PROCEDURE [Shippers_Insert] (
@ShipperID    int = NULL,            -- 运货商ID
@CompanyName  nvarchar(40) = NULL,   -- 公司名称
@Phone        nvarchar(24) = NULL    -- 电话

)
AS
INSERT INTO Shippers(
	[CompanyName],[Phone]	 
)VALUES( 
	@CompanyName,@Phone	
)
SELECT @ID = SCOPE_IDENTITY() -- 返回新加记录的唯一标识
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Shippers_Edit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Shippers_Edit]
GO
------------------------------------
-- 功能描述：修改一条记录 
-- 所属表格：Shippers[]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /* -- 测试代码 --
 -- 参数设置 
DECLARE @ShipperID int -- 运货商ID
    SET @ShipperID = 
DECLARE @CompanyName nvarchar(40) -- 公司名称
    SET @CompanyName =  ' '
DECLARE @Phone nvarchar(24) -- 电话
    SET @Phone =  ' '
 -- 调用存储过程 
 exec [Shippers_Edit] @ShipperID,@CompanyName,@Phone 
 */
------------------------------------
CREATE PROCEDURE [Shippers_Edit]
@ShipperID    int = NULL,            -- 运货商ID
@CompanyName  nvarchar(40) = NULL,   -- 公司名称
@Phone        nvarchar(24) = NULL    -- 电话

AS 
UPDATE Shippers SET 
	 [CompanyName] = @CompanyName, [Phone] = @Phone
WHERE 
	 [ShipperID] = @ShipperID
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Shippers_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Shippers_Delete]
GO
------------------------------------
-- 功能描述：删除一条记录 
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
 -- 调用存储过程 
DECLARE @ID int
    set @ID=0
 exec [Shippers_Delete] @ID
 */
------------------------------------
CREATE PROCEDURE [Shippers_Delete]
	@ShipperID int --待删除的主键
AS 
   
	    DELETE FROM [Shippers]	    WHERE ShipperID = @ShipperID 
     
     
GO   
     


