﻿    
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace Kugo.Web.Admin
{
    public partial class CategoriesForm : Page
    {       
      protected void Page_Load(object sender, EventArgs e)
      {
          if (!Page.IsPostBack)
          {
              if (Request.Params["id"] != null && Request.Params["id"].Trim() != ""){
                string strId = Request.Params["id"];
                
                int id = Convert.ToInt32(strId);
                 
                ShowInfo(id);
              }else {
                this.CategoryIDTextBox.Text = "0";//新建记录
              }
          }
      }
      /// <summary>
      /// 显示一条 数据，为了修改
      /// </summary>
      /// <param name="CategoryID">主键</param>
      private void ShowInfo(int CategoryID)
      {
          Kugo.Model.Categories model = new Kugo.BLL.CategoriesBLL().GetModel(CategoryID);
          if (model != null) {
          CategoryIDTextBox.Text=model.CategoryID.ToString();
        CategoryNameTextBox.Text=model.CategoryName;
        DescriptionTextBox.Text=model.Description;
        PictureTextBox.Text=model.Picture;
                    
          //设置操作状态
          AccessStateHidden.Value = "修改";
        }
      }

      /// <summary>
      /// 保存一条 数据
      /// </summary>
      /// <param name="sender"></param>
      /// <param name="e"></param>
      public void btnSave_Click(object sender, EventArgs e){
          string strErr = ""; 
          if (strErr != ""){
            //请在客户端验证
            return;
          }
          Kugo.Model.Categories model = new Kugo.Model.Categories();
          //
        model.CategoryID =(CategoryIDTextBox.Text !="")? Convert.ToInt32(CategoryIDTextBox.Text): 0;
        model.CategoryName =CategoryNameTextBox.Text;
        model.Description =DescriptionTextBox.Text;
        model.Picture =PictureTextBox.Text;
        
        string msginfo = "";
        Kugo.BLL.CategoriesBLL bll = new Kugo.BLL.CategoriesBLL();
       
        if (AccessStateHidden.Value != "修改"){        
            if (bll.Insert(model)){
              Response.Write(" <script>alert('保存新增数据成功！');window.location.href='CategoriesForm.aspx?id=" + model.CategoryID.ToString() + "';</script>");
            }else
              msginfo = bll.GetLastError();
        }else{
            if (bll.Update(model)){
              Response.Write("<script>alert('保存修改数据成功！');window.location.href='CategoriesForm.aspx?id=" + model.CategoryID.ToString() + "';</script>");
        }else{
            msginfo = bll.GetLastError();
        }
        if (msginfo != ""){
          Response.Write("<script>alert('保存失败！');</script>");//
          Response.Write("<script>alert('原因：" + msginfo + "！');</script>");//
        }
      }
    }
    
    public void btnCancle_Click(object sender, EventArgs e){
      Response.Redirect("CategoriesList.aspx");
    }
  }
}
  