﻿    using System;
    using System.Collections.Generic;
    using System.Data;
    using System.Text;
    using Kugo.Model;
    namespace Kugo.IDAL {

    /// <summary>
    /// （CustomerDemographics）
    /// </summary>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public interface ICustomerDemographics{ 
 
    /// <summary>
    /// 返回DAL最后的底层异常信息
    ///</summary>
    /// <returns>异常信息</returns>
    string GetLastError();

    #region 常规常用方法 查询数据 Exists()、GetModel()、GetList()、GetRecordCount()、GetPage()
    /// <summary>
    /// 是否存在该记录
    /// </summary>
    /// <param name=CustomerTypeID>主键值</param>
    /// <returns>存在返回True,否则返回False</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    bool Exists(string CustomerTypeID);

    /// <summary>
    /// 根据主键获取一个CustomerDemographics对象实体,可以指定属性
    /// </summary>
    /// <param name=CustomerTypeID>主键值</param>
    /// <returns>返回对象实例或者null</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    Kugo.Model.CustomerDemographics GetModel(string CustomerTypeID);

    /// <summary>
    /// 根据主键获取一个CustomerDemographics对象实体,可以指定属性
    /// </summary>
    /// <param name=CustomerTypeID>主键值</param>
    /// <param name="Fields">要获取的属性名称,即字段名称，多个以逗号“,”分割，获取所有属性留空或者输入null或者“*”</param>
    /// <returns>返回对象实例或者null</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks> 
    Kugo.Model.CustomerDemographics GetModel(string CustomerTypeID, string Fields);

    /// <summary>
    /// 获得数据列表
    /// </summary>
    /// <param name="strWhere">查询条件</param>
    /// <returns>返回DataSet</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    DataSet GetList(string strWhere);

    /// <summary>
    /// 获得前几行数据
    /// </summary>
    /// <param name="Top">记录条数</param>
    /// <param name="fileds">查询字段集合，以逗号,隔开</param>
    /// <param name="strWhere">查询条件</param>
    /// <param name="strOrder">排序方式</param>
    /// <returns>DataSet</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    DataSet GetList(int Top, string fileds, string strWhere, string strOrder);

    /// <summary>
    /// 获取记录总数
    /// </summary>
    /// <param name="strWhere">查询条件</param>
    /// <returns>记录总数</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    int GetRecordCount(string strWhere);

    /// <summary>
    /// 公用万能的获取分页记录的方法
    /// <para>使用前提:表必须有一个自动增长列ID,但不一定是主键</para>
    /// </summary>
    /// <param name="TableName">表名</param>
    /// <param name="Fields">要查询的字段集合,查询所有设为空值或者null或者星号"*"</param>
    /// <param name="strWhere">查询的条件,无条件就设为空值或者null</param>
    /// <param name="PageSize">页面大小，每页显示数据行数</param>
    /// <param name="PageIndex">页码，从1开始，第一页是1</param>
    /// <param name="strOrderBy">排序字段，支持多个字段排序,不排序就设为空值或者null</param>
    /// <returns>返回DataSet或者null</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    DataSet GetPage(string Fields, string strWhere, int PageSize, int PageIndex, string strOrderBy);

    #endregion

    #region 常规常用方法 编辑数据  Insert()、Update()、Delete()、

    /// <summary>
    /// 添加一条新CustomerDemographics记录
    /// </summary>
    /// <param name="model">待保存的对象实例</param>
    /// <returns>返回自动编号，如果不大于0就说明保存数据失败了</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    bool Insert(Kugo.Model.CustomerDemographics model);

    /// <summary>
    /// 更新一条新CustomerDemographics记录
    /// </summary>
    /// <param name="model">待保存的对象实例</param>
    /// <returns>返回影响行数，如果不大于0就说明保存数据失败了</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    bool Update(Kugo.Model.CustomerDemographics model);
    
    /// <summary>
    /// 删除一条或者多条CustomerDemographics记录
    /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
    /// </summary>
    /// <returns>删除成功返回True,否则返回False</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    bool Delete(string CustomerTypeID);

    /// <summary>
    /// 删除一条或者多条CustomerDemographics记录
    /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
    /// </summary>
    /// <param name="AccountIDs">待删除的主键</param>
    /// <returns>返回影响行数，如果等于0就说明删除数据失败了，大于0说明全部或者部分删除成功(因为不是事务操作)</returns>
    /// <remarks>
    /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    int Deletes(string CustomerTypeIDs);
    #endregion

    #region 你增加的新方法
    //
    //
    #endregion
  }
}
  