﻿    // ******************************************************
    // 文件名称(File Name)：       CustomerCustomerDemo.cs
    // 项目名称(Project Name)：    YourProjectName
    // 功能描述(Description)：      （数据模型）
    // 数据表(Tables)：            t_Administrators（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
    // 作者(Author)：              zhaoshunlu
    // 日期(Create Date)：         2014年02月19日 15:20:55
    // 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
    // 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
    // 编码约定：                   命名规则(类名和属性名首字母必须大写)
    // 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
    //******************************************************
	using System;
  using System.Collections.Generic;
  using System.Data;
  using System.Data.SqlClient;
  using System.Text;
  using System.Security.Cryptography;
  using Kugo.IDAL;
  using Kugo.Model;
  using Mengma.DBUtility;
  namespace Kugo.DAL {

      /// <summary>
      /// （CustomerCustomerDemo）
      /// </summary>
      /// <remarks>
      /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
      /// <para>修改人、日期及内容:</para>
      /// </remarks>
      public class CustomerCustomerDemoDAL:ICustomerCustomerDemo{ 
        
		private string strError = ""; 
                        
        public CustomerCustomerDemoDAL() {
          
        }
        
        /// <summary>
        /// 返回DAL最后的底层异常信息    
        ///</summary>
        /// <returns>异常信息</returns>
        public string GetLastError()
        {
          return strError;
        }

        #region 常规常用方法 查询数据 Exists()、GetModel()、GetList()、GetRecordCount()、GetPage()
        /// <summary>
        /// 是否存在该记录   
        ///</summary>
        /// <param name=CustomerID>主键值</param>
        /// <returns>存在返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Exists(string CustomerID)
        {
          string strSql = "SELECT COUNT(1) FROM [CustomerCustomerDemo] WHERE [CustomerID] = @CustomerID";
          SqlParameter[] parameters = { new SqlParameter("@CustomerID", CustomerID) };
          //
          return DbHelperSQL.Exists(strSql, parameters);
        }

        /// <summary>
        /// 根据主键获取一个CustomerCustomerDemo对象实体,可以指定属性
        /// </summary>
        /// <param name=CustomerID>主键值</param>
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public Kugo.Model.CustomerCustomerDemo GetModel(string CustomerID)
        {
          return GetModel(CustomerID, "*");
        }

        /// <summary>
        /// 根据主键获取一个CustomerCustomerDemo对象实体,可以指定属性
        /// </summary>
        /// <param name=CustomerID>主键值</param>
        /// <param name="Fields">要获取的属性名称,即字段名称，多个以逗号“,”分割，获取所有属性留空或者输入null或者“*”</param>
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public Kugo.Model.CustomerCustomerDemo GetModel(string CustomerID, string Fields)
        {
          if (string.IsNullOrEmpty(Fields)) Fields = "*";
          string strSql = string.Format("SELECT TOP 1 {0} FROM [CustomerCustomerDemo] WHERE [CustomerID] = @CustomerID", Fields);
          SqlParameter[] parameters = { new SqlParameter("@CustomerID", CustomerID) };

          SqlDataReader dr = DbHelperSQL.ExecuteReader(strSql.ToString(), parameters);
          if (dr.HasRows){
            Kugo.Model.CustomerCustomerDemo model = new Kugo.Model.CustomerCustomerDemo();
            while (dr.Read()){
              model.CustomerID = Convert.IsDBNull(dr["CustomerID"]) ? "" : Convert.ToString(dr["CustomerID"]);
			  model.CustomerTypeID = Convert.IsDBNull(dr["CustomerTypeID"]) ? "" : Convert.ToString(dr["CustomerTypeID"]);
			   
            }
            dr.Close();
            return model;
          }else{
            dr.Close();
            return null;
          }
        }

        /// <summary>
        /// 获得数据列表
        /// </summary>
        /// <param name="strWhere">查询条件</param>
        /// <returns>返回DataSet</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(string strWhere)
        {
            return GetList(0, null, strWhere, null);
        }

        /// <summary>
        /// 获得前几行数据
        /// </summary>
        /// <param name="Top">记录条数</param>
        /// <param name="fileds">查询字段集合，以逗号,隔开</param>
        /// <param name="strWhere">查询条件</param>
        /// <param name="strOrder">排序方式</param>
        /// <returns>DataSet</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(int Top, string fileds, string strWhere, string strOrder)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("SELECT ");
            if (Top > 0)
            {
            strSql.Append(" TOP ");
            strSql.Append(Top);
            strSql.Append(" ");
            }
            if (!string.IsNullOrEmpty(fileds)){
            strSql.Append(fileds);
            }else{
            strSql.Append(" CustomerID,CustomerTypeID  ");
            }
            strSql.Append(" FROM [CustomerCustomerDemo] ");
            if (strWhere.Trim() != "")
            {
            strSql.Append(" WHERE ");
            strSql.Append(strWhere);
            }
            if (!string.IsNullOrEmpty(strOrder))
            {
            strSql.Append(" ORDER BY ");
            strSql.Append(strOrder);
            }
            return DbHelperSQL.Query(strSql.ToString());
        }

        /// <summary>
        /// 获取记录总数
        /// </summary>
        /// <param name="strWhere">查询条件</param>
        /// <returns>记录总数</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int GetRecordCount(string strWhere){
            string strSql = "SELECT COUNT(1) FROM [CustomerCustomerDemo] ";
            if (strWhere.Trim() != "")
                strSql += " WHERE " + strWhere;

            object obj = DbHelperSQL.GetSingle(strSql);
            return (obj == null) ? 0 : Convert.ToInt32(obj);
        }

        /// <summary>
        /// 公用万能的获取分页记录的方法
        /// <para>使用前提:表必须有一个自动增长列ID,但不一定是主键</para>
        /// </summary>
        /// <param name="TableName">表名</param>
        /// <param name="Fields">要查询的字段集合,查询所有设为空值或者null或者星号"*"</param>
        /// <param name="strWhere">查询的条件,无条件就设为空值或者null</param>
        /// <param name="PageSize">页面大小，每页显示数据行数</param>
        /// <param name="PageIndex">页码，从1开始，第一页是1</param>
        /// <param name="strOrderBy">排序字段，支持多个字段排序,不排序就设为空值或者null</param>
        /// <returns>返回DataSet或者null</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetPage(string Fields, string strWhere, int PageSize, int PageIndex, string strOrderBy)
        {
            //SQL2000使用次方法分页
            //string basdSql = "select top {0} {1} from [CustomerCustomerDemo] where ProductID not in(select top {2} ProductID from [Products] {3} {4}) {5} {6}";
            //SQL2005及以上使用次方法分页
            string basdSql = "SELECT TOP {0} * FROM (SELECT ROW_NUMBER() OVER ({1}) AS __RowNumber,{2} FROM [CustomerCustomerDemo] {3}) AS T WHERE T.__RowNumber > {4} AND T.__RowNumber <= {5} {6}";

            if (PageSize <= 0) PageSize = 10;
            if (PageIndex <= 0) PageIndex = 1;
            if (string.IsNullOrEmpty(Fields)) Fields = "*";
            strOrderBy = (!string.IsNullOrEmpty(strOrderBy)) ? strOrderBy = " ORDER BY " + strOrderBy : "";
            string strWhere1 = (!string.IsNullOrEmpty(strWhere)) ? strWhere1 = " Where " + strWhere : "";
            //SQL2000使用次方法分页
            //string strWhere2 = (!string.IsNullOrEmpty(strWhere)) ? strWhere2 = " AND " + strWhere : "";
            //string mySql = string.Format(
            //    basdSql,                    //基本SQL命令
            //    PageSize,                   //{0} 页面大小，每页记录行数                   
            //    Fields,                     //{1} 投影字段               
            //    PageSize * (PageIndex - 1), //{2} 要跳过的行数           
            //    strWhere1,                  //{3} 刷选条件  
            //    strOrderBy,                 //{4} 排序字段及方式
            //    strWhere2,                  //{5} 刷选条件
            //    strOrderBy);                //{6} 排序字段及方式

            //SQL2005及以上使用次方法分页
            string strSql = string.Format(
                basdSql,                                //基本SQL命令
                PageSize,                               //{0} 页面大小，每页记录行数         
                strOrderBy,                             //{1} 排序字段及方式
                Fields,                                 //{2} 投影字段                
                strWhere1,                              //{3} 刷选条件
                PageSize * (PageIndex - 1),             //{4} 开始行号
                PageSize * (PageIndex - 1) + PageSize,  //{5} 结束行数
                strOrderBy);                            //{6} 排序字段及方式            

            return DbHelperSQL.Query(strSql);
        }

        #endregion

        #region 常规常用方法 编辑数据  Insert()、Update()、Delete()、

        /// <summary>
        /// 添加一条新CustomerCustomerDemo记录
        /// </summary>
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回自动编号，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Insert(Kugo.Model.CustomerCustomerDemo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("INSERT INTO [CustomerCustomerDemo] (");
            strSql.Append(" CustomerID,CustomerTypeID");
            strSql.Append(" )VALUES (");
            strSql.Append(" @CustomerID,@CustomerTypeID");
            strSql.Append(" )");
            strSql.Append(";SELECT @@IDENTITY");//返回自动编号

            SqlParameter[] parameters = {
            
              new SqlParameter("@CustomerID",  model.CustomerID),
              new SqlParameter("@CustomerTypeID",  model.CustomerTypeID) 
            }; 
            object obj = DbHelperSQL.GetSingle(strSql.ToString(), parameters);
            return (obj == null) ? false : Convert.ToInt32(obj)>0;
        }

        /// <summary>
        /// 更新一条新CustomerCustomerDemo记录
        /// </summary>
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回影响行数，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Update(Kugo.Model.CustomerCustomerDemo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("UPDATE [CustomerCustomerDemo] SET ");
            strSql.Append(" CustomerID=@CustomerID,CustomerTypeID=@CustomerTypeID	");
            strSql.Append(" WHERE [CustomerID] = @key_CustomerID");

            SqlParameter[] parameters = {
				new SqlParameter("@CustomerID",  model.CustomerID),
				new SqlParameter("@CustomerTypeID",  model.CustomerTypeID),
				 
                new SqlParameter("@key_CustomerID", model.CustomerID)
            };

            int rows = DbHelperSQL.ExecuteSql(strSql.ToString(), parameters);
            return (rows > 0);
        }

        /// <summary>
        /// 删除一条或者多条CustomerCustomerDemo记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// </summary>
        /// <returns>删除成功返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Delete(string CustomerID)
        {
          string strSql = "DELETE FROM [CustomerCustomerDemo] WHERE [CustomerID] = @CustomerID";
          SqlParameter[] parameters = { new SqlParameter("@CustomerID", CustomerID) };
          //
          int rows = DbHelperSQL.ExecuteSql(strSql, parameters);
		  return (rows > 0);
        }

        /// <summary>
        /// 删除一条或者多条CustomerCustomerDemo记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// </summary>
        /// <param name="AccountIDs">待删除的主键</param>
        /// <returns>返回影响行数，如果等于0就说明删除数据失败了，大于0说明全部或者部分删除成功(因为不是事务操作)</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int Deletes(string CustomerIDs)
        {          
          string strSql = string.Format("DELETE FROM [CustomerCustomerDemo] WHERE [CustomerID] IN ({0})", CustomerIDs);
          int rows = DbHelperSQL.ExecuteSql(strSql);
          return rows;
        }
        #endregion

        #region 你增加的新方法
        //
        //
        #endregion
        }
    }
  