﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'包名'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
  <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
  <xsl:template match="/">

    &lt;%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%&gt;
    &lt;%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%&gt;
    &lt;%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%&gt;
    &lt;%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%&gt;
    &lt;%
    String root = request.getContextPath();
    pageContext.setAttribute("root", root);
    String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + root + "/";
    %&gt;
    &lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"&gt;
    &lt;html&gt;
    &lt;head&gt;
    &lt;base href="&lt;%=basePath%&gt;"&gt;
    &lt;title&gt;&lt;/title&gt;
    &lt;meta http-equiv="pragma" content="no-cache"&gt;
    &lt;meta http-equiv="cache-control" content="no-cache"&gt;
    &lt;meta http-equiv="expires" content="0"&gt;
    &lt;meta http-equiv="keywords" content="keyword1,keyword2,keyword3"&gt;
    &lt;meta http-equiv="description" content="This is my page"&gt;
    &lt;/head&gt;
    
    &lt;body&gt;
    &lt;form name="pageQueryForm" action="${root}/employeesAction!pageQuery.action" method="post"&gt;
    &lt;table border="1"&gt;
    &lt;tr&gt;
    &lt;td&gt;Primary key of employees table.：&lt;/td&gt;
    &lt;td&gt;&lt;input type="text" id="employees_employeeId" name="employees.employeeId" value="${employees.employeeId}" /&gt;&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;   
    &lt;tr&gt;
    &lt;td colspan="2"&gt;&lt;input type="submit" value="查询" /&gt;&lt;/td&gt;
    &lt;/tr&gt;
    &lt;/table&gt;

    &lt;c:if test="${pageModel.list == null}"&gt;
    请点击查询按钮进行查询。
    &lt;/c:if&gt;

    &lt;c:if test="${pageModel.list != null &amp;&amp; fn:length(pageModel.list) == 0}"&gt;
    没有复合条件的数据。
    &lt;/c:if&gt;

    &lt;c:if test="${pageModel.list != null &amp;&amp; fn:length(pageModel.list) &gt; 0}"&gt;
    &lt;table border="1"&gt;
    &lt;tr&gt;
    &lt;td&gt;序号&lt;/td&gt;
    &lt;td&gt;Primary key of employees table.&lt;/td&gt;
    &lt;td&gt;First name of the employee. A not null column.&lt;/td&gt;
    &lt;td&gt;Last name of the employee. A not null column.&lt;/td&gt;
    &lt;td&gt;Email id of the employee&lt;/td&gt;
    &lt;td&gt;Phone number of the employee; includes country code and area code&lt;/td&gt;
    &lt;td&gt;Date when the employee started on this job. A not null column.&lt;/td&gt;
    &lt;td&gt;Monthly salary of the employee. Must be greater
    than zero (enforced by constraint emp_salary_min)&lt;/td&gt;
    &lt;td&gt;Commission percentage of the employee; Only employees in sales
    department elgible for commission percentage&lt;/td&gt;
    &lt;/tr&gt;
    &lt;c:forEach var="employees" items="${pageModel.list}" varStatus="i"&gt;
    &lt;tr&gt;
    &lt;td&gt;${pageModel.start + i.index}&lt;/td&gt;
    &lt;td&gt;${employees.employeeId}&lt;/td&gt;
    &lt;td&gt;${employees.firstName}&lt;/td&gt;
    &lt;td&gt;${employees.lastName}&lt;/td&gt;
    &lt;td&gt;${employees.email}&lt;/td&gt;
    &lt;td&gt;${employees.phoneNumber}&lt;/td&gt;
    &lt;td&gt;&lt;fmt:formatDate value="${employees.hireDate}" pattern="yyyy-MM-dd HH:mm:ss" /&gt;&lt;/td&gt;
    &lt;td&gt;${employees.salary}&lt;/td&gt;
    &lt;td&gt;${employees.commissionPct}&lt;/td&gt;
    &lt;/tr&gt;
    &lt;/c:forEach&gt;
    &lt;/table&gt;
    &lt;/c:if&gt;
    &lt;jsp:include page="/pageView.jsp"&gt;&lt;/jsp:include&gt;
    &lt;/form&gt;
    &lt;/body&gt;
    &lt;/html&gt;

  </xsl:template>
</xsl:stylesheet>