﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'包名'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">

    /*-------------------------------------------------
    *文件名称：<xsl:copy-of select="$YourClassName"/>service.java
    *创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
    *修改人、日期及内容:
    */-------------------------------------------------
    package <xsl:copy-of select="$YourNameSpace"/>.service; 

    import java.util.List;
    import java.util.Map;
    import <xsl:copy-of select="$YourNameSpace"/>.model.<xsl:copy-of select="$YourClassName"/>;
    import <xsl:copy-of select="$YourNameSpace"/>.utils.PageModel;

    public interface <xsl:copy-of select="$YourClassName"/>Service {

    Map&lt;String, Object&gt; initAdd(Map&lt;String, Object&gt; param) throws Exception;

	void add(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception;

	void delete(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception;

	Map&lt;String, Object&gt; initUpdate(Map&lt;String, Object&gt; param) throws Exception;

	void update(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception;
	
	Map&lt;String, Object&gt; initAddAll(Map&lt;String, Object&gt; param) throws Exception;

	void addAll(List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list, Map&lt;String, Object&gt; param) throws Exception;
	
	void deleteAll(List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list, Map&lt;String, Object&gt; param) throws Exception;
	
	Map&lt;String, Object&gt; initMergeAll(Map&lt;String, Object&gt; param) throws Exception;
	
	void mergeAll(List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list, Map&lt;String, Object&gt; param) throws Exception;

	<xsl:copy-of select="$YourClassName"/> get(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception;
	
	List&lt;<xsl:copy-of select="$YourClassName"/>&gt; selectAll(Map&lt;String, Object&gt; param) throws Exception;
	
	Map&lt;String, Object&gt; initConditionSelectAll(Map&lt;String, Object&gt; param) throws Exception;
	
	List&lt;<xsl:copy-of select="$YourClassName"/>&gt; conditionSelectAll(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception;
	
	Map&lt;String, Object&gt; initPageQuery(Map&lt;String, Object&gt; param) throws Exception;
	
	PageModel pageQuery(PageModel pageModel, <xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception;
}
      </xsl:template> 
</xsl:stylesheet>