﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'包名'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">

    /*-------------------------------------------------
    *文件名称：<xsl:copy-of select="$YourClassName"/>action.java
    *创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
    *修改人、日期及内容:
    */-------------------------------------------------
    package <xsl:copy-of select="$YourNameSpace"/>.action; 

    import java.util.List;
    import <xsl:copy-of select="$YourNameSpace"/>.model.<xsl:copy-of select="$YourClassName"/>;
    import <xsl:copy-of select="$YourNameSpace"/>.service.<xsl:copy-of select="$YourClassName"/>Service;
    import <xsl:copy-of select="$YourNameSpace"/>.utils.PageModel;

    public class <xsl:copy-of select="$YourClassName"/>Action extends BaseAction {

    private <xsl:copy-of select="$YourClassName"/>Service service;
    private <xsl:copy-of select="$YourClassName"/> model;
    private List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list;
	private PageModel pageModel;
	
	public String initAdd() {
		try {
			service.initAdd(null);
		} catch (Exception e) {
			return ERROR;
		}
		return "initAdd";
	}

	public String add() {
		try {
			service.add(model, null);
		} catch (Exception e) {
			return ERROR;
		}
		return SUCCESS;
	}

	public String delete() {
		try {
			service.delete(model, null);
		} catch (Exception e) {
			return ERROR;
		}
		return SUCCESS;
	}

	public String initUpdate() {
		try {
			model = service.get(model, null);
			request.setAttribute("model", model);
		} catch (Exception e) {
			return ERROR;
		}
		return "initUpdate";
	}

	public String update() {
		try {
			service.update(model, null);
		} catch (Exception e) {
			return ERROR;
		}
		return SUCCESS;
	}

	public String initAddAll() {
		try {
			service.initAddAll(null);
		} catch (Exception e) {
			return ERROR;
		}
		return "initAddAll";
	}

	public String addAll() {
		try {
			service.addAll(list, null);
		} catch (Exception e) {
			return ERROR;
		}
		return SUCCESS;
	}

	public String deleteAll() {
		try {
			service.deleteAll(list, null);
		} catch (Exception e) {
			return ERROR;
		}
		return SUCCESS;
	}

	public String initMergeAll() {
		try {
			list = service.selectAll(null);
			request.setAttribute("list", list);
		} catch (Exception e) {
			return ERROR;
		}
		return "initMergeAll";
	}

	public String mergeAll() {
		try {
			service.mergeAll(list, null);
		} catch (Exception e) {
			return ERROR;
		}
		return SUCCESS;
	}

	public String selectAll() {
		try {
			list = service.selectAll(null);
			request.setAttribute("list", list);
		} catch (Exception e) {
			return ERROR;
		}
		return "selectAll";
	}

	public String initConditionSelectAll() {
		try {
			service.initConditionSelectAll(null);
		} catch (Exception e) {
			return ERROR;
		}
		return "conditionSelectAll";
	}

	public String conditionSelectAll() {
		try {
			list = service.conditionSelectAll(model, null);
			request.setAttribute("list", list);
			request.setAttribute("model", model);
		} catch (Exception e) {
			return ERROR;
		}
		return "conditionSelectAll";
	}

	public String initPageQuery() {
		try {
			service.initPageQuery(null);
		} catch (Exception e) {
			return ERROR;
		}
		return "pageQuery";
	}

	public String pageQuery() {
		try {
			pageModel = service.pageQuery(pageModel, model, null);
			request.setAttribute("model", model);
			request.setAttribute("pageModel", pageModel);
		} catch (Exception e) {
			return ERROR;
		}
		return "pageQuery";
	}
	
	public void setService(<xsl:copy-of select="$YourClassName"/>Service service) {
		this.service = service;
	}
	
	public <xsl:copy-of select="$YourClassName"/> get<xsl:copy-of select="$YourClassName"/>() {
		return model;
	}

	public void set<xsl:copy-of select="$YourClassName"/>(<xsl:copy-of select="$YourClassName"/> model) {
		this.model = model;
	}
	
	public List&lt;<xsl:copy-of select="$YourClassName"/>&gt; getList() {
		return list;
	}

	public void setList(List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list) {
		this.list = list;
	}

	public PageModel getPageModel() {
		return pageModel;
	}

	public void setPageModel(PageModel pageModel) {
		this.pageModel = pageModel;
	}
}
      </xsl:template> 
</xsl:stylesheet>