<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">
    --创建表 <xsl:copy-of select="$YourTableName" /> 的SQL语句
    CREATE TABLE <xsl:copy-of select="$YourTableName" />(
    <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
      <xsl:text>&#x9;&#x9;</xsl:text>    
      [<xsl:value-of select="@Name" />]<xsl:text>&#x20;</xsl:text>[<xsl:value-of select="@Datatype" />]
      <xsl:if test="@Identity='√'">
        <xsl:text> IDENTITY (1, 1)</xsl:text>
      </xsl:if>       
      <xsl:if test="contains(@Datatype,'char')">(<xsl:value-of select="@Length" />)</xsl:if>
      <xsl:if test="@AllowNulls = '√'">
        <xsl:text> NULL</xsl:text>
      </xsl:if>
      <xsl:if test="@AllowNulls != '√'">
        <xsl:text> NOT NULL</xsl:text>
      </xsl:if>
      <xsl:if test="@DefaultValue != ''">
        <xsl:text> </xsl:text>CONSTRAINT [DF_<xsl:value-of select="$YourTableName" />_<xsl:value-of select="@Name" />] DEFAULT (<xsl:value-of select="@DefaultValue" />)
      </xsl:if>
      <xsl:if test="position() != last()">,<xsl:text>&#x20;&#x20;&#x20;&#x20;</xsl:text>--<xsl:value-of select="@Caption"/></xsl:if>
      <xsl:if test="position() = last()">
        <xsl:text>&#x20;&#x20;&#x20;&#x20;</xsl:text>--<xsl:value-of select="@Caption"/></xsl:if>
      <xsl:text>&#xD;&#xA;</xsl:text> 
    </xsl:for-each>
    <xsl:text>&#x9;&#x9;--key</xsl:text>
    <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
      <xsl:if test="@InPrimaryKey='√'">
        CONSTRAINT [PK_<xsl:copy-of select="$YourTableName" />] PRIMARY KEY CLUSTERED ([<xsl:value-of select="@Name" />])
      </xsl:if>
    </xsl:for-each>
    )
   --添加表注释
  exec sp_addextendedproperty N'MS_Description', N'<xsl:copy-of select="$YourTableRemark" />', N'user', N'dbo', N'table', N'<xsl:copy-of select="$YourTableName" />'

   --添加列注释
   <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
   exec sp_addextendedproperty N'MS_Description', N'<xsl:value-of select="@Remark" />', N'user', N'dbo', N'table', N'<xsl:copy-of select="$YourTableName" />', N'column', N'<xsl:value-of select="@Name" />'</xsl:for-each>
  </xsl:template>
</xsl:stylesheet>