﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Web;
namespace <xsl:value-of select="$YourNameSpace"/>.DALFactory{
<xsl:text disable-output-escaping="yes"><![CDATA[  
    /// <summary>
    /// 抽象工厂
    /// </summary>
    public class AbstractFactory{

        /// <summary>
        /// 抽象工厂
        /// 可以使用高速缓存提高性能
        /// </summary>
        /// <typeparam name="T">目标类型</typeparam>
        /// <param name="assemblyString">类所在的程序集名称</param>
        /// <param name="className">类的完全限定名称</param>
        /// <returns></returns>
        public static T Create<T>(string assemblyString, string className)
        {
            return (T)Assembly.Load(assemblyString).CreateInstance(className);

            //缓存提高性能
            //    object objType = DataCache.GetCache(className);//从缓存读取
            //    if (objType == null)
            //    {
            //        try
            //        {
            //            objType = Assembly.Load(assemblyString).CreateInstance(className);//反射创建
            //            DataCache.SetCache(className, objType);// 写入缓存
            //        }
            //        catch
            //        { }
            //    }
            //    return (T)objType;            
        }
    }

    public class DataCache{
      /// <summary>
      /// 获取当前应用程序指定CacheKey的Cache值
      /// </summary>
      /// <param name="CacheKey"></param>
      /// <returns></returns>
      public static object GetCache(string CacheKey){
        System.Web.Caching.Cache objCache = HttpRuntime.Cache;
        return objCache[CacheKey];
      }

      /// <summary>
      /// 设置当前应用程序指定CacheKey的Cache值
      /// </summary>
      /// <param name="CacheKey"></param>
      /// <param name="objObject"></param>
      public static void SetCache(string CacheKey, object objObject){
        System.Web.Caching.Cache objCache = HttpRuntime.Cache;
        objCache.Insert(CacheKey, objObject);
      }
    } 
 ]]></xsl:text>
}
  </xsl:template>
</xsl:stylesheet>