﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>    
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>  
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">
  
using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;
using <xsl:copy-of select="$YourNameSpace"/>.Models;

namespace <xsl:copy-of select="$YourNameSpace"/>.Mappings {

  /// &lt;summary&gt;
  /// <xsl:copy-of select="$YourTableRemark"/>（<xsl:copy-of select="$YourTableName"/>）
  /// &lt;/summary&gt;
  /// &lt;remarks&gt;
  /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
  /// &lt;para&gt;修改人、日期及内容:&lt;/para&gt;
  /// &lt;/remarks&gt;    
  public class <xsl:copy-of select="$YourClassName"/>Map : EntityTypeConfiguration&lt;<xsl:copy-of select="$YourNameSpace"/>.Models.<xsl:copy-of select="$YourClassName"/>&gt; {
    public <xsl:copy-of select="$YourClassName"/>Map() {
      // Primary Key           
      this.HasKey(t => t.<xsl:copy-of select="$YourFristKey"/>);
      // NotMapped   

      // Table - Column Mappings
      this.ToTable("<xsl:copy-of select="$YourTableName"/>");
		  <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">			 
	  this.Property(t => t.<xsl:value-of select="@Property"/>).HasColumnName("<xsl:value-of select="@Name"/>")<xsl:if test="@Identity='√'">.HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity)</xsl:if>;</xsl:for-each>

      // Relationships HasOptional,HasRequired
      //this.HasRequired(t => t.setcountry)         // 主表 
      //    .WithMany(t => t.setprovinces)              // 一对多 一个setcountry可以有多个setprovince
      //    .HasForeignKey(d => d.Country_Id);        // 外键 
    }
  }
}
  </xsl:template> 
</xsl:stylesheet>