﻿using System;
using System.Web;
using System.Web.SessionState;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using Mammonth.Common;
//using Northwind.Model;
//using Northwind.BLL;

namespace Northwind.Web.Service {
    /// <summary>
    /// Service请求基类    
    /// 创建人:zhao
    /// 创建时间:2014-10-21
    /// </summary>
    public class _AshxBasePage : IHttpHandler, IRequiresSessionState {
        /// <summary>
        /// 当前登录用户
        /// </summary>
        LoginAdminStruct userStruct;

        #region 固定方法，无需修改
        /// <summary>
        /// web请求处理
        /// </summary>
        /// <param name="context"></param>
        public void ProcessRequest(HttpContext context) {
            string methodName = "", errorMsg = "", errorCode = "";
            //获取操作目标            
            if (!string.IsNullOrEmpty(context.Request["do"])) {
                methodName = context.Request["do"];
            } else if (!string.IsNullOrEmpty(context.Request["method"])) {
                methodName = context.Request["method"];
            } else {
                context.Response.Write("{error:\"没有必须的参数\"}");
                return;
            }
            //登录、权限验证
            if (!BeforeInvoke(methodName, out errorMsg, out errorCode)) {
                context.Response.Write("{error:\"" + errorMsg + "\",code:" + errorCode + "}");
                return;
            }
            //执行目标操作   
            MethodInfo method = this.GetType().GetMethod(methodName);   //获取要执行的方法   
            if (method == null) {
                context.Response.Write("{error:\"没有找到方法" + methodName + "\",code:1100}");
                return;
            }
            //
            try {

                method.Invoke(this, null);      //调用方法

            } catch (Exception ex) {
                Exception baseEx = ex.GetBaseException();
                errorMsg = (baseEx != null) ? baseEx.Message : ex.Message;
                //
                Hashtable result = new Hashtable();
                result["error"] = errorMsg;
                result["code"] = "";
                result["message"] = ex.StackTrace;
                //
                //创建错误日记
                LogHelper.CreateLog(errorMsg, context.Request.FilePath, methodName);
                //
                //返回错误信息
                context.Response.Write(JSON.Encode(result));
            } finally {
                //AfterInvoke(methodName);        //日记记录
            }
        }

        /// <summary>
        /// 登录、权限验证
        /// </summary>
        /// <param name="methodName">方法名称</param>
        /// <param name="errorMsg">输出错误消息</param>
        /// <param name="errorCode">输出错误代码</param>
        /// <returns>验证成功返回true,否则返回false</returns>
        protected bool BeforeInvoke(string methodName, out string errorMsg, out string errorCode) {
            errorMsg = "";
            errorCode = "";

            //增加掉线就根据验证票证自动登录 zhao 2014-10-21
            _AdminLoginService.CheckAdminToAutoLogin();
            // 
            //登录验证
            if (HttpContext.Current.Session == null || HttpContext.Current.Session["LoginAdminStruct"] == null) {
                errorCode = "1000";
                errorMsg = "没有登录或者登录超时";
                return false;
            }
            if (userStruct == null)
                userStruct = (LoginAdminStruct)HttpContext.Current.Session["LoginAdminStruct"];

            // 
            return true; //测试时跳过权限验证                      

            /*
            //需要权限验证
            bool bEnable = false; 
            string powerName = "供应商协议价格管理"; //权限项名称，
            //
            switch (methodName) {
                case "SearchSaleHolidays":     //查询记录集
                    bEnable = _AdminLoginService.getUserPower(userStruct.Gs_companyCode, userStruct.Gs_userCode, powerName, "IsQuery");
                    if (!bEnable) msg = "没有查询权限";
                    break;
                case "DeleteSaleHoliday":     //删除
                    bEnable = _AdminLoginService.getUserPower(userStruct.Gs_companyCode, userStruct.Gs_userCode, powerName, "IsDele");
                    if (!bEnable) msg = "没有删除权限";
                    break;
                case "SaveSaleHoliday":       //（新建|更新）保存
                    bEnable = _AdminLoginService.getUserPower(userStruct.Gs_companyCode, userStruct.Gs_userCode, powerName, "IsEdit");
                    if (!bEnable) msg = "没有编辑权限";
                    break;
                case "SaveSaleHolidays":      //（新建|更新|删除）批量保存
                    bEnable = _AdminLoginService.getUserPower(userStruct.Gs_companyCode, userStruct.Gs_userCode, powerName, "IsEdit");
                    if (!bEnable) msg = "没有编辑权限";
                    break;
                default: //默认都通过
                    bEnable = true;
                    break;
            }
            return bEnable;
            */
        }

        /// <summary>
        /// 日志管理
        /// </summary>
        /// <param name="methodName">方法名称</param>
        protected void AfterInvoke(string methodName) {

        }

        public bool IsReusable {
            get {
                return false;
            }
        }
        #endregion


    }



}