﻿// ****************************************************** 
// 文件名称(File Name)：   Customers.cs
// 项目名称(Project Name)：猛犸商贸演示系统
// 功能描述(Description)： 实现 客户 业务接口（此模块的功能描述与大概流程说明）
// 数据表(Tables)：        Customers（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
// 作者(Author)：          zhaoshunlu@163.com
// 日期(Create Date)：     2014-10-21 21:48:53
// 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
// 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
// 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
//****************************************************** 
using System;
using System.Web;
using System.Web.SessionState;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using Mammonth.Common;
using Northwind.Model;

namespace Northwind.Web.Service {
    /// <summary>
    /// 摘要说明：实现 客户 服务
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 21:48:53
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class CustomersService : _AshxBasePage { 

        #region 常规常用方法 -->(查询)获取单个对象，获取翻页列表，保存(批量)对象，删除(批量)对象
        #region (查询)获取一条记录
        /// <summary>      
        /// 根据加主键获取一条记录
        /// </summary>
        /// <remarks> 
        /// 调用页面：CustomersForm.html
        /// <para>创建人及日期：zhaoshunlu@163.com 2014-10-21 21:48:53</para>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public void GetCustomers() {
            string id = HttpContext.Current.Request["id"];
            //主键是整数 !string.IsNullOrEmpty(id)
            //主键是文本 !string.IsNullOrEmpty(id)
            if (!string.IsNullOrEmpty(id)) {

                string json = "";//
                //如果要求优先从静态JSON数据文件读取数据
                //bool IsReadFile = false;
                //if (IsReadFile) {
                //   json = Template.ReadJSON(HttpContext.Current.Server.MapPath(string.Format("../data/Customers_{0}.json", id)));
                //}else{       
                //创建业务对象，调用获取对象方法
                Northwind.BLL.CustomersBLL bll = new Northwind.BLL.CustomersBLL();
                Northwind.Model.Customers model = bll.GetOne(id);//GetOne()默认获取子表及子表记录，如果只需要主表记录就修改默认参数state="single"
                if (model != null) {
                    //Hashtable result = new Hashtable();
                    //result = DataFormat.Object2Hashtable(model);

                    json = JSON.Encode(model);  //对象格式成json字符串
                } else {
                    Hashtable result = new Hashtable();
                    result["error"] = bll.GetLastError();//获取最后错误

                    json = JSON.Encode(result);  //对象格式成json字符串
                }
                //}
                //返回客户端JSON数据
                HttpContext.Current.Response.Write(json);
            }
        }
        #endregion

        #region (查询)获取分页列表
        /// <summary>
        /// 按条件查找分页记录列表,返回数据给前台表格控件使用
        /// </summary>
        /// <remarks> 
        /// 调用页面：CustomersList.html
        /// <para>创建人及日期：zhaoshunlu@163.com 2014-10-21 21:48:53</para>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public void SearchCustomerss() {
            //固定条件:公司编码
            //string CompanyCode = userStruct.Gs_companyCode;
            //查询条件
            string key = DataValidator.GetSafeSqueryString(HttpContext.Current.Request["key"]);//获取安全查询字符串
            //string fromDate = HttpContext.Current.Request["fromDate"];
            //string toDate = HttpContext.Current.Request["toDate"];
            //分页参数，total保存记录总条数     
            //分页
            int pageIndex = (DataValidator.IsNumber(HttpContext.Current.Request["pageIndex"])) ? Convert.ToInt32(HttpContext.Current.Request["pageIndex"]) : 0;
            int pageSize = (DataValidator.IsNumber(HttpContext.Current.Request["pageSize"])) ? Convert.ToInt32(HttpContext.Current.Request["pageSize"]) : 10;
            int total = (DataValidator.IsNumber(HttpContext.Current.Request["total"])) ? Convert.ToInt32(HttpContext.Current.Request["total"]) : 0;

            //字段排序
            string sortProperty = HttpContext.Current.Request["sortField"];
            string sortOrder = HttpContext.Current.Request["sortOrder"];
            if (string.IsNullOrEmpty(sortProperty)) sortProperty = "CustomerID";//排序属性名称(非字段名称)
            bool isAsc = (string.IsNullOrEmpty(sortOrder) || sortOrder == "desc") ? false : true;

            //创建业务对象，获取分页记录列表
            Northwind.BLL.CustomersBLL bll = new Northwind.BLL.CustomersBLL();
            Hashtable result = new Hashtable();
            //方式1：使用LINQ动态查询获取翻页记录  
            //string conditionsLinq = "";// "CompanyCode ==\"" + CompanyCode + "\"";      //所属公司编码           
            ////多个条件拼接  
            //if (!string.IsNullOrEmpty(key))
            //  conditionsLinq += " And CustomerID.Contains(\"" + + key + "\")";    //查询条件
            //
            //IList<Northwind.Model.Customers> Customerss = bll.GetPage(pageSize, pageIndex, conditionsLinq, isAsc, sortProperty, out total);
            //result["data"] = Customerss;
            //result["total"] = total;

            //方式2：使用原始SQL从表格或者视图获取翻页记录 (可以更加灵活的拼接生成SQL语句及自定义查询字段)
            //       me是当前表Customers的别名
            string conditions = "0=0";//" me.CompanyCode = '" + CompanyCode + "'";
            if (HttpContext.Current.Request["All"] != null) {
                //无过滤条件，查询所有
            } else {
                if (!string.IsNullOrEmpty(key))
                    conditions += " And me.CustomerID like '%" + key + "%'";
                ////查询开始日期
                //if (DataValidator.IsDate(fromDate))
                //    conditions += " AND [me].InputDate >= convert(datetime,'" + fromDate + " 00:00:00') ";
                ////查询截止日期
                //if (DataValidator.IsDate(toDate))
                //    conditions += " AND [me].InputDate <= convert(datetime,'" + toDate + " 23:59:59') ";
            }
            result = bll.GetPages(pageSize, pageIndex, conditions, isAsc, sortProperty, total);
            //
            string json = JSON.Encode(result);         //对象格式成json字符串
            HttpContext.Current.Response.Write(json);  //返回客户端JSON数据
        }

        #endregion

        #region (查询)获取显示列表（无分页）
        /// <summary>       
        /// 获取无分页记录列表， 比如为下拉列表框提供数据源      
        /// </summary>
        /// <remarks> 
        /// 调用页面：
        /// <para>创建人及日期：zhaoshunlu@163.com 2014-10-21 21:48:53</para>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public void GetCustomerss() {
            //固定条件:公司编码
            //string CompanyCode = userStruct.Gs_companyCode;

            //创建业务对象，调用获取记录列表
            Northwind.BLL.CustomersBLL bll = new Northwind.BLL.CustomersBLL();
            IList<Northwind.Model.Customers> Customerss = bll.GetList("");

            //对象格式成json字符串
            string json = JSON.Encode(Customerss);
            //返回客户端JSON数据
            HttpContext.Current.Response.Write(json); //
        }
        #endregion

        #region 保存对象(保存单个对象和批量保存多个对象)
        /// <summary>    
        /// 保存一条记录(表单窗口新建和修改时调用次方法)
        /// </summary>
        /// <remarks>
        /// 调用页面：CustomersForm.html
        /// <para>创建人及日期：zhaoshunlu@163.com 2014-10-21 21:48:53</para>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public void SaveCustomers() {
             //固定条件:公司编码
            //string CompanyCode = userStruct.Gs_companyCode;
            //获取查询字符串
            string jsons = HttpContext.Current.Request["data"]; 
            //
            //设置返回值
            Hashtable result = new Hashtable();
            bool bSuccess = false;
            //从json字符串创建对象
            Northwind.Model.Customers model = JSON.Decode<Northwind.Model.Customers>(jsons);
           
            if (model != null) {

                #region 处理不允许为NULL值的属性
                                //if(model.CustomerID == null)model.CustomerID = "";			//客户ID  not null 
                //if(model.CompanyName == null)model.CompanyName = "";			//公司名称  not null 

                //更新制表人和制表日期
                //model.UserCode = userStruct.Gs_userName;//Gs_userCode
                //model.InputDate = System.DateTime.Now;
                #endregion

                //bool IsNew = (model.CustomerID == "0") ? true : false;
                //IList<string> OldImgList = new List<string>(); //旧的图片列表
                //IList<string> NewImgList = new List<string>(); //新的图片列表

                //创建业务对象,保存对象到数据库
                Northwind.BLL.CustomersBLL bll = new Northwind.BLL.CustomersBLL();
                if (model.CustomerID == "0") {          
                    //新增
                    //其他属性设置：如操作人 操作日期
                    //model.操作人=?
                    //model.操作日期=System.DateTime.Now;
                    bSuccess = bll.Insert(model);
                } else {
                    //更新修改记录
                    //如果表单中有对象所有属性并希望保存全部属性值，可直接调用 bSuccess = bll.Save(model)就行了  
                    //bSuccess = bll.Save(model); 

                    //如果只更新对象部分属性属性值,那么就采用如下两种方式                    

                    #region //更新方式1、手工对每天属性赋值(以前采用的方式，今后不推荐，效率差，而且太麻烦)   
                    /*
                    //不需要的话可自行删除以下代码
                    //同时如果想获取原内容包含的图片列表，或者添加操作日记以记录数据项修改情况，那么必须获取原来的记录
                    Northwind.Model.Customers oldModel = bll.GetOne(model.CustomerID);//GetOne()默认获取子表及子表记录，如果只需要主表记录就修改默认参数state="single"
                    //获取原内容包含的图片列表
                    //OldImgList = HtmlEditorHelper.getImageSrcArray(theModel.Content);
                     
                                        oldModel.CustomerID = model.CustomerID;			//客户ID not null 
                    oldModel.CompanyName = model.CompanyName;			//公司名称 not null 
                    oldModel.PassWord = model.PassWord;			//密码  
                    oldModel.ContactName = model.ContactName;			//联系人姓名  
                    oldModel.ContactTitle = model.ContactTitle;			//联系人职位  
                    oldModel.Address = model.Address;			//地址  
                    oldModel.City = model.City;			//城市  
                    oldModel.Region = model.Region;			//地区  
                    oldModel.PostalCode = model.PostalCode;			//邮政编码  
                    oldModel.Country = model.Country;			//国家  
                    oldModel.Phone = model.Phone;			//电话  
                    oldModel.Fax = model.Fax;			//传真  
                   

                    ////如果有子表则赋值子表
                    //oldModel.子表s = model.子表s;
                    ////保存旧Model
                    //bSuccess = bll.Update(oldModel);
                    *
                    */
                    #endregion

                    #region //更新方式2、优点 DAL层修改前不需要先查询数据库,最终EF生成的SQL语句只包含有需要更新的字段
                    //获取表单需要处理的所有键名集合
                    Hashtable hasData = JSON.Decode<Hashtable>(jsons); //所有表单提交的数据
                    string[] allKes = new string[hasData.Count];
                    hasData.Keys.CopyTo(allKes, 0);

                    //如果要在修改操作记录就要比较新旧两个对象对象属性值有哪些不同(如果表单只提交有变更的字段就不需要这么麻烦获取旧记录来比较了，唉)
                    Customers oldModel = bll.GetOne(model.CustomerID, "single");//GetOne()默认获取子表及子表记录，如果只需要主表记录就修改默认参数state="single"
                    Hashtable chglists = DataValidator.ComparisonDifferent(oldModel, model, allKes, new string[] { "_state", "_tag2" });//需要具体的修改内容需要设置第5个参数BackDifValue=true
                    string[] chgKes = new string[chglists.Count];
                    chglists.Keys.CopyTo(chgKes, 0);//获取只有更改的属性键集合

                    //保存新Model
                    bSuccess = bll.UpdateForm(model, chgKes);//allKes所有表单提交的属性键名，chgKes有修改数据的属性键名
                    #endregion

                    #region //更新成功就保存修改日记，如不需要就自行删除此注释代码
                    /*
                     * //需要具体的修改内容DataValidator.ComparisonDifferent()方法的需要设置第5个参数BackDifValue=true
                     * 例如日记对象ResidentslordUpdateDate
                     *
                    if (bSuccess) { 
                        DateTime time = DateTime.Now;
                        IList<ResidentslordUpdateDate> logs = new List<ResidentslordUpdateDate>();
                        //遍历有修改的项
                        foreach (DictionaryEntry item in chglists) {
                            Hashtable cgTb = (Hashtable)item.Value;
                            if (cgTb["Name"].ToString() == "InputDate" || cgTb["Name"].ToString() == "UserCode") {
                                continue; //跳过修改日期和修改人，这两个属性的变更不需要添加进操作记录
                            }
                            ResidentslordUpdateDate log = new ResidentslordUpdateDate();
                            //
                            log.ResidentID = model.CustomerID;//所属主键 // 或者Convert.ToInt32(cgTb["KeyId"]);//主键ID
                            log.RUsubject = cgTb["Caption"].ToString();   //用别名：Caption, 用字段名称是 Name
                            log.BeforeDate = cgTb["OldVal"].ToString();
                            log.RUDate = cgTb["NewVal"].ToString();
                            log.UpdateDatekind = "单项业务"; //oldModel.SaleHolidayKind 订单类别
                            //
                            log.Register = UserName;//修改人
                            log.RegisterDate = time;//修改时间
                            //
                            logs.Add(log);
                        }
                        //提交批量保存
                        new ResidentslordUpdateDateBll().Insert(logs);
                    }
                    * 
                    */
                    #endregion
                }
                if (bSuccess) {
                    result["Id"] = model.CustomerID;   //返回主键（推荐使用自动编号列）

                    #region //“图片处理”和“静态数据”
                    //以下两个业务“图片处理”和“静态数据”，如果不需要请自行删除

                    //1、处理内容中的图片
                    //获取内容中所有的图片                    
                    //对比旧的文件列表把删除的删除。
                    //遍历检查目录，移动到新目录
                    //更新数据库对应表、字段内容中的图片路径。
                    //
                    //该业务专用文件夹(相对路径)
                    //string targetfolder = "YourGroundFolderdata\\" + CompanyCode + "\\Customers\\" + model.CustomerID.ToString();
                    //bool bUpOK = FileHelper.AccessUpFile(HttpContext.Current, IsNew, targetfolder, model.AttFile, model._tag2);//AttFile 文件名称字段
                    ////获取刷新后的新图片列表
                    //NewImgList = HtmlEditorHelper.getImageSrcArray(model.Content);
                    //HtmlEditorHelper.AccessImages(HttpContext.Current, OldImgList, NewImgList, targetfolder, "Customers", "Content", "CustomerID=" + model.CustomerID.ToString());//Content 含有图片的大文本字段

                    //2、创建静态预览页面
                    //model = bll.GetOne(model.CustomerID); //重新model值，获取主表和子表数据，因为原来的model 的子表数据只是有更新的数据。                  
                    //string tempContext = AccessHTML(model, HttpContext.Current.Server.MapPath("../template/CustomersView.html"));
                    //Template.CreateHTML(tempContext, HttpContext.Current.Server.MapPath(string.Format("../html/CustomersView_{0}.html", model.CustomerID)));
                    //创建静态Json数据
                    //Template.CreateJSON(JSON.Encode(model), HttpContext.Current.Server.MapPath(string.Format("../data/Customers_{0}.json", model.CustomerID)));  
                    #endregion

                } else {
                    result["error"] = bll.GetLastError();//获取最后错误
                }
            } else {
                result["error"] = "提交的数据格式有错误：" + JSON.GetLastError();
            }
            //
            string json = JSON.Encode(result);        //对象格式成json字符串
            HttpContext.Current.Response.Write(json); //返回客户端JSON数据

        }
       
        /// <summary>       
        /// 批量保存数据更新(包括新增、修改与删除)，一次保存多条数据。
        /// </summary>
        /// <remarks>
        /// 调用页面：CustomersList.html
        /// <para>创建人及日期：zhaoshunlu@163.com 2014-10-21 21:48:53</para>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public void SaveCustomerss() {
            string jsons = HttpContext.Current.Request["data"];
            //
            Northwind.BLL.CustomersBLL bll = new Northwind.BLL.CustomersBLL();
            //
            IList<Northwind.Model.Customers> models = JSON.Decode<IList<Northwind.Model.Customers>>(jsons);
            //
            Hashtable result = new Hashtable();
            bool bSuccess = bll.Save(models);
            if (!bSuccess)
                result["error"] = bll.GetLastError();//获取最后错误 
            //
            string json = JSON.Encode(result);        //对象格式成json字符串
            HttpContext.Current.Response.Write(json); //返回客户端JSON数据
        }       
        #endregion

        #region 删除对象
        /// <summary>      
        /// 通过主键删除一条或多条记录
        /// </summary>
        /// <remarks>
        /// 调用页面：CustomersForm.html
        ///          CustomersList.html
        /// <para>创建人及日期：zhaoshunlu@163.com 2014-10-21 21:48:53</para>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public void DeleteCustomers() {
            //固定条件:公司编码,只能删除自己公司的          
            //string CompanyCode = userStruct.Gs_companyCode;
            //string UserName = userStruct.Gs_userName;
            //查询参数
            string id = HttpContext.Current.Request.QueryString["id"];
            //string CompanyCode = HttpContext.Current.Request.QueryString["companycode"];

            if (string.IsNullOrEmpty(id)) {
                id = HttpContext.Current.Request["data"]; //删除多条记录
            }
            if (!string.IsNullOrEmpty(id)) {
                Hashtable result = new Hashtable();
                //创建业务对象,调用删除方法
                Northwind.BLL.CustomersBLL bll = new Northwind.BLL.CustomersBLL();
                bool bSuccess = bll.Delete(id);
                if (bSuccess) {
                    //删除专用文件夹、静态html文件和静态Json数据
                    //string rootfolder = HttpContext.Current.Server.MapPath("/");//网站物理根目录,后面已经有\
                    //string targetfolder = rootfolder + "YourGroundFolderdata\\" + CompanyCode + "\\Customers\\";//专用文件夹(相对路径)

                    //if (id.IndexOf(",") < 1){
                    //    Template.DeleteDirectory( targetfolder + id);  //删除专用文件夹
                    //    //删除静态页面及数据
                    //    //Template.DeleteFile(rootfolder+"html\\html/Customers_" + id + ".html");
                    //    //Template.DeleteFile(rootfolder+"data\\Customers_" + id + ".json");
                    //}else{
                    //    string[] ids = id.Split(new char[] { ',' });
                    //    for (int i = ids.Length - 1; i >= 0; i--){
                    //        Template.DeleteDirectory( targetfolder + ids[i]); //删除专用文件夹
                    //        //删除静态页面及数据
                    //        //Template.DeleteFile(rootfolder+"html\\Customers_" + ids[i] + ".html");
                    //        //Template.DeleteFile(rootfolder+"data\\Customers_" + ids[i] + ".json");
                    //    }
                    //}
                } else {
                    result["error"] = bll.GetLastError();//获取最后错误
                }

                //
                string json = JSON.Encode(result);        //对象格式成json字符串
                HttpContext.Current.Response.Write(json); //返回客户端JSON数据

            }
        }
        #endregion
        #endregion

        #region 自定义扩展方法 -->你的方法请写在这里
        //你的方法
        #endregion
    }

}