﻿/**
 *  
 * swfupload 文件上传专用，请勿做其他用途
 * 仅仅上传到网站临时目录uploads\\_temp时才使用
 * zhao 2012-12-28
 * zhao 2014-03-17 上传到网站临时目录/uploads/swfupload时才使用
 */

using System;
using System.Text;
using System.Web;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;

namespace Mammonth.CommonLibs {
    /// <summary>
    /// uploadService.ashx 的摘要说明
    /// 创建：zhao 2012-12-28
    /// 更新：zhao 2014-08-24 增加判断是否重命名
    /// </summary>
    public class uploadService : IHttpHandler {
       
        public bool IsReusable {
            get {
                return false;
            }
        }
        public void ProcessRequest(HttpContext context) {
            // 获得程序路径
            //string tempFile = context.Request.PhysicalApplicationPath;//后面已经有\符号 如C:\inetpub\wwwroot\MyApplication\
            //string rootfolder = context.Request.PhysicalPath;//C:\inetpub\wwwroot\MyApplication\MyPages\default.aspx

            //根目录
            string rootfolder = HttpContext.Current.Server.MapPath("/");//后面已经有\  如E:\ITravelSystem\ITravelSystem\ITravelSystem.Web\
            string rename = HttpContext.Current.Request.QueryString["rename"]; //是否从命名文件
            string target = HttpContext.Current.Request.QueryString["target"]; //是否指定上传目录

            //找到目标文件对象
            HttpPostedFile uploadFile = context.Request.Files["Fdata"];
            if (uploadFile != null) {
                //只上传到临时文件夹 
                string newName = "";
                if (rename == "false" || rename == "0") {
                    newName = uploadFile.FileName; //使用原来的文件名，有可能重复
                } else {
                    //生成唯一文件名 
                    newName = DateTime.Now.ToString("yyyymmddhhmmss") + System.IO.Path.GetExtension(uploadFile.FileName);
                }
                //
                string savepath = "";
                if (string.IsNullOrEmpty(target)) {
                    savepath = string.Format("{0}uploads\\swfupload\\{1}", rootfolder, newName);
                } else {
                    savepath = string.Format("{0}{1}\\{2}", rootfolder,target, newName);
                }
                // 如果有文件, 则保存到一个地址
                if (uploadFile.ContentLength > 0) {
                    uploadFile.SaveAs(savepath);
                    //Response.Write(uploadFile.FileName +"("+DateTime.Now+")");    //可以返回一个JSON字符串, 在客户端做更多处理
                    context.Response.Write(newName);
                } else {
                    context.Response.Write("没有上传图片");
                }
            }
        }



    }
}