﻿///////////////////////////////////////
//gridLayout.js
//本文件仅仅供miniui的datagrid控件表格布局和导出excel使用
//要配合miniui才能使用
//创建:zhaoshunlu 2012-12-28
//更新:
//zhao 2013-1-29 增加 clearColumnHeader()方法
//zhao 2013-5-9  增加 onReSetLayout()方法，重置表格的默认布局
//zhao 2013-6-9  增加单元格内容对齐与字体颜色设置。
///////////////////////////////////////

//var BOOTPATH_GLOBAL_GRID = __CreateJSPath("gridlayout.js");
var BOOTPATH_GLOBAL_GRID = "/OA/CommonLibs/";
//alert(BOOTPATH_GLOBAL_GRID);
//配置表格布局
//将指定的表格的列以行的形式显示到一个表格中
//在表格列表标题行右键菜单单击“表格布局”时调用此方法
//参数：username 用户名称，如：张国强
//参数：gridname 表格名称，如：datagrid1
//参数：formname 窗口名称，如：guidInfoList.html
//参数：isHidden 表格是否是隐藏的,是为true,
//创建 zhao 2012-12-28
function onSetLayout(username, gridname, formname,isHidden) {
    //alert("配置表格布局onSetLayout() " + username);
    var grid = mini.get(gridname);             //获取表格对象
    var columns = grid.getBottomColumns();     //获取表格所有列集合

        columns = getColumns(columns);         //获取表格绑定列集合
          
    mini.open({
        url: BOOTPATH_GLOBAL_GRID + "GridLayoutSet.html",
        title: "表格布局设置",
        width: 600,
        height: 360,
        showMaxButton: true,
        showToolbar: false,
        showFooter: true,
        showModal: true,
        allowResize: true,
        allowDrag: true,
        onload: function () {
            var iframe = this.getIFrameEl();
            //把目标表格结构显示到当前表格中
            iframe.contentWindow.SetData(username,gridname, formname, columns);
        },
        ondestroy: function (action) {
            //重新设置表格布局
            if (action == "ok") {
                getGridLayout(username, gridname, formname, isHidden);
            }
        }
    });
}
//重置表格的默认布局
//一次只能重置一个表格布局
//删除掉自定义布局文件，命名规则如：SourceHotelList.html.datagrid1.txt
function onReSetLayout(username, gridname, formname) {
    if (username == "" || gridname == "" || formname == "") {
        alert("参数不完整！");
        return;
    }
    $.ajax({
        url: BOOTPATH_GLOBAL_GRID + "GridLayoutService.ashx?method=ReSetGridLayout",
        data: { UserName: username, GridViewName: gridname, FormName: formname },
        type: "post",
        success: function (text) {
            if (text == "") return;
            var o = mini.decode(text);
            if (o.bSuccess == true) {
                if (!o.error)                          
                   window.location.reload();//刷新原来的页面       
                else
                    alert("你没有保存过自定义布局，不需要重置。");    //emity           
            } else {
                alert(o.error);
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            alert(jqXHR.responseText); //显示获取布局失败的异常信息
        }
    });
}
//获取表格布局
//参数：username 用户名称，如：张国强
//参数：gridname 表格名称，如：datagrid1
//参数：formname 窗口名称，如：guidInfoList.html
//参数：isHidden 表格是否是隐藏的,是为true,
//创建 zhao 2012-12-28
//修改 zhao 2013-01-14 
//1、修改算法，提高重设表格布局速度
//2、增加同时给多个表重绘布局功能,如果gridname中含有逗号",",表示要给多个表布局
function getGridLayout(username, gridname, formname, isHidden) {
       
    var isMore = false;
    var method = "GetGridLayout";//默认查询一个表格的布局
    if (gridname.indexOf(",") > 0) {
        isMore = true;
        method = "GetGridLayouts";  //查询多个表
    }
    $.ajax({
        url: BOOTPATH_GLOBAL_GRID + "GridLayoutService.ashx?method=" + method,
        data: { UserName: username, GridViewName: gridname, FormName: formname },
        type: "post",
        success: function (text) {
            //alert(text);
            if (text == "") return;
            var o = mini.decode(text);           
            if (!o.error) {
                //如果存在布局信息就重置布局
                if (!isMore) {
                    //只有一个表                   
                    updateGridLayout(gridname, o.Layout);
                } else {
                    //多个表                     
                    var grids = gridname.split(',');
                    for (var i = 0; i < grids.length; i++) {
                        
                        if (i < o.length) { 
                            if (o[i].Layout) {
                                updateGridLayout(grids[i], o[i].Layout);
                            }
                        }
                    }
                }
                //alert("debug 5");
                //alert("布局完成");
            } else {
                //alert("加载布局失败：" + o.error);
            }
            if (isHidden) {
                showGrid(gridname);
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            if (isHidden) {
                showGrid(gridname);
            }
            //alert(jqXHR.responseText);//显示获取布局失败的异常信息
        }
    });
}

//使用于可编辑的列表。
//要考虑保留原来的编辑控件，速度慢。
function updateGridLayout(gridname, layoutInfo) {
    if (!layoutInfo) {
        alert("不存在布局信息");
        return;
   }
    var grid = mini.get(gridname);                   //获取表格对象   
    //alert("debug 1"); 
    var columns = mini.decode(layoutInfo);             //layout属性 含有布局信息
    //alert("debug 2"); 
    var old_columns = grid.getBottomColumns();       //获取表格所有列集合
    //alert("debug 3"); 
    var unbindColumns = getUnBindColumns(old_columns); //获取表格非绑定列集合 
    //alert("debug 4");    
    var index = 0;
    var myArray = new Array();
    //按返回的绑定列排序
    for (var i = 0; i < columns.length; i++) {            //遍历服务端返回的列
        var column = columns[i];
        for (var j = 0; j < old_columns.length; j++) {  //遍历克隆的列
            var clone_column = old_columns[j];
            if (column.field == clone_column.field) {
                clone_column.visible = column.visible;
                clone_column.header = column.header; //去掉所有空格
                clone_column.width = column.width;
                clone_column.headerAlign = column.headerAlign;
                clone_column.align = column.align;
                clone_column.cellStyle = column.cellStyle;
                myArray[index] = clone_column;                
                index++;
            }
        }
    }
    //alert("debug 5");
    columns = unbindColumns.concat(myArray);           //将多个数组连接为一个数组，返回连接好的新的数组 
    //alert("debug 6");
    grid.setColumns(columns);

}
//使用于不可编辑的列表。
//不考虑编辑控件等因素，速度快。
function updateGridLayoutSp1(gridname, layoutInfo) {
    var grid = mini.get(gridname);                     //获取表格对象   

    var columns = mini.decode(layoutInfo);             //layout属性 含有布局信息
    //alert("debug 1"); 
    var old_columns = grid.getBottomColumns();         //获取表格所有列集合
    //alert("debug 2"); 
    var unbindColumns = getUnBindColumns(old_columns); //获取表格非绑定列集合 
    //alert("debug 3"); 
    columns = unbindColumns.concat(columns);           //将多个数组连接为一个数组，返回连接好的新的数组
    //alert("debug 4");     
    grid.setColumns(columns);
    //alert("debug 4");
    //grid.updateColumn("HotelName", { cellStyle: "color:blue" });
    //alert("debug 5");   
}
//重置表格布局后再显示表格
function showGrid(gridname) {    
    var isMore = false;
    if (gridname.indexOf(",") > 0) {
        isMore = true;
    }   
     if (!isMore) {
          var grid = document.getElementById(gridname);
          grid.style.visibility="visible";//.display = "block";
          //alert("显示表格");
     } else { //多个表
          var grids = gridname.split(',');
          for (var i = 0; i < grids.length; i++) {
              var grid = document.getElementById(grids[i]);
              //alert(grid.style.display);
              grid.style.visibility="visible";  //display = "block";
          }   
     } 
}
//内部函数:获取表格绑定列集合
//创建
//修改 zhao 2013-1-14 不使用数组删除，提高速度
function getColumns(columns) {
    // var old_columns = columns.clone();
    var mycolumns = new Array();
    var j = 0;
    for (var i = 0; i < columns.length; i++) {
        var column = columns[i];
        if (column.field) {   //如果是绑定列(去掉不绑定字段的列)
            var stralign = (column.align) ? column.align : "left";
            var strheader = clearColumnHeader(column.header);          
            var c = { colvisible: column.visible, header: strheader, field: column.field, width: column.width, headerAlign: column.headerAlign, align: stralign };
            mycolumns[j] = c;
            j++;
        }
    }
    return columns;
}
//内部函数:获取表格非绑定列集合
//创建 zhao 2013-1-14 
//修改 zhao 2013-1-14 不使用数组删除，提高速度
function getUnBindColumns(columns) {
    var old_columns = columns.clone();
    var columns = new Array();
    var j = 0;
    for (var i = 0; i < old_columns.length ; i++) {
        var column = old_columns[i];
        if (!column.field) {   //去掉不绑定字段的列
            columns[j] = column;
            j++;
            if (j > 2) break;
        }
    }
    return columns;
}
//将表格控件当前页得数据导出到EXCEL
//创建 zhao 2012-12-28
function ExportExcel(gridname) {
    //alert("debug:01");
    var grid = mini.get(gridname);         //获取表格对象
    var columns = grid.getBottomColumns();     //获取表格所有列集合
    var columns = getColumns(columns);         //获取表格绑定列集合     
    //把表结构和数据都POST到服务端
    var gridcolumn = mini.encode(columns); //格式化表格列
    var griddata = mini.encode(grid.data); //格式化表格数据
    //alert("debug:02");
    var html = "";
        html+="<div id=\"outexceldiv\" name=\"outexceldiv\" style=\"display:none;\">";
        html+="<iframe id=\"exceliframe\" name=\"exceliframe\"  style=\"width:500px;height:50px;\"></iframe>";
        html += "<form id=\"excelform\"  name=\"excelform\" method=\"post\" target=\"exceliframe\" action=\"" + BOOTPATH_GLOBAL_GRID + "exportService.ashx?type=excel\">";
        html+="    <input type=\"hidden\" id=\"exgridcolumns\" name=\"exgridcolumns\" value=\"\"/>";
        html+="    <input type=\"hidden\" id=\"exgriddata\"  name=\"exgriddata\" value=\"\"/>";
        html+="</form>";
        html += "</div>";
        $("#outexceldiv").remove();    //移除原有的节点
        $("body").append(html);        //插入新节点
        $("#exgridcolumns").val(gridcolumn);  //设置列到表单控件exgridcolumns
        $("#exgriddata").val(griddata);       //设置数据到表单控件exgriddata                   
        $("form#excelform").submit();         //提交表单 
  }
    //清理列标题，去掉列标题中的空格和\t字符
    //创建 zhao 2013-1-29
  function clearColumnHeader(headtext) {
      headtext = headtext.replace(/(^\s*)|(\s*$)|(\n)/g, "");
      headtext = headtext.replace(/\s+/g, "");
      headtext = headtext.replace(/\t+/g, "");
      headtext = headtext.replace(/\n+/g, "");
      return headtext;
}