﻿// ****************************************************** 
// 文件名称(File Name)：       Suppliers.cs
// 项目名称(Project Name)：    YourProjectName
// 功能描述(Description)：     供应商 （数据模型）
// 数据表(Tables)：            Suppliers（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
// 作者(Author)：              zhaoshunlu@163.com
// 日期(Create Date)：         2014-10-21 22:17:27
// 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
// 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
// 编码约定：                   命名规则(类名和属性名首字母必须大写)
// 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
//****************************************************** 
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Newtonsoft.Json; //[JsonIgnore]//使用JsonConvert序列化时不序列化此字段

namespace Northwind.Model {

    //保持与架构无关性的POCO类

    //命名规则：类名和属性名首字母必须大写    

    /// <summary>
    /// 供应商（Suppliers）
    /// </summary>               
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class Suppliers : Northwind.Model._common {
        /// <summary>
        /// 供应商
        /// </summary>
        public Suppliers() {
            //不允许null的属性及设置有默认值的属性
			this.SupplierID = 0 ;			// 供应商ID Not NULL 
			this.CompanyName = "" ;			// 公司名称 Not NULL 

			//Productss = new List<Products>();  

        }

		/// <summary>
		/// 供应商ID (Not NULL)
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "供应商ID")]
        public int SupplierID {get;set;}
		/// <summary>
		/// 公司名称 (Not NULL)
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "公司名称")]
        public string CompanyName {get;set;}
		/// <summary>
		/// 联系人名称 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "联系人名称")]
        public string ContactName {get;set;}
		/// <summary>
		/// 联系人职务 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "联系人职务")]
        public string ContactTitle {get;set;}
		/// <summary>
		/// 地址 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "地址")]
        public string Address {get;set;}
		/// <summary>
		/// 城市 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "城市")]
        public string City {get;set;}
		/// <summary>
		/// 地区 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "地区")]
        public string Region {get;set;}
		/// <summary>
		/// 邮政编码 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "邮政编码")]
        public string PostalCode {get;set;}
		/// <summary>
		/// 国家 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "国家")]
        public string Country {get;set;}
		/// <summary>
		/// 电话 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "电话")]
        public string Phone {get;set;}
		/// <summary>
		/// 传真 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "传真")]
        public string Fax {get;set;}
		/// <summary>
		/// 主页 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "主页")]
        public string HomePage {get;set;}


	    ///// <summary> 
	    ///// 产品(子表) 
	    ///// </summary> 
	    //public virtual IList<Products> Productss {get;set;} 


        
    }
}